/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.legacy.util;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.util.LabelValueBean;
import org.apache.struts.util.MessageResources;
import org.rhq.core.clientapi.util.units.DateFormatter;
import org.rhq.core.domain.measurement.MeasurementUnits;
import org.rhq.core.domain.measurement.composite.MeasurementNumericValueAndUnits;
import org.rhq.core.domain.measurement.composite.MeasurementValueAndUnits;
import org.rhq.core.server.MeasurementConverter;
import org.rhq.enterprise.server.measurement.uibean.MetricDisplaySummary;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class MonitorUtils {
    private static Log log = LogFactory.getLog(MonitorUtils.class);
    public static final String RO = "ro";
    public static final String LASTN = "lastN";
    public static final String UNIT = "unit";
    public static final String BEGIN = "begin";
    public static final String END = "end";
    public static final int DEFAULT_CURRENTHEALTH_LASTN = 8;
    public static final int THRESHOLD_BASELINE_VALUE = 1;
    public static final String THRESHOLD_BASELINE_LABEL = "Baseline";
    public static final int THRESHOLD_HIGH_RANGE_VALUE = 2;
    public static final String THRESHOLD_HIGH_RANGE_LABEL = "HighRange";
    public static final int THRESHOLD_LOW_RANGE_VALUE = 3;
    public static final String THRESHOLD_LOW_RANGE_LABEL = "LowRange";
    public static final int THRESHOLD_UNDER_VALUE = 1;
    public static final int THRESHOLD_OVER_VALUE = 2;

    public static Integer formatMetrics(List<MetricDisplaySummary> metricDisplaySummaries, Locale userLocale, MessageResources msgs) {
        Integer resourceCount = null;
        try {
            for (MetricDisplaySummary metricDisplaySummary : metricDisplaySummaries) {
                MeasurementValueAndUnits[] formattedValues;
                if (Double.isNaN(metricDisplaySummary.getAvgMetric().getValue())) continue;
                if (resourceCount == null) {
                    resourceCount = metricDisplaySummary.getAvailUp();
                }
                if (metricDisplaySummary.getUnits().length() < 1) {
                    metricDisplaySummary.setUnits(MeasurementUnits.NONE.name());
                }
                if (msgs.isPresent(userLocale, "unit.format." + metricDisplaySummary.getUnits())) {
                    String fmtString = msgs.getMessage(userLocale, "unit.format." + metricDisplaySummary.getUnits());
                    if (metricDisplaySummary.getUnits().equals(MeasurementUnits.EPOCH_MILLISECONDS.name())) {
                        DateFormatter.DateSpecifics dateSpecifics = new DateFormatter.DateSpecifics();
                        dateSpecifics.setDateFormat((DateFormat)new SimpleDateFormat(fmtString, userLocale));
                        formattedValues = MonitorUtils.getMeasurementValueAndUnits((double[])metricDisplaySummary.getMetricValueDoubles(), (String)metricDisplaySummary.getUnits());
                    } else {
                        formattedValues = MonitorUtils.getMeasurementValueAndUnits((double[])metricDisplaySummary.getMetricValueDoubles(), (String)metricDisplaySummary.getUnits());
                    }
                } else {
                    formattedValues = MonitorUtils.getMeasurementValueAndUnits((double[])metricDisplaySummary.getMetricValueDoubles(), (String)metricDisplaySummary.getUnits());
                }
                String[] keys = metricDisplaySummary.getMetricKeys();
                if (keys.length != formattedValues.length) {
                    throw new IllegalStateException("Formatting metrics failed.");
                }
                for (int i = 0; i < keys.length; ++i) {
                    MeasurementValueAndUnits valueAndUnits = formattedValues[i];
                    String formatted = MeasurementConverter.format((Double)((Double)valueAndUnits.getValue()), (MeasurementUnits)valueAndUnits.getUnits(), (boolean)true);
                    metricDisplaySummary.getMetric(keys[i]).setValueFmt(formatted);
                }
            }
        }
        catch (IllegalArgumentException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"formatting metrics failed due to IllegalArgumentException: ", (Throwable)e);
            }
            throw e;
        }
        return resourceCount;
    }

    public static void formatSimpleMetrics(MetricDisplaySummary summary, Locale userLocale) {
        if (!Double.isNaN(summary.getAvgMetric().getValue())) {
            if (summary.getUnits().length() < 1) {
                summary.setUnits(MeasurementUnits.NONE.name());
            }
            String[] formattedValues = MeasurementConverter.formatToSignificantPrecision((double[])summary.getMetricValueDoubles(), (MeasurementUnits)MeasurementUnits.valueOf((String)summary.getUnits()), (boolean)true);
            String[] metricKeys = summary.getMetricKeys();
            for (int i = 0; i < metricKeys.length; ++i) {
                summary.getMetric(metricKeys[i]).setValueFmt(formattedValues[i]);
            }
        }
    }

    public static MeasurementValueAndUnits[] getMeasurementValueAndUnits(double[] metricValueDoubles, String units) {
        MeasurementValueAndUnits[] valueAndUnitsList = new MeasurementValueAndUnits[metricValueDoubles.length];
        int i = 0;
        double[] arr$ = metricValueDoubles;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Double metricValue = arr$[i$];
            valueAndUnitsList[i] = new MeasurementNumericValueAndUnits(metricValue, MeasurementUnits.valueOf((String)units));
            ++i;
        }
        return valueAndUnitsList;
    }

    public static List<LabelValueBean> getThresholdMenu() {
        ArrayList<LabelValueBean> items = new ArrayList<LabelValueBean>();
        String label = null;
        String value = null;
        label = "Baseline";
        value = String.valueOf(1);
        items.add(new LabelValueBean(label, value));
        label = "HighRange";
        value = String.valueOf(2);
        items.add(new LabelValueBean(label, value));
        label = "LowRange";
        value = String.valueOf(3);
        items.add(new LabelValueBean(label, value));
        return items;
    }
}

