/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.common.servlet;

import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.enterprise.gui.common.servlet.ImageServlet;
import org.rhq.enterprise.gui.image.WebImage;
import org.rhq.enterprise.gui.image.widget.ResourceTree;

public class NavMapImageServlet
extends ImageServlet {
    public static final String TREE_VAR_PARAM = "treeVar";
    public static final int IMAGE_WIDTH_DEFAULT = 800;
    private Log log = LogFactory.getLog((String)NavMapImageServlet.class.getName());
    private String treeVar;

    protected Object createImage(HttpServletRequest request) throws ServletException {
        ResourceTree image = (ResourceTree)request.getSession().getAttribute(this.treeVar);
        request.getSession().removeAttribute(this.treeVar);
        return image;
    }

    protected void renderPngImage(ServletOutputStream out, Object imgObj) throws IOException {
        WebImage image = (WebImage)imgObj;
        if (null != image) {
            image.writePngImage((OutputStream)out);
        }
    }

    protected void renderJpegImage(ServletOutputStream out, Object imgObj) throws IOException {
        WebImage image = (WebImage)imgObj;
        if (null != image) {
            image.writeJpegImage((OutputStream)out);
        }
    }

    protected void parseParameters(HttpServletRequest request) {
        super.parseParameters(request);
        this.treeVar = this.parseRequiredStringParameter(request, TREE_VAR_PARAM);
        this._logParameters();
    }

    protected int getDefaultImageWidth() {
        return 800;
    }

    private void _logParameters() {
        if (this.log.isDebugEnabled()) {
            StringBuffer sb = new StringBuffer("Parameters:");
            sb.append("\n");
            sb.append("\t");
            sb.append(TREE_VAR_PARAM);
            sb.append(": ");
            sb.append(this.treeVar);
            this.log.debug((Object)sb.toString());
        }
    }
}

