/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.event;

import java.util.Arrays;
import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import javax.faces.model.DataModel;
import javax.faces.model.SelectItem;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.event.EventSeverity;
import org.rhq.core.domain.event.composite.EventComposite;
import org.rhq.core.gui.util.FacesContextUtility;
import org.rhq.core.gui.util.StringUtility;
import org.rhq.enterprise.gui.common.converter.SelectItemUtils;
import org.rhq.enterprise.gui.common.framework.PagedDataTableUIBean;
import org.rhq.enterprise.gui.common.paging.PageControlView;
import org.rhq.enterprise.gui.event.EventHistoryUIBean;
import org.rhq.enterprise.gui.util.WebUtility;
import org.rhq.enterprise.server.common.EntityContext;
import org.rhq.enterprise.server.event.EventException;
import org.rhq.enterprise.server.event.EventManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

public class EventHistoryUIBean
extends PagedDataTableUIBean {
    private final Log log = LogFactory.getLog(this.getClass());
    private EventManagerLocal eventManager = LookupUtil.getEventManager();
    public static final String MANAGED_BEAN_NAME = "EventHistoryUIBean";
    private EntityContext context = WebUtility.getEntityContext();
    private String[] severityFilter;
    private String sourceFilter;
    private String searchFilter;
    private SelectItem[] severityFilterSelectItems;
    private EventComposite selectedEvent;
    private Integer eventId;

    public EventHistoryUIBean() {
        SelectItem[] defaultSelectedItems = this.getSeverityFilterSelectItems();
        this.severityFilter = new String[defaultSelectedItems.length];
        for (int i = 0; i < this.severityFilter.length; ++i) {
            this.severityFilter[i] = (String)defaultSelectedItems[i].getValue();
        }
    }

    public EntityContext getContext() {
        return this.context;
    }

    public String[] getSeverityFilter() {
        if (this.severityFilter == null || this.severityFilter.length == 0) {
            FacesContext facesContext = FacesContextUtility.getFacesContext();
            HttpServletRequest request = (HttpServletRequest)facesContext.getExternalContext().getRequest();
            this.severityFilter = request.getParameterValues("eventHistoryForm:severityFilter");
        }
        return this.severityFilter;
    }

    public void setSeverityFilter(String[] severityFilter) {
        this.severityFilter = severityFilter;
    }

    public SelectItem[] getSeverityFilterSelectItems() {
        if (this.severityFilterSelectItems == null) {
            this.severityFilterSelectItems = SelectItemUtils.convertFromEnum(EventSeverity.class, (boolean)false);
        }
        return this.severityFilterSelectItems;
    }

    public void setSeverityFilterSelectItems(SelectItem[] sevFilterSelectItems) {
        this.severityFilterSelectItems = sevFilterSelectItems;
    }

    public String getSourceFilter() {
        if (this.sourceFilter == null) {
            this.sourceFilter = FacesContextUtility.getOptionalRequestParameter((String)"eventHistoryForm:sourceFilter");
        }
        return this.sourceFilter;
    }

    public void setSourceFilter(String sourceFilter) {
        this.sourceFilter = sourceFilter;
    }

    public String getSearchFilter() {
        if (this.searchFilter == null) {
            this.searchFilter = FacesContextUtility.getOptionalRequestParameter((String)"eventHistoryForm:searchFilter");
        }
        return this.searchFilter;
    }

    public void setSearchFilter(String searchFilter) {
        this.searchFilter = searchFilter;
    }

    public void populateEventId(Integer eventId) {
        this.eventId = eventId;
        this.selectedEvent = null;
    }

    public EventComposite getSelectedEvent() {
        if (this.selectedEvent == null && this.eventId != null) {
            try {
                this.selectedEvent = this.eventManager.getEventDetailForEventId(this.getSubject(), this.eventId.intValue());
            }
            catch (EventException ee) {
                this.selectedEvent = null;
            }
        }
        return this.selectedEvent;
    }

    public String deleteSelectedEvents() {
        String[] selectedEvents = this.getSelectedEvents();
        Integer[] eventIds = StringUtility.getIntegerArray((String[])selectedEvents);
        try {
            int numDeleted = this.eventManager.deleteEvents(this.getSubject(), Arrays.asList(eventIds));
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_INFO, (String)("Deleted " + numDeleted + " events."));
        }
        catch (Exception e) {
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)"Failed to delete selected events.", (Throwable)e);
        }
        return "success";
    }

    public String purgeAllEvents() {
        try {
            int numDeleted = 0;
            if (this.context.category == EntityContext.Category.Resource) {
                numDeleted = this.eventManager.deleteAllEventsForResource(this.getSubject(), this.context.resourceId);
            } else if (this.context.category == EntityContext.Category.ResourceGroup) {
                numDeleted = this.eventManager.deleteAllEventsForCompatibleGroup(this.getSubject(), this.context.groupId);
            } else {
                this.log.error((Object)this.context.getUnknownContextMessage());
            }
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_INFO, (String)("Deleted " + numDeleted + " events"));
        }
        catch (Exception e) {
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)"Failed to delete events", (Throwable)e);
            this.log.error((Object)("Failed to delete events for " + this.context), (Throwable)e);
        }
        return "success";
    }

    public DataModel getDataModel() {
        if (this.dataModel == null) {
            this.dataModel = new ListEventsHistoryDataModel(this, PageControlView.EventsHistoryList, MANAGED_BEAN_NAME);
        }
        return this.dataModel;
    }

    private String[] getSelectedEvents() {
        return FacesContextUtility.getRequest().getParameterValues("selectedEvents");
    }

    private EventSeverity[] getEventSeverity() {
        String[] severityNames = this.getSeverityFilter();
        if (severityNames != null) {
            EventSeverity[] severities = new EventSeverity[severityNames.length];
            for (int i = 0; i < severityNames.length; ++i) {
                severities[i] = Enum.valueOf(EventSeverity.class, severityNames[i]);
            }
            return severities;
        }
        return null;
    }

    static /* synthetic */ EventSeverity[] access$000(EventHistoryUIBean x0) {
        return x0.getEventSeverity();
    }

    static /* synthetic */ EntityContext access$100(EventHistoryUIBean x0) {
        return x0.context;
    }

    static /* synthetic */ EventManagerLocal access$200(EventHistoryUIBean x0) {
        return x0.eventManager;
    }
}

