/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.legacy.action.resource.group.inventory;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.util.LabelValueBean;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceCategory;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.domain.resource.composite.DisambiguationReport;
import org.rhq.core.domain.resource.composite.ResourceNamesDisambiguationResult;
import org.rhq.core.domain.resource.group.GroupCategory;
import org.rhq.core.domain.resource.group.ResourceGroup;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageList;
import org.rhq.core.util.IntExtractor;
import org.rhq.enterprise.gui.legacy.action.resource.group.inventory.AddGroupResourcesForm;
import org.rhq.enterprise.gui.legacy.util.DisambiguatedResourceListUtil;
import org.rhq.enterprise.gui.legacy.util.RequestUtils;
import org.rhq.enterprise.gui.legacy.util.SessionUtils;
import org.rhq.enterprise.gui.util.WebUtility;
import org.rhq.enterprise.server.resource.ResourceManagerLocal;
import org.rhq.enterprise.server.resource.group.ResourceGroupManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class AddGroupResourcesFormPrepareAction
extends Action {
    private static final String CATEGORY_ALL = "None";
    private static final IntExtractor<Resource> RESOURCE_ID_EXTRACTOR = new /* Unavailable Anonymous Inner Class!! */;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Log log = LogFactory.getLog(AddGroupResourcesFormPrepareAction.class);
        Subject user = RequestUtils.getSubject((HttpServletRequest)request);
        AddGroupResourcesForm addForm = (AddGroupResourcesForm)form;
        Integer groupId = addForm.getGroupId();
        PageControl pcAvail = WebUtility.getPageControl((ServletRequest)request, (String)"a");
        PageControl pcPending = WebUtility.getPageControl((ServletRequest)request, (String)"p");
        log.trace((Object)("available page control: " + pcAvail));
        log.trace((Object)("pending page control: " + pcPending));
        log.trace((Object)("getting group [" + groupId + "]"));
        List pendingResourceIdStrings = SessionUtils.getListAsListStr((HttpSession)request.getSession(), (String)"PendingSessionResources");
        int[] pendingResourceIds = new int[pendingResourceIdStrings.size()];
        int sz = pendingResourceIdStrings.size();
        for (int i = 0; i < sz; ++i) {
            pendingResourceIds[i] = Integer.parseInt((String)pendingResourceIdStrings.get(i));
        }
        ResourceManagerLocal resourceManager = LookupUtil.getResourceManager();
        ResourceGroupManagerLocal resourceGroupManager = LookupUtil.getResourceGroupManager();
        log.trace((Object)("getting pending resources for group [" + groupId + "]"));
        PageList pendingResources = resourceManager.findResourceByIds(user, pendingResourceIds, true, pcPending);
        PageList disambiguatedpeningResources = DisambiguatedResourceListUtil.disambiguate((ResourceManagerLocal)resourceManager, (PageList)pendingResources, (IntExtractor)RESOURCE_ID_EXTRACTOR);
        request.setAttribute("PendingResources", (Object)disambiguatedpeningResources);
        request.setAttribute("NumPendingResources", (Object)disambiguatedpeningResources.size());
        log.trace((Object)("getting available resources for group [" + groupId + "]"));
        String nameFilter = RequestUtils.getStringParameter((HttpServletRequest)request, (String)"nameFilter", null);
        ResourceGroup resourceGroup = resourceGroupManager.getResourceGroupById(user, groupId.intValue(), null);
        PageList availableResources = null;
        if (resourceGroup.getGroupCategory() == GroupCategory.COMPATIBLE) {
            ResourceType compatibleTypeFilter = resourceGroup.getResourceType();
            availableResources = resourceManager.findAvailableResourcesForResourceGroup(user, groupId.intValue(), compatibleTypeFilter, null, nameFilter, pendingResourceIds, pcAvail);
        } else if (resourceGroup.getGroupCategory() == GroupCategory.MIXED) {
            ResourceCategory resourceCategory = this.getResourceCategory(addForm.getFilterBy());
            availableResources = resourceManager.findAvailableResourcesForResourceGroup(user, groupId.intValue(), null, resourceCategory, nameFilter, pendingResourceIds, pcAvail);
            addForm.setAvailResourceTypes(AddGroupResourcesFormPrepareAction.buildResourceTypes());
        } else {
            throw new IllegalArgumentException("AddGroupResourcesFormPrepareAction does not support '" + resourceGroup.getClass().getSimpleName() + " group type");
        }
        PageList disambiguatedAvailResources = DisambiguatedResourceListUtil.disambiguate((ResourceManagerLocal)resourceManager, (PageList)availableResources, (IntExtractor)RESOURCE_ID_EXTRACTOR);
        request.setAttribute("AvailableResources", (Object)disambiguatedAvailResources);
        request.setAttribute("NumAvailableResources", (Object)disambiguatedAvailResources.size());
        return null;
    }

    private ResourceCategory getResourceCategory(String categoryFilter) {
        if (categoryFilter == null || categoryFilter.equals("None")) {
            return null;
        }
        return ResourceCategory.valueOf((String)categoryFilter);
    }

    private static List<LabelValueBean> buildResourceTypes() {
        ArrayList<LabelValueBean> resourceCategoryTypes = new ArrayList<LabelValueBean>();
        resourceCategoryTypes.add(new LabelValueBean("None", "None"));
        for (ResourceCategory category : ResourceCategory.values()) {
            resourceCategoryTypes.add(new LabelValueBean(category.toString(), category.name()));
        }
        return resourceCategoryTypes;
    }

    private static PageList<Resource> buildResourceList(ResourceNamesDisambiguationResult<Resource> results, int totalSize, PageControl pageControl) {
        ArrayList<Resource> convertedResults = new ArrayList<Resource>(results.getResolution().size());
        for (DisambiguationReport dr : results.getResolution()) {
            Resource resource = (Resource)dr.getOriginal();
            Resource parent = resource.getParentResource();
            if (parent != null) {
                parent.setName(AddGroupResourcesFormPrepareAction.buildLineage((List)dr.getParents()));
            }
            convertedResults.add(resource);
        }
        return new PageList(convertedResults, totalSize, pageControl);
    }

    private static String buildLineage(List<DisambiguationReport.Resource> parents) {
        if (parents == null || parents.size() == 0) {
            return "";
        }
        Iterator<DisambiguationReport.Resource> it = parents.iterator();
        StringBuilder bld = new StringBuilder(it.next().getName());
        while (it.hasNext()) {
            bld.append(" > ").append(it.next().getName());
        }
        return bld.toString();
    }
}

