/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.legacy.beans;

import java.io.Serializable;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.measurement.composite.MeasurementDataNumericHighLowComposite;
import org.rhq.enterprise.gui.image.data.IComparableDatapoint;
import org.rhq.enterprise.gui.image.data.IDisplayDataPoint;
import org.rhq.enterprise.server.measurement.AvailabilityPoint;

public class NumericMetricDataPoint
implements IDisplayDataPoint,
IComparableDatapoint,
Serializable {
    private long timestamp;
    private double value;

    public NumericMetricDataPoint(MeasurementDataNumericHighLowComposite dataPoint) {
        this.timestamp = dataPoint.getTimestamp();
        this.value = dataPoint.getValue();
    }

    public NumericMetricDataPoint(AvailabilityPoint availabilityPoint) {
        this.timestamp = availabilityPoint.getTimestamp();
        this.value = availabilityPoint.getAvailabilityType() == AvailabilityType.UP ? 100.0 : 0.0;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String getLabel() {
        return SimpleDateFormat.getDateTimeInstance().format(this.timestamp);
    }

    public double getValue() {
        return this.value;
    }

    public Double getObjectValue() {
        return this.value;
    }

    public int compareTo(Object obj) {
        NumericMetricDataPoint that = (NumericMetricDataPoint)obj;
        double difference = this.value - that.value;
        if (difference < 0.0) {
            return -1;
        }
        if (difference > 0.0) {
            return 1;
        }
        return 0;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        NumericMetricDataPoint that = (NumericMetricDataPoint)obj;
        if (this.timestamp != that.timestamp) {
            return false;
        }
        return Double.compare(that.value, this.value) == 0;
    }

    public int hashCode() {
        int result = (int)(this.timestamp ^ this.timestamp >>> 32);
        long temp = this.value != 0.0 ? Double.doubleToLongBits(this.value) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public String toString() {
        if (Double.isNaN(this.getValue())) {
            return "NaN";
        }
        return NumberFormat.getInstance().format(this.getValue());
    }
}

