/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.client;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.rhq.core.domain.cloud.Server;
import org.rhq.core.util.MessageDigestGenerator;
import org.rhq.core.util.stream.StreamUtil;
import org.rhq.enterprise.server.core.CoreServerMBean;
import org.rhq.enterprise.server.util.LookupUtil;

public class RemoteClientServlet
extends HttpServlet {
    private static final String RHQ_SERVER_VERSION = "rhq-server.version";
    private static final String RHQ_SERVER_BUILD_NUMBER = "rhq-server.build-number";
    private static final String RHQ_CLIENT_MD5 = "rhq-client.md5";
    private static final long serialVersionUID = 1L;
    private static String SYSPROP_CLIENT_DOWNLOADS_LIMIT = "rhq.server.client-downloads-limit";
    private static int DEFAULT_CLIENT_DOWNLOADS_LIMIT = 5;
    private static final int ERROR_CODE_CLIENT_UPDATE_DISABLED = 403;
    private static final int ERROR_CODE_TOO_MANY_DOWNLOADS = 503;
    private static int numActiveDownloads = 0;

    public void init() throws ServletException {
        this.log("Starting the remote client servlet");
        try {
            this.log("Remote Client Binary File: " + this.getRemoteClientZip());
        }
        catch (Throwable t) {
            this.log("Remote client is not available for deployment. Cause: " + t.toString());
            return;
        }
        try {
            File versionFile = this.getVersionFile();
            this.log(versionFile + ": " + new String(StreamUtil.slurp((InputStream)new FileInputStream(versionFile))));
        }
        catch (Throwable t) {
            this.log("Cannot determine the remote client version information", t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String servletPath = req.getServletPath();
        if (servletPath != null) {
            if (this.isServerAcceptingRequests()) {
                if (servletPath.endsWith("version")) {
                    this.getVersion(req, resp);
                } else if (servletPath.endsWith("download")) {
                    try {
                        ++numActiveDownloads;
                        this.getDownload(req, resp);
                    }
                    finally {
                        --numActiveDownloads;
                    }
                } else {
                    resp.sendError(400, "Invalid servlet path [" + servletPath + "] - please contact administrator");
                }
            } else {
                this.sendErrorServerNotAcceptingRequests(resp);
            }
        } else {
            resp.sendError(400, "Invalid servlet path - please contact administrator");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getDownload(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        int limit = this.getDownloadLimit();
        if (limit <= 0) {
            this.sendErrorDownloadDisabled(resp);
            return;
        }
        if (limit < numActiveDownloads) {
            this.sendErrorTooManyDownloads(resp);
            return;
        }
        try {
            File zip = this.getRemoteClientZip();
            if (!zip.exists()) {
                this.disableBrowserCache(resp);
                resp.sendError(404, "Remote Client binary does not exist: " + zip.getName());
                return;
            }
            resp.setContentType("application/octet-stream");
            resp.setHeader("Content-Disposition", "attachment; filename=" + zip.getName());
            resp.setContentLength((int)zip.length());
            resp.setDateHeader("Last-Modified", zip.lastModified());
            FileInputStream zipStream = new FileInputStream(zip);
            try {
                StreamUtil.copy((InputStream)zipStream, (OutputStream)resp.getOutputStream(), (boolean)false);
            }
            finally {
                zipStream.close();
            }
        }
        catch (Throwable t) {
            this.log("Failed to stream remote client zip", t);
            this.disableBrowserCache(resp);
            resp.sendError(500, "Failed to stream remote client zip");
        }
    }

    private File getRemoteClientZip() throws Exception {
        File dir = this.getDownloadDir();
        for (File file : dir.listFiles()) {
            if (!file.getName().endsWith(".zip")) continue;
            return file;
        }
        throw new FileNotFoundException("Missing remote client binary in [" + dir + "]");
    }

    private File getDownloadDir() throws Exception {
        File serverHomeDir = LookupUtil.getCoreServer().getJBossServerHomeDir();
        File downloadDir = new File(serverHomeDir, "deploy/rhq.ear/rhq-downloads/rhq-client");
        if (!downloadDir.exists()) {
            throw new FileNotFoundException("Missing remote client download directory at [" + downloadDir + "]");
        }
        return downloadDir;
    }

    private void getVersion(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        try {
            File versionFile = this.getVersionFile();
            resp.setContentType("text/plain");
            resp.setDateHeader("Last-Modified", versionFile.lastModified());
            FileInputStream stream = new FileInputStream(versionFile);
            byte[] versionData = StreamUtil.slurp((InputStream)stream);
            resp.getOutputStream().write(versionData);
        }
        catch (Throwable t) {
            this.log("Failed to stream version info", t);
            this.disableBrowserCache(resp);
            resp.sendError(500, "Failed to stream version info");
        }
    }

    private int getDownloadLimit() {
        int limit;
        String limitStr = System.getProperty(SYSPROP_CLIENT_DOWNLOADS_LIMIT);
        try {
            limit = Integer.parseInt(limitStr);
        }
        catch (Exception e) {
            limit = DEFAULT_CLIENT_DOWNLOADS_LIMIT;
            this.log("Remote Client downloads limit system property [" + SYSPROP_CLIENT_DOWNLOADS_LIMIT + "] is either not set or invalid [" + limitStr + "] - limit will be [" + limit + "]");
        }
        return limit;
    }

    private void disableBrowserCache(HttpServletResponse resp) {
        resp.setHeader("Cache-Control", "no-cache");
        resp.setHeader("Expires", "-1");
        resp.setHeader("Pragma", "no-cache");
    }

    private void sendErrorServerNotAcceptingRequests(HttpServletResponse resp) throws IOException {
        this.disableBrowserCache(resp);
        resp.sendError(403, "Server Is Down For Maintenance");
    }

    private void sendErrorDownloadDisabled(HttpServletResponse resp) throws IOException {
        this.disableBrowserCache(resp);
        resp.sendError(403, "Client Download Has Been Disabled");
    }

    private void sendErrorTooManyDownloads(HttpServletResponse resp) throws IOException {
        this.disableBrowserCache(resp);
        resp.setHeader("Retry-After", "30");
        resp.sendError(503, "Maximum limit exceeded - download client later");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File getVersionFile() throws Exception {
        File versionFile = new File(this.getDownloadDir(), "rhq-client-version.properties");
        if (!versionFile.exists()) {
            StringBuilder serverVersionInfo = new StringBuilder();
            CoreServerMBean coreServer = LookupUtil.getCoreServer();
            serverVersionInfo.append("rhq-server.version=").append(coreServer.getVersion()).append('\n');
            serverVersionInfo.append("rhq-server.build-number=").append(coreServer.getBuildNumber()).append('\n');
            File zip = this.getRemoteClientZip();
            String md5Property = "rhq-client.md5=" + MessageDigestGenerator.getDigestString((File)zip) + '\n';
            FileOutputStream versionFileOutputStream = new FileOutputStream(versionFile);
            try {
                versionFileOutputStream.write(serverVersionInfo.toString().getBytes());
                versionFileOutputStream.write(md5Property.getBytes());
            }
            finally {
                try {
                    versionFileOutputStream.close();
                }
                catch (Exception e) {}
            }
        }
        return versionFile;
    }

    private boolean isServerAcceptingRequests() {
        try {
            Server.OperationMode mode = LookupUtil.getServerManager().getServer().getOperationMode();
            return mode == Server.OperationMode.NORMAL;
        }
        catch (Exception e) {
            return false;
        }
    }
}

