/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.common.metric;

import com.sun.faces.util.MessageUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.Renderer;
import org.rhq.enterprise.gui.common.metric.MetricComponent;
import org.rhq.enterprise.server.measurement.MeasurementPreferences;

public class MetricRenderer
extends Renderer {
    private final List<Integer> timeIntervalValues = Arrays.asList(4, 8, 12, 24, 30, 36, 48, 60, 90, 120);

    public void decode(FacesContext context, UIComponent component) {
        super.decode(context, component);
        if (context == null) {
            throw new NullPointerException(MessageUtils.getExceptionMessageString((String)"com.sun.faces.NULL_PARAMETERS_ERROR", (Object[])new Object[]{"context"}));
        }
        if (component == null) {
            throw new NullPointerException(MessageUtils.getExceptionMessageString((String)"com.sun.faces.NULL_PARAMETERS_ERROR", (Object[])new Object[]{"component"}));
        }
        if (!component.isRendered()) {
            return;
        }
    }

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        MetricComponent metric = (MetricComponent)component;
        MeasurementPreferences.MetricRangePreferences rangePreferences = metric.getMetricRangePreferences();
        MetricComponent.TimeUnit preferencesUnit = null;
        int lastN = 0;
        writer.startElement("b", null);
        writer.write("Metric Display Range:");
        writer.endElement("b");
        writer.write(" ");
        if (rangePreferences.readOnly) {
            writer.write(new Date(rangePreferences.begin) + " to " + new Date(rangePreferences.end));
            writer.write(" ");
        } else {
            preferencesUnit = MetricComponent.TimeUnit.getUnitByMetricOrdinal((int)rangePreferences.unit);
            lastN = rangePreferences.lastN;
            writer.write("Last :");
            writer.write(" ");
            writer.startElement("select", (UIComponent)metric);
            writer.writeAttribute("id", (Object)"metricComponentValue", null);
            writer.writeAttribute("name", (Object)"metricComponentValue", null);
            ArrayList<Integer> timeIntervals = new ArrayList<Integer>(this.timeIntervalValues);
            if (!timeIntervals.contains(lastN)) {
                timeIntervals.add(lastN);
            }
            Collections.sort(timeIntervals);
            Iterator i$ = timeIntervals.iterator();
            while (i$.hasNext()) {
                int timeIntervalOption = (Integer)i$.next();
                writer.startElement("option", (UIComponent)metric);
                writer.writeAttribute("value", (Object)timeIntervalOption, "metricComponentValue");
                if (timeIntervalOption == lastN) {
                    writer.writeAttribute("SELECTED", (Object)"SELECTED", null);
                }
                writer.write(String.valueOf(timeIntervalOption));
                writer.endElement("option");
            }
            writer.endElement("select");
            writer.write(" ");
            writer.startElement("select", (UIComponent)metric);
            writer.writeAttribute("id", (Object)"metricComponentUnit", null);
            writer.writeAttribute("name", (Object)"metricComponentUnit", null);
            for (MetricComponent.TimeUnit unit : metric.getUnitOptions()) {
                writer.startElement("option", (UIComponent)metric);
                writer.writeAttribute("value", (Object)unit.name(), "metricComponentUnit");
                if (unit.equals((Object)preferencesUnit)) {
                    writer.writeAttribute("SELECTED", (Object)"SELECTED", null);
                }
                writer.write(unit.getDisplayName());
                writer.endElement("option");
            }
            writer.endElement("select");
            writer.write(" ");
        }
        writer.write(" ");
        writer.startElement("a", null);
        writer.writeAttribute("href", (Object)"#", null);
        writer.writeAttribute("onclick", (Object)("javascript:window.open('/rhq/common/metric/advanced.xhtml','MetricDisplayRangeSettings','" + this.getWindowOptions() + "');"), null);
        if (rangePreferences.readOnly) {
            writer.write("Edit Settings...");
        } else {
            writer.write("Advanced Settings...");
        }
        writer.endElement("a");
        if (rangePreferences.readOnly) {
            writer.write(" | ");
        }
        writer.startElement("script", null);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        if (!rangePreferences.readOnly) {
            writer.write("changeComboBox('metricComponentValue','" + lastN + "');");
            writer.write("changeComboBox('metricComponentUnit','" + preferencesUnit.name() + "');");
        }
        writer.endElement("script");
    }

    private String getWindowOptions() {
        StringBuilder builder = new StringBuilder();
        builder.append("width=450");
        builder.append(",height=375");
        return builder.toString();
    }
}

