/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.legacy.action;

import java.util.Calendar;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.action.ActionError;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionMapping;
import org.rhq.enterprise.gui.legacy.action.CalendarForm;
import org.rhq.enterprise.gui.legacy.beans.OptionItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScheduleForm
extends CalendarForm {
    private String startTime;
    public static final String START_NOW = "now";
    public static final String START_ON_DATE = "onDate";
    private String endTime;
    public static final String END_NEVER = "none";
    public static final String END_ON_DATE = "onDate";
    private String recurInterval;
    public static final String RECUR_NEVER = "recurNever";
    public static final String RECUR_DAILY = "recurDaily";
    public static final String RECUR_WEEKLY = "recurWeekly";
    public static final String RECUR_MONTHLY = "recurMonthly";
    private String recurrenceFrequencyDaily;
    public static final String EVERY_DAY = "everyDay";
    public static final String EVERY_WEEKDAY = "everyWeekday";
    private String numDays;
    private String numWeeks;
    private String numMonths;
    private Integer[] recurrenceDay;
    private String recurrenceFrequencyMonthly;
    public static final String ON_EACH = "onEach";
    public static final String ON_DAY = "onDay";
    private Integer recurrenceWeek;
    private Integer monthlyRecurrenceDay;
    private Integer eachDay;
    private List<OptionItem> controlActions;
    private Integer numControlActions;

    public boolean getIsNow() {
        return this.startTime.equals(START_NOW);
    }

    private String fmtTime(int s) {
        if (s < 10) {
            return "0" + s;
        }
        return new Integer(s).toString();
    }

    public void reset(ActionMapping mapping, HttpServletRequest request) {
        this.startTime = START_NOW;
        Calendar cal = Calendar.getInstance();
        this.recurInterval = "";
        this.recurrenceFrequencyDaily = EVERY_DAY;
        this.recurrenceFrequencyMonthly = ON_EACH;
        this.numMonths = "1";
        this.setEndTime(END_NEVER);
        this.eachDay = new Integer(1);
        this.numDays = "1";
        this.numWeeks = "1";
        this.recurrenceDay = new Integer[0];
        this.monthlyRecurrenceDay = null;
        this.controlActions = null;
        this.numControlActions = new Integer(0);
        super.reset(mapping, request);
    }

    public ActionErrors validate(ActionMapping mapping, HttpServletRequest request) {
        if (!this.shouldValidate(mapping, request)) {
            return null;
        }
        ActionErrors errs = super.validate(mapping, request);
        if (errs == null) {
            errs = new ActionErrors();
        }
        if (this.startTime == null || this.startTime.equals(START_NOW)) {
            return errs.isEmpty() ? null : errs;
        }
        if (null != this.recurInterval) {
            if (this.recurInterval.equals(RECUR_DAILY)) {
                if (this.recurrenceFrequencyDaily != null && this.recurrenceFrequencyDaily.equals(EVERY_DAY)) {
                    Integer tmpNumDays = null;
                    try {
                        tmpNumDays = new Integer(Integer.parseInt(this.numDays));
                    }
                    catch (NumberFormatException nfe) {
                        errs.add("numDays", new ActionError("resource.autodiscovery.ScheduleTab.error.numDays", (Object)this.numDays));
                    }
                }
            } else if (this.recurInterval.equals(RECUR_WEEKLY)) {
                Integer tmpNumWeeks = null;
                try {
                    tmpNumWeeks = new Integer(Integer.parseInt(this.numWeeks));
                }
                catch (NumberFormatException nfe) {
                    errs.add("numWeeks", new ActionError("resource.autodiscovery.ScheduleTab.error.numWeeks", (Object)this.numWeeks));
                }
                if (this.recurrenceDay.length == 0) {
                    errs.add("recurrenceDay", new ActionError("resource.autodiscovery.ScheduleTab.error.recurrenceDay"));
                }
            } else if (this.recurInterval.equals(RECUR_MONTHLY)) {
                Integer tmpNumMonths = null;
                try {
                    tmpNumMonths = new Integer(Integer.parseInt(this.numMonths));
                }
                catch (NumberFormatException nfe) {
                    errs.add("numMonths", new ActionError("resource.autodiscovery.ScheduleTab.error.numMonths", (Object)this.numMonths));
                }
            }
        }
        return errs.isEmpty() ? null : errs;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(super.toString());
        buf.append(" startTime=").append(this.startTime);
        buf.append(" recurInterval=").append(this.recurInterval);
        buf.append(" recurrenceFrequencyDaily=").append(this.recurrenceFrequencyDaily);
        buf.append(" numDays=").append(this.numDays);
        buf.append(" numWeeks=").append(this.numWeeks);
        buf.append(" recurrenceDay=").append(this.recurrenceDay);
        buf.append(" recurrenceFrequencyMonthly=").append(this.recurrenceFrequencyMonthly);
        buf.append(" numMonths=").append(this.numMonths);
        buf.append(" recurrenceWeek=").append(this.recurrenceWeek);
        buf.append(" monthlyRecurrenceDay=").append(this.monthlyRecurrenceDay);
        buf.append(" eachDay=").append(this.eachDay);
        buf.append(" endTime=").append(this.endTime);
        return buf.toString();
    }

    public Integer getEachDay() {
        return this.eachDay;
    }

    public void setEachDay(Integer eachDay) {
        this.eachDay = eachDay;
    }

    public String getEndTime() {
        return this.endTime;
    }

    public void setEndTime(String endTime) {
        this.endTime = endTime;
        this.setWantEndDate(endTime.equals("onDate"));
    }

    public String getNumDays() {
        return this.numDays;
    }

    public void setNumDays(String numDays) {
        this.numDays = numDays;
    }

    public String getNumMonths() {
        return this.numMonths;
    }

    public void setNumMonths(String numMonths) {
        this.numMonths = numMonths;
    }

    public String getNumWeeks() {
        return this.numWeeks;
    }

    public void setNumWeeks(String numWeeks) {
        this.numWeeks = numWeeks;
    }

    public Integer[] getRecurrenceDay() {
        return this.recurrenceDay;
    }

    public void setRecurrenceDay(Integer[] recurrenceDay) {
        this.recurrenceDay = recurrenceDay;
    }

    public String getRecurrenceFrequencyDaily() {
        return this.recurrenceFrequencyDaily;
    }

    public void setRecurrenceFrequencyDaily(String recurrenceFrequencyDaily) {
        this.recurrenceFrequencyDaily = recurrenceFrequencyDaily;
    }

    public String getRecurrenceFrequencyMonthly() {
        return this.recurrenceFrequencyMonthly;
    }

    public void setRecurrenceFrequencyMonthly(String recurrenceFrequencyMonthly) {
        this.recurrenceFrequencyMonthly = recurrenceFrequencyMonthly;
    }

    public Integer getRecurrenceWeek() {
        return this.recurrenceWeek;
    }

    public void setRecurrenceWeek(Integer recurrenceWeek) {
        this.recurrenceWeek = recurrenceWeek;
    }

    public Integer getMonthlyRecurrenceDay() {
        return this.monthlyRecurrenceDay;
    }

    public void setMonthlyRecurrenceDay(Integer monthlyRecurrenceDay) {
        this.monthlyRecurrenceDay = monthlyRecurrenceDay;
    }

    public String getRecurInterval() {
        return this.recurInterval;
    }

    public void setRecurInterval(String recurInterval) {
        this.recurInterval = recurInterval;
    }

    public String getStartTime() {
        return this.startTime;
    }

    public void setStartTime(String st) {
        this.startTime = st;
    }

    public List<OptionItem> getControlActions() {
        return this.controlActions;
    }

    public void setControlActions(List<OptionItem> controlActions) {
        this.controlActions = controlActions;
    }

    public Integer getNumControlActions() {
        return this.controlActions == null ? 0 : this.controlActions.size();
    }
}

