/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.legacy.action.resource.common.events;

import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.event.EventSeverity;
import org.rhq.core.domain.event.composite.EventComposite;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageList;
import org.rhq.enterprise.gui.legacy.WebUser;
import org.rhq.enterprise.gui.legacy.action.resource.common.events.EventsForm;
import org.rhq.enterprise.gui.legacy.action.resource.common.monitor.visibility.MetricsControlFormPrepareAction;
import org.rhq.enterprise.gui.legacy.util.SessionUtils;
import org.rhq.enterprise.gui.util.WebUtility;
import org.rhq.enterprise.server.common.EntityContext;
import org.rhq.enterprise.server.event.EventManagerLocal;
import org.rhq.enterprise.server.measurement.MeasurementPreferences;
import org.rhq.enterprise.server.util.LookupUtil;

public class EventsFormPrepareAction
extends MetricsControlFormPrepareAction {
    EventManagerLocal eventManager;
    Log log = LogFactory.getLog(EventsFormPrepareAction.class);

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        EventsForm eForm = (EventsForm)form;
        this.eventManager = LookupUtil.getEventManager();
        int resourceId = WebUtility.getOptionalIntRequestParameter((ServletRequest)request, (String)"id", (int)-1);
        int groupId = WebUtility.getOptionalIntRequestParameter((ServletRequest)request, (String)"groupId", (int)-1);
        int parent = WebUtility.getOptionalIntRequestParameter((ServletRequest)request, (String)"parent", (int)-1);
        int type = WebUtility.getOptionalIntRequestParameter((ServletRequest)request, (String)"type", (int)-1);
        WebUser user = SessionUtils.getWebUser((HttpSession)request.getSession());
        MeasurementPreferences preferences = user.getMeasurementPreferences();
        MeasurementPreferences.MetricRangePreferences rangePreferences = preferences.getMetricRangePreferences();
        Subject subject = user.getSubject();
        long begin = rangePreferences.begin;
        long end = rangePreferences.end;
        eForm.setRn(Integer.valueOf(rangePreferences.lastN));
        request.getSession().setAttribute("rn", (Object)rangePreferences.lastN);
        eForm.setRu(Integer.valueOf(rangePreferences.unit));
        request.getSession().setAttribute("ru", (Object)rangePreferences.unit);
        PageControl pc = WebUtility.getPageControl((ServletRequest)request);
        String severityFilter = eForm.getSevFilter();
        String sourceFilter = eForm.getSourceFilter();
        String searchString = eForm.getSearchString();
        if (null == severityFilter) {
            severityFilter = WebUtility.getOptionalRequestParameter((ServletRequest)request, (String)"pSeverity", null);
            eForm.setSevFilter(severityFilter);
        }
        if (null == sourceFilter) {
            sourceFilter = WebUtility.getOptionalRequestParameter((ServletRequest)request, (String)"pSource", null);
            eForm.setSourceFilter(sourceFilter);
        }
        if (null == searchString) {
            searchString = WebUtility.getOptionalRequestParameter((ServletRequest)request, (String)"pSearch", null);
            eForm.setSearchString(searchString);
        }
        EventSeverity eventSeverityFilter = this.getSeverityFromString(eForm.getSevFilter());
        EntityContext context = new EntityContext(Integer.valueOf(resourceId), Integer.valueOf(groupId), Integer.valueOf(parent), Integer.valueOf(type));
        PageList events = this.eventManager.findEventComposites(subject, context, begin, end, new EventSeverity[]{eventSeverityFilter}, sourceFilter, searchString, pc);
        for (EventComposite event : events) {
            event.setEventDetail(this.htmlFormat(event.getEventDetail(), eForm.getSearchString()));
            event.setSourceLocation(this.htmlFormat(event.getSourceLocation(), eForm.getSourceFilter()));
        }
        eForm.setEvents(events);
        return null;
    }

    private EventSeverity getSeverityFromString(String sevFilter) {
        if (sevFilter == null || sevFilter.equals("") || sevFilter.equals("ALL")) {
            return null;
        }
        try {
            EventSeverity sev = EventSeverity.valueOf((String)sevFilter);
            return sev;
        }
        catch (IllegalArgumentException iae) {
            this.log.warn((Object)("Illegal EventSeverity passed: " + sevFilter));
            return null;
        }
    }

    private String htmlFormat(String input, String searchResult) {
        String output = input.replaceAll("\\n", "<br/>\n");
        if (searchResult != null && !searchResult.equals("")) {
            output = output.replaceAll("(" + searchResult + ")", "<b>$1</b>");
        }
        return output;
    }
}

