/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.legacy.action.resource.common.monitor.alerts.config.condition;

import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionMessage;
import org.rhq.core.domain.alert.AlertCondition;
import org.rhq.core.domain.alert.AlertConditionCategory;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.measurement.DataType;
import org.rhq.enterprise.gui.legacy.action.resource.common.monitor.alerts.config.ConditionBean;
import org.rhq.enterprise.gui.legacy.action.resource.common.monitor.alerts.config.condition.AvailabilityConverterValidator;
import org.rhq.enterprise.gui.legacy.action.resource.common.monitor.alerts.config.condition.CallTimeDataConverterValidator;
import org.rhq.enterprise.gui.legacy.action.resource.common.monitor.alerts.config.condition.EventsConverterValidator;
import org.rhq.enterprise.gui.legacy.action.resource.common.monitor.alerts.config.condition.MeasurementConverterValidator;
import org.rhq.enterprise.gui.legacy.action.resource.common.monitor.alerts.config.condition.OperationConverterValidator;
import org.rhq.enterprise.gui.legacy.action.resource.common.monitor.alerts.config.condition.ResourceConfigurationConverterValidator;
import org.rhq.enterprise.gui.legacy.action.resource.common.monitor.alerts.config.condition.TraitConverterValidator;

public class ConverterValidatorManager {
    private static AvailabilityConverterValidator availabilityConverter = new AvailabilityConverterValidator();
    private static EventsConverterValidator eventsConverter = new EventsConverterValidator();
    private static MeasurementConverterValidator measurementConverter = new MeasurementConverterValidator();
    private static CallTimeDataConverterValidator calltimeConverter = new CallTimeDataConverterValidator();
    private static OperationConverterValidator operationConverter = new OperationConverterValidator();
    private static TraitConverterValidator traitConverter = new TraitConverterValidator();
    private static ResourceConfigurationConverterValidator resourceConfigurationConverter = new ResourceConfigurationConverterValidator();

    public static AlertCondition exportProperties(Subject subject, ConditionBean fromBean) {
        AlertCondition toCondition = new AlertCondition();
        if (fromBean.getTrigger().equals(measurementConverter.getTriggerName())) {
            measurementConverter.exportProperties(subject, fromBean, toCondition);
        } else if (fromBean.getTrigger().equals(traitConverter.getTriggerName())) {
            traitConverter.exportProperties(subject, fromBean, toCondition);
        } else if (fromBean.getTrigger().equals(calltimeConverter.getTriggerName())) {
            calltimeConverter.exportProperties(subject, fromBean, toCondition);
        } else if (fromBean.getTrigger().equals(eventsConverter.getTriggerName())) {
            eventsConverter.exportProperties(subject, fromBean, toCondition);
        } else if (fromBean.getTrigger().equals(availabilityConverter.getTriggerName())) {
            availabilityConverter.exportProperties(subject, fromBean, toCondition);
        } else if (fromBean.getTrigger().equals(operationConverter.getTriggerName())) {
            operationConverter.exportProperties(subject, fromBean, toCondition);
        } else if (fromBean.getTrigger().equals(resourceConfigurationConverter.getTriggerName())) {
            resourceConfigurationConverter.exportProperties(subject, fromBean, toCondition);
        } else {
            throw new IllegalStateException(ConverterValidatorManager.class.getSimpleName() + " does not exporting for the trigger: " + fromBean.getTrigger());
        }
        return toCondition;
    }

    public static void importProperties(Subject subject, AlertCondition fromCondition, ConditionBean toBean) {
        AlertConditionCategory category = fromCondition.getCategory();
        if (category == AlertConditionCategory.THRESHOLD || category == AlertConditionCategory.BASELINE || category == AlertConditionCategory.CHANGE) {
            DataType measDataType = null;
            if (fromCondition.getMeasurementDefinition() != null) {
                measDataType = fromCondition.getMeasurementDefinition().getDataType();
            }
            if (DataType.CALLTIME == measDataType) {
                calltimeConverter.importProperties(subject, fromCondition, toBean);
            } else {
                measurementConverter.importProperties(subject, fromCondition, toBean);
            }
        } else if (category == AlertConditionCategory.TRAIT) {
            traitConverter.importProperties(subject, fromCondition, toBean);
        } else if (category == AlertConditionCategory.EVENT) {
            eventsConverter.importProperties(subject, fromCondition, toBean);
        } else if (category == AlertConditionCategory.AVAILABILITY) {
            availabilityConverter.importProperties(subject, fromCondition, toBean);
        } else if (category == AlertConditionCategory.CONTROL) {
            operationConverter.importProperties(subject, fromCondition, toBean);
        } else if (category == AlertConditionCategory.RESOURCE_CONFIG) {
            resourceConfigurationConverter.importProperties(subject, fromCondition, toBean);
        } else {
            throw new IllegalStateException(ConverterValidatorManager.class.getSimpleName() + " does not importing for the AlertConditionCategory: " + category);
        }
    }

    public static boolean validate(ConditionBean bean, ActionErrors errors, int index) {
        if (bean.getTrigger() == null) {
            ActionMessage err = new ActionMessage("alert.config.error.NoTriggerTypeSelected");
            errors.add("condition[" + index + "].trigger", err);
            return false;
        }
        if (bean.getTrigger().equals(measurementConverter.getTriggerName())) {
            return measurementConverter.validate(bean, errors, index);
        }
        if (bean.getTrigger().equals(calltimeConverter.getTriggerName())) {
            return calltimeConverter.validate(bean, errors, index);
        }
        if (bean.getTrigger().equals(traitConverter.getTriggerName())) {
            return traitConverter.validate(bean, errors, index);
        }
        if (bean.getTrigger().equals(eventsConverter.getTriggerName())) {
            return eventsConverter.validate(bean, errors, index);
        }
        if (bean.getTrigger().equals(availabilityConverter.getTriggerName())) {
            return availabilityConverter.validate(bean, errors, index);
        }
        if (bean.getTrigger().equals(operationConverter.getTriggerName())) {
            return operationConverter.validate(bean, errors, index);
        }
        if (bean.getTrigger().equals(resourceConfigurationConverter.getTriggerName())) {
            return resourceConfigurationConverter.validate(bean, errors, index);
        }
        throw new IllegalStateException(ConverterValidatorManager.class.getSimpleName() + " does not validation for the trigger: " + bean.getTrigger());
    }

    public static void setDefaults(ConditionBean bean) {
        bean.setThresholdType("absolute");
    }
}

