/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.legacy.action.resource.common.monitor.visibility;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.tiles.ComponentContext;
import org.apache.struts.tiles.actions.TilesAction;
import org.rhq.core.clientapi.util.units.UnitNumber;
import org.rhq.core.clientapi.util.units.UnitsConstants;
import org.rhq.core.clientapi.util.units.UnitsFormat;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.enterprise.gui.legacy.WebUser;
import org.rhq.enterprise.gui.legacy.util.RequestUtils;
import org.rhq.enterprise.gui.legacy.util.SessionUtils;
import org.rhq.enterprise.server.measurement.AvailabilityManagerLocal;
import org.rhq.enterprise.server.measurement.AvailabilityPoint;
import org.rhq.enterprise.server.measurement.MeasurementPreferences;
import org.rhq.enterprise.server.util.LookupUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AvailabilityAction
extends TilesAction {
    protected final Log log = LogFactory.getLog(AvailabilityAction.class);

    public ActionForward execute(ComponentContext context, ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AvailabilityManagerLocal availabilityManager = LookupUtil.getAvailabilityManager();
        WebUser user = SessionUtils.getWebUser((HttpSession)request.getSession());
        MeasurementPreferences preferences = user.getMeasurementPreferences();
        int resourceId = RequestUtils.getResourceId((HttpServletRequest)request);
        try {
            MeasurementPreferences.MetricRangePreferences rangePreferences = preferences.getMetricRangePreferences();
            List data = availabilityManager.findAvailabilitiesForResource(user.getSubject(), resourceId, rangePreferences.begin.longValue(), rangePreferences.end.longValue(), 60, !rangePreferences.readOnly);
            request.setAttribute("availabilityMetrics", (Object)data);
            request.setAttribute("availMetricsAttr", (Object)this.getFormattedAvailability(data));
        }
        catch (Exception e) {
            this.log.debug((Object)("AVAILABILITY not found for " + resourceId));
        }
        return null;
    }

    protected String getFormattedAvailability(List<AvailabilityPoint> values) {
        double sum = 0.0;
        int count = 0;
        for (AvailabilityPoint ap : values) {
            if (!ap.isKnown()) continue;
            ++count;
            if (ap.getAvailabilityType() != AvailabilityType.UP) continue;
            sum += 1.0;
        }
        double result = sum == 0.0 ? 0.0 : sum / (double)count;
        UnitNumber average = new UnitNumber(result, UnitsConstants.UNIT_PERCENTAGE);
        return UnitsFormat.format((UnitNumber)average).toString();
    }
}

