/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.legacy.portlet.autodiscovery;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.resource.InventoryStatus;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.util.PageControl;
import org.rhq.enterprise.gui.legacy.action.BaseAction;
import org.rhq.enterprise.gui.legacy.portlet.autodiscovery.AIQueueForm;
import org.rhq.enterprise.gui.legacy.util.SessionUtils;
import org.rhq.enterprise.server.discovery.DiscoveryBossLocal;
import org.rhq.enterprise.server.util.LookupUtil;

public class ProcessQueueAction
extends BaseAction {
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        boolean isIgnore;
        DiscoveryBossLocal discovery = LookupUtil.getDiscoveryBoss();
        Subject user = SessionUtils.getWebUser((HttpSession)request.getSession()).getSubject();
        AIQueueForm queueForm = (AIQueueForm)form;
        Integer[] platformIds = queueForm.getPlatformsToProcess();
        Integer[] serverIds = queueForm.getServersToProcess();
        int queueAction = queueForm.getQueueAction();
        boolean isApproval = queueAction == 1;
        boolean bl = isIgnore = queueAction == 2;
        if (!isApproval && !isIgnore) {
            throw new IllegalStateException("Illegal queue action id: " + queueAction);
        }
        ArrayList<Resource> selectedPlatforms = new ArrayList<Resource>();
        ArrayList<Resource> selectedServers = new ArrayList<Resource>();
        Map queuedResources = discovery.getQueuedPlatformsAndServers(user, PageControl.getUnlimitedInstance());
        String errorKey = null;
        for (Resource platform : queuedResources.keySet()) {
            if (!isIgnore || platform.getInventoryStatus() != InventoryStatus.NEW) continue;
            errorKey = "resource.platform.error.PlatformNotCommitted";
            break;
        }
        if (errorKey != null) {
            SessionUtils.setError((HttpSession)request.getSession(), errorKey);
            return this.returnSuccess(request, mapping);
        }
        for (Resource platform : queuedResources.keySet()) {
            if (!this.selectedForProcessing(platform, platformIds)) continue;
            selectedPlatforms.clear();
            selectedServers.clear();
            if (isApproval) {
                selectedPlatforms.add(platform);
            }
            for (Resource server : (List)queuedResources.get(platform)) {
                if (!this.isSelectedForProcessing(server, serverIds)) continue;
                selectedServers.add(server);
                if (!isApproval || selectedPlatforms.contains(platform)) continue;
                selectedPlatforms.add(platform);
            }
            try {
                InventoryStatus status = isApproval ? InventoryStatus.COMMITTED : InventoryStatus.IGNORED;
                discovery.updateInventoryStatus(user, selectedPlatforms, selectedServers, status);
            }
            catch (Exception e) {
                request.getSession().setAttribute("ImportError", (Object)e);
                break;
            }
        }
        return this.returnSuccess(request, mapping);
    }

    private boolean selectedForProcessing(Resource platform, Integer[] platformsToProcess) {
        Integer id = platform.getId();
        for (Integer platformToProcess : platformsToProcess) {
            if (!platformToProcess.equals(id)) continue;
            return true;
        }
        return false;
    }

    private boolean isSelectedForProcessing(Resource server, Integer[] serversToProcess) {
        Integer id = server.getId();
        for (Integer serverToProcess : serversToProcess) {
            if (!serverToProcess.equals(id)) continue;
            return true;
        }
        return false;
    }
}

