/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.configuration.resource;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.TreeMap;
import javax.faces.application.FacesMessage;
import javax.faces.event.ValueChangeEvent;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Out;
import org.jboss.seam.annotations.Scope;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.RawConfiguration;
import org.rhq.core.domain.configuration.ResourceConfigurationUpdate;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.domain.configuration.definition.ConfigurationFormat;
import org.rhq.core.gui.configuration.ConfigurationMaskingUtility;
import org.rhq.core.gui.util.FacesContextUtility;
import org.rhq.enterprise.gui.configuration.resource.RawConfigDirectory;
import org.rhq.enterprise.gui.configuration.resource.RawConfigUIBean;
import org.rhq.enterprise.gui.legacy.WebUser;
import org.rhq.enterprise.gui.util.EnterpriseFacesContextUtility;
import org.rhq.enterprise.server.configuration.ConfigurationManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

@Name(value="configurationViewer")
@Scope(value=ScopeType.PAGE)
public class ResourceConfigurationViewer {
    public static final boolean STRUCTURED_MODE = true;
    public static final boolean RAW_MODE = false;
    private boolean mode = true;
    @In(value="webUser")
    protected WebUser loggedInUser;
    @Out(required=false)
    protected Configuration resourceConfiguration;
    @Out(required=false)
    protected ConfigurationDefinition resourceConfigurationDefinition;
    @Out(required=false)
    protected Collection<RawConfigDirectory> rawConfigDirectories;
    @Out(required=false)
    protected RawConfigUIBean selectedRawUIBean;
    protected Integer resourceId;
    protected boolean initialized = false;

    public void initialize() {
        try {
            this.resourceId = (Integer)FacesContextUtility.getRequiredRequestParameter((String)"id", Integer.class);
            this.loadResourceConfigurationDefinition();
            if (this.resourceConfigurationDefinition == null) {
                FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_WARN, (String)"This resource does not expose a configuration.");
                return;
            }
            this.loadResourceConfiguration();
            if (this.resourceConfiguration == null) {
                FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_WARN, (String)"This resource's configuration has not yet been initialized.");
                return;
            }
            this.initRawConfigDirectories();
            this.initMode();
            this.initialized = true;
            this.doInitialization();
        }
        catch (Throwable t) {
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)t.getMessage());
        }
    }

    protected void doInitialization() {
    }

    private void loadResourceConfigurationDefinition() {
        int resourceTypeId = EnterpriseFacesContextUtility.getResource().getResourceType().getId();
        ConfigurationManagerLocal configurationManager = LookupUtil.getConfigurationManager();
        this.resourceConfigurationDefinition = configurationManager.getResourceConfigurationDefinitionForResourceType(this.loggedInUser.getSubject(), resourceTypeId);
    }

    private void loadResourceConfiguration() {
        Subject subject = this.loggedInUser.getSubject();
        ConfigurationManagerLocal configurationManager = LookupUtil.getConfigurationManager();
        ResourceConfigurationUpdate configurationUpdate = configurationManager.getLatestResourceConfigurationUpdate(subject, this.resourceId.intValue());
        Configuration configuration = this.resourceConfiguration = configurationUpdate != null ? configurationUpdate.getConfiguration() : null;
        if (this.resourceConfiguration != null) {
            ConfigurationMaskingUtility.maskConfiguration((Configuration)this.resourceConfiguration, (ConfigurationDefinition)this.resourceConfigurationDefinition);
        }
    }

    protected void initRawConfigDirectories() {
        if (this.isRawSupported() || this.isStructuredAndRawSupported()) {
            this.initConfigDirectories();
        } else {
            this.rawConfigDirectories = Collections.emptyList();
        }
    }

    private void initConfigDirectories() {
        TreeMap<String, RawConfigDirectory> dirs = new TreeMap<String, RawConfigDirectory>();
        for (RawConfiguration rawConfig : this.resourceConfiguration.getRawConfigurations()) {
            String parentDirPath = this.getParentDir(rawConfig);
            RawConfigDirectory dir = (RawConfigDirectory)dirs.get(parentDirPath);
            if (dir == null) {
                dir = new RawConfigDirectory();
                dir.setPath(parentDirPath);
            }
            dir.addRawConfig(rawConfig);
            dirs.put(parentDirPath, dir);
        }
        this.rawConfigDirectories = dirs.values();
        RawConfigDirectory selectedDir = null;
        Iterator i$ = this.rawConfigDirectories.iterator();
        if (i$.hasNext()) {
            RawConfigDirectory dir;
            selectedDir = dir = (RawConfigDirectory)i$.next();
        }
        this.selectedRawUIBean = (RawConfigUIBean)selectedDir.getRawConfigUIBeans().get(0);
    }

    private String getParentDir(RawConfiguration rawConfig) {
        File file = new File(rawConfig.getPath());
        return file.getParentFile().getAbsolutePath();
    }

    private void initMode() {
        this.mode = this.isStructuredSupported() ? true : !this.isRawMode();
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public boolean isRawSupported() {
        return this.resourceConfigurationDefinition.getConfigurationFormat() == ConfigurationFormat.RAW;
    }

    public boolean isStructuredSupported() {
        return this.resourceConfigurationDefinition.getConfigurationFormat() == ConfigurationFormat.STRUCTURED;
    }

    public boolean isStructuredMode() {
        return this.mode;
    }

    public boolean isRawMode() {
        return !this.mode;
    }

    public boolean getRenderModalEditor() {
        return this.isRawSupported() || this.isStructuredAndRawSupported();
    }

    public boolean isStructuredAndRawSupported() {
        return this.resourceConfigurationDefinition.getConfigurationFormat() == ConfigurationFormat.STRUCTURED_AND_RAW;
    }

    public String getSelectedTab() {
        if (this.isStructuredSupported()) {
            return "structuredTab";
        }
        if (this.isRawSupported()) {
            return "rawTab";
        }
        if (this.mode) {
            return "structuredTab";
        }
        return "rawTab";
    }

    public void setSelectedTab(String tab) {
        this.mode = tab.equals("structuredTab");
    }

    public void changeTabs(ValueChangeEvent event) {
        if (event.getNewValue().equals("rawTab")) {
            this.mode = false;
            this.changeToRawTab();
        } else if (event.getNewValue().equals("structuredTab")) {
            this.mode = true;
            this.changeToStructuredTab();
        }
    }

    protected void changeToRawTab() {
    }

    protected void changeToStructuredTab() {
    }

    public void select(String path) {
        this.selectedRawUIBean = this.findRawConfigUIBeanByPath(path);
    }

    protected RawConfigUIBean findRawConfigUIBeanByPath(String path) {
        for (RawConfigDirectory dir : this.rawConfigDirectories) {
            for (RawConfigUIBean bean : dir.getRawConfigUIBeans()) {
                if (!bean.getPath().equals(path)) continue;
                return bean;
            }
        }
        return null;
    }

    public boolean isUpdateInProgress() {
        if (!this.isInitialized()) {
            return false;
        }
        ConfigurationManagerLocal configurationMgr = LookupUtil.getConfigurationManager();
        return configurationMgr.isResourceConfigurationUpdateInProgress(this.loggedInUser.getSubject(), this.resourceId.intValue());
    }

    public String download() {
        try {
            File file = new File(this.selectedRawUIBean.getFileName());
            HttpServletResponse response = FacesContextUtility.getResponse();
            response.setHeader("Content-Disposition", "attachment;filename=" + file.getName());
            ServletOutputStream ostream = response.getOutputStream();
            ostream.write(this.selectedRawUIBean.getContents().getBytes());
            ostream.flush();
            ostream.close();
            FacesContextUtility.getFacesContext().responseComplete();
            return null;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String getModalEditorHeader() {
        return this.selectedRawUIBean.getPath();
    }

    public String getModalEditorContents() {
        return this.selectedRawUIBean.getContents();
    }
}

