/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.content;

import javax.faces.application.FacesMessage;
import javax.faces.model.DataModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.gui.util.FacesContextUtility;
import org.rhq.core.gui.util.StringUtility;
import org.rhq.enterprise.gui.common.framework.PagedDataTableUIBean;
import org.rhq.enterprise.gui.common.paging.PageControlView;
import org.rhq.enterprise.gui.content.ListReposUIBean;
import org.rhq.enterprise.gui.util.EnterpriseFacesContextUtility;
import org.rhq.enterprise.server.content.ContentSourceManagerLocal;
import org.rhq.enterprise.server.content.RepoManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

public class ListReposUIBean
extends PagedDataTableUIBean {
    private final Log log = LogFactory.getLog(ListReposUIBean.class);
    public static final String MANAGED_BEAN_NAME = "ListReposUIBean";
    private RepoManagerLocal repoManager = LookupUtil.getRepoManagerLocal();
    private ContentSourceManagerLocal contentSourceManager = LookupUtil.getContentSourceManager();

    public String createNewRepo() {
        return "createNewRepo";
    }

    public String importRepos() {
        return "importRepos";
    }

    public String syncSelectedRepos() {
        Subject subject = EnterpriseFacesContextUtility.getSubject();
        String[] selected = this.getSelectedRepos();
        int[] repoIds = StringUtility.getIntArray((String[])selected);
        if (repoIds.length > 0) {
            int syncCount = 0;
            try {
                syncCount = this.repoManager.synchronizeRepos(subject, repoIds);
            }
            catch (Exception e) {
                FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)"Failed to delete repositories.", (Throwable)e);
            }
            if (syncCount > 0) {
                FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_INFO, (String)("Synchronizing [" + syncCount + "] content sources."));
            } else {
                FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_INFO, (String)"Selected Repositories have no content to sync.");
            }
        }
        return "success";
    }

    public String deleteSelectedRepos() {
        Subject subject = EnterpriseFacesContextUtility.getSubject();
        String[] selected = this.getSelectedRepos();
        int[] ids = StringUtility.getIntArray((String[])selected);
        if (ids.length > 0) {
            try {
                int[] arr$ = ids;
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    Integer id = arr$[i$];
                    this.repoManager.deleteRepo(subject, id.intValue());
                }
                FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_INFO, (String)("Deleted [" + ids.length + "] repositories."));
            }
            catch (Exception e) {
                FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)"Failed to delete repositories.", (Throwable)e);
            }
        }
        return "success";
    }

    public DataModel getDataModel() {
        if (this.dataModel == null) {
            this.dataModel = new ListReposDataModel(this, PageControlView.ReposList, MANAGED_BEAN_NAME);
        }
        return this.dataModel;
    }

    private String[] getSelectedRepos() {
        return FacesContextUtility.getRequest().getParameterValues("selectedRepos");
    }
}

