/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.image.widget;

import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import java.util.Vector;
import org.rhq.enterprise.gui.image.data.ITreeNode;

public class TreeNode
implements ITreeNode,
Serializable {
    protected Vector m_upChildren = new Vector();
    protected Vector m_downChildren = new Vector();
    private String m_desc;
    private String m_name;
    private Vector m_rects;
    private boolean m_selected;

    public TreeNode(String name, String desc) {
        this(name, desc, false);
    }

    public TreeNode(String name, String desc, boolean selected) {
        this.m_name = name;
        this.m_desc = desc;
        this.m_selected = selected;
    }

    public void addUpChild(ITreeNode child) {
        this.m_upChildren.add(child);
    }

    public void addUpChildren(ITreeNode[] children) {
        for (int i = 0; i < children.length; ++i) {
            this.m_upChildren.add(children[i]);
        }
    }

    public ITreeNode[] getUpChildren() {
        return this.m_upChildren.toArray(new ITreeNode[this.m_upChildren.size()]);
    }

    public int getUpChildrenCount() {
        return this.m_upChildren.size();
    }

    public boolean hasUpChildren() {
        return this.getUpChildrenCount() > 0;
    }

    public void addDownChild(ITreeNode child) {
        this.m_downChildren.add(child);
    }

    public void addDownChildren(ITreeNode[] children) {
        for (int i = 0; i < children.length; ++i) {
            this.m_downChildren.add(children[i]);
        }
    }

    public ITreeNode[] getDownChildren() {
        return this.m_downChildren.toArray(new ITreeNode[this.m_downChildren.size()]);
    }

    public int getDownChildrenCount() {
        return this.m_downChildren.size();
    }

    public boolean hasDownChildren() {
        return this.getDownChildrenCount() > 0;
    }

    public void clear() {
        this.m_upChildren.clear();
        this.m_downChildren.clear();
    }

    public String getDescription() {
        return this.m_desc;
    }

    public BufferedImage getImage() {
        return null;
    }

    public String getName() {
        return this.m_name;
    }

    public Rectangle[] getRectangles() {
        return this.m_rects == null ? null : this.m_rects.toArray(new Rectangle[this.m_rects.size()]);
    }

    public boolean isSelected() {
        return this.m_selected;
    }

    public void addRectangle(int x, int y, int cx, int cy) {
        if (this.m_rects == null) {
            this.m_rects = new Vector();
        }
        this.m_rects.add(new Rectangle(x, y, cx, cy));
    }

    public void reset() {
        this.m_rects = null;
    }
}

