/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.inventory.resource;

import org.rhq.core.domain.resource.Agent;
import org.rhq.core.gui.util.FacesContextUtility;
import org.rhq.enterprise.gui.util.EnterpriseFacesContextUtility;
import org.rhq.enterprise.server.agentclient.AgentClient;
import org.rhq.enterprise.server.core.AgentManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

public class PingAgentUIBean {
    public static final String MANAGED_BEAN_NAME = "PingAgentUIBean";
    private Boolean pingResults = null;
    private Agent agent = null;
    private AgentManagerLocal agentManager = LookupUtil.getAgentManager();

    public Agent getAgent() {
        if (this.agent == null) {
            this.getData();
        }
        return this.agent;
    }

    public boolean getPingResults() {
        if (this.pingResults == null) {
            this.getData();
        }
        return this.pingResults;
    }

    public String getRemoteEndpointWrapped() {
        Agent theAgent = this.getAgent();
        if (theAgent != null) {
            String remoteEndpoint = theAgent.getRemoteEndpoint();
            if (remoteEndpoint != null) {
                return remoteEndpoint.replaceAll("&", " &");
            }
            return "!no remote endpoint associated with this resource!";
        }
        return "!no agent associated with this resource!";
    }

    private void getData() {
        try {
            int resourceId = (Integer)FacesContextUtility.getRequiredRequestParameter((String)"id", Integer.class);
            this.agent = this.agentManager.getAgentByResourceId(EnterpriseFacesContextUtility.getSubject(), resourceId);
            if (this.agent == null) {
                throw new IllegalStateException("No agent is associated with the resource with id " + resourceId + ".");
            }
            AgentClient client = this.agentManager.getAgentClient(this.agent);
            this.pingResults = client.ping(5000L);
        }
        catch (Throwable t) {
            this.pingResults = Boolean.FALSE;
        }
    }
}

