/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.legacy.action.resource.common.monitor.visibility;

import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.actions.DispatchAction;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.common.EntityContext;
import org.rhq.enterprise.gui.legacy.WebUser;
import org.rhq.enterprise.gui.legacy.action.resource.common.monitor.visibility.IndicatorChartsAction;
import org.rhq.enterprise.gui.legacy.action.resource.common.monitor.visibility.IndicatorViewsForm;
import org.rhq.enterprise.gui.legacy.util.MonitorUtils;
import org.rhq.enterprise.gui.legacy.util.RequestUtils;
import org.rhq.enterprise.gui.legacy.util.SessionUtils;
import org.rhq.enterprise.gui.util.MetricsDisplayMode;
import org.rhq.enterprise.gui.util.WebUtility;
import org.rhq.enterprise.server.measurement.MeasurementChartsManagerLocal;
import org.rhq.enterprise.server.measurement.MeasurementPreferences;
import org.rhq.enterprise.server.measurement.MeasurementViewException;
import org.rhq.enterprise.server.measurement.MeasurementViewManagerLocal;
import org.rhq.enterprise.server.measurement.uibean.MetricDisplaySummary;
import org.rhq.enterprise.server.measurement.util.MeasurementUtils;
import org.rhq.enterprise.server.util.LookupUtil;

/*
 * Exception performing whole class analysis ignored.
 */
public class IndicatorChartsAction
extends DispatchAction {
    private static final Log log = LogFactory.getLog(IndicatorChartsAction.class);
    private MeasurementChartsManagerLocal chartsManager = LookupUtil.getMeasurementChartsManager();
    private MeasurementViewManagerLocal viewManager = LookupUtil.getMeasurementViewManager();

    private String getContextKeyChart(MetricDisplaySummary summary) {
        MetricsDisplayMode mode = this.getDisplayModeForSummary(summary);
        switch (1.$SwitchMap$org$rhq$enterprise$gui$util$MetricsDisplayMode[mode.ordinal()]) {
            case 1: {
                if (summary.getScheduleId() != null) {
                    return summary.getResourceId() + "," + summary.getScheduleId().toString();
                }
                throw new IllegalStateException("MetricsDisplayMode was 'RESOURCE', but the scheduleId was null");
            }
            case 2: {
                return "cg," + summary.getGroupId() + "," + summary.getDefinitionId();
            }
            case 3: {
                return "ag," + summary.getParentId() + "," + summary.getDefinitionId() + "," + summary.getChildTypeId();
            }
        }
        throw new IllegalArgumentException("Unknown or unsupported MetricsDisplayMode '" + mode + "'");
    }

    private EntityContext getContext(HttpServletRequest request) {
        int resourceId = WebUtility.getOptionalIntRequestParameter((ServletRequest)request, (String)"id", (int)-1);
        int groupId = WebUtility.getOptionalIntRequestParameter((ServletRequest)request, (String)"groupId", (int)-1);
        int parentResourceId = WebUtility.getOptionalIntRequestParameter((ServletRequest)request, (String)"parent", (int)-1);
        int resourceTypeId = WebUtility.getOptionalIntRequestParameter((ServletRequest)request, (String)"type", (int)-1);
        return new EntityContext(Integer.valueOf(resourceId), Integer.valueOf(groupId), Integer.valueOf(parentResourceId), Integer.valueOf(resourceTypeId));
    }

    public ActionForward fresh(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession();
        WebUser user = SessionUtils.getWebUser((HttpSession)session);
        IndicatorViewsForm ivf = (IndicatorViewsForm)form;
        String viewName = ivf.getView();
        List metrics = new ArrayList();
        EntityContext context = WebUtility.getEntityContext((HttpServletRequest)request);
        try {
            List charts = this.viewManager.getCharts(user.getSubject(), context, viewName);
            for (String token : charts) {
                MetricDisplaySummary tmp = MeasurementUtils.parseMetricToken((String)token);
                metrics.add(tmp);
            }
            metrics = this.reloadMetrics(request, metrics, true);
            return mapping.findForward("success");
        }
        catch (MeasurementViewException mve) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Error getting charts: " + mve.getMessage()));
            }
            if (context.type == EntityContext.Type.Resource) {
                metrics = this.chartsManager.getMetricDisplaySummariesForResource(user.getSubject(), context.resourceId, viewName);
                for (MetricDisplaySummary summary : metrics) {
                    summary.setMetricToken(this.getContextKeyChart(summary));
                }
            } else if (context.type == EntityContext.Type.ResourceGroup) {
                metrics = this.chartsManager.getMetricDisplaySummariesForCompatibleGroup(user.getSubject(), context.groupId, viewName);
                for (MetricDisplaySummary summary : metrics) {
                    summary.setMetricToken(this.getContextKeyChart(summary));
                    MonitorUtils.formatSimpleMetrics((MetricDisplaySummary)summary, null);
                }
                request.setAttribute("chartDataKeys", metrics);
            } else if (context.type == EntityContext.Type.AutoGroup) {
                metrics = this.chartsManager.getMetricDisplaySummariesForAutoGroup(user.getSubject(), context.parentResourceId, context.resourceTypeId, viewName);
                for (MetricDisplaySummary summary : metrics) {
                    summary.setMetricToken(this.getContextKeyChart(summary));
                    MonitorUtils.formatSimpleMetrics((MetricDisplaySummary)summary, null);
                }
                request.setAttribute("chartDataKeys", metrics);
            }
            return mapping.findForward("success");
        }
    }

    private List<MetricDisplaySummary> reloadMetrics(HttpServletRequest request, List<MetricDisplaySummary> metrics, boolean force) {
        HttpSession session = request.getSession();
        WebUser user = SessionUtils.getWebUser((HttpSession)session);
        MeasurementPreferences preferences = user.getMeasurementPreferences();
        MeasurementPreferences.MetricRangePreferences rangePreferences = preferences.getMetricRangePreferences();
        long begin = rangePreferences.begin;
        long end = rangePreferences.end;
        ArrayList<MetricDisplaySummary> ret = new ArrayList<MetricDisplaySummary>(metrics.size());
        Locale userLocale = request.getLocale();
        for (MetricDisplaySummary sum : metrics) {
            List tmpList;
            MetricsDisplayMode mode = this.getDisplayModeForSummary(sum);
            switch (1.$SwitchMap$org$rhq$enterprise$gui$util$MetricsDisplayMode[mode.ordinal()]) {
                case 1: {
                    tmpList = this.chartsManager.getMetricDisplaySummariesForResource(user.getSubject(), sum.getResourceId(), new int[]{sum.getScheduleId()}, begin, end);
                    break;
                }
                case 3: {
                    tmpList = this.chartsManager.getMetricDisplaySummariesForAutoGroup(user.getSubject(), sum.getParentId(), sum.getChildTypeId(), new int[]{sum.getDefinitionId()}, begin, end, false);
                    break;
                }
                case 2: {
                    tmpList = this.chartsManager.getMetricDisplaySummariesForCompatibleGroup(user.getSubject(), sum.getGroupId(), new int[]{sum.getDefinitionId()}, begin, end, false);
                    break;
                }
                default: {
                    tmpList = null;
                }
            }
            if (tmpList != null && tmpList.size() > 0) {
                MetricDisplaySummary tmp = (MetricDisplaySummary)tmpList.get(0);
                tmp.setMetricToken(this.getContextKeyChart(tmp));
                if (tmp.getMetricKeys().length > 0) {
                    MonitorUtils.formatSimpleMetrics((MetricDisplaySummary)tmp, (Locale)userLocale);
                }
                ret.add(tmp);
                continue;
            }
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("We did not get a result back for " + sum));
        }
        return ret;
    }

    public ActionForward addChart(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        IndicatorViewsForm ivf = (IndicatorViewsForm)form;
        Subject subject = WebUtility.getSubject((HttpServletRequest)request);
        EntityContext context = new EntityContext(ivf.getId(), Integer.valueOf(ivf.getGroupId()), Integer.valueOf(ivf.getParent()), ivf.getCtype());
        this.viewManager.addChart(subject, context, ivf.getView(), ivf.getMetric()[0]);
        return mapping.findForward("ajax");
    }

    public ActionForward remove(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        IndicatorViewsForm ivf = (IndicatorViewsForm)form;
        Subject subject = WebUtility.getSubject((HttpServletRequest)request);
        EntityContext context = new EntityContext(ivf.getId(), Integer.valueOf(ivf.getGroupId()), Integer.valueOf(ivf.getParent()), ivf.getCtype());
        this.viewManager.removeChart(subject, context, ivf.getView(), ivf.getMetric()[0]);
        return mapping.findForward("ajax");
    }

    public ActionForward moveUp(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        IndicatorViewsForm ivf = (IndicatorViewsForm)form;
        Subject subject = WebUtility.getSubject((HttpServletRequest)request);
        EntityContext context = new EntityContext(ivf.getId(), Integer.valueOf(ivf.getGroupId()), Integer.valueOf(ivf.getParent()), ivf.getCtype());
        this.viewManager.moveChartUp(subject, context, ivf.getView(), ivf.getMetric()[0]);
        return mapping.findForward("ajax");
    }

    public ActionForward moveDown(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        IndicatorViewsForm ivf = (IndicatorViewsForm)form;
        Subject subject = WebUtility.getSubject((HttpServletRequest)request);
        EntityContext context = new EntityContext(ivf.getId(), Integer.valueOf(ivf.getGroupId()), Integer.valueOf(ivf.getParent()), ivf.getCtype());
        this.viewManager.moveChartDown(subject, context, ivf.getView(), ivf.getMetric()[0]);
        return mapping.findForward("ajax");
    }

    public ActionForward go(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return mapping.findForward("currentHealth");
    }

    private static int indexOfSpecialChars(String aTagFragment) {
        StringCharacterIterator iterator = new StringCharacterIterator(aTagFragment);
        int i = 0;
        char character = iterator.current();
        while (character != '\uffff') {
            switch (character) {
                case '\"': 
                case '&': 
                case '\'': 
                case '<': 
                case '>': 
                case '?': 
                case '\\': 
                case '|': {
                    return i;
                }
            }
            character = iterator.next();
            ++i;
        }
        return -1;
    }

    public ActionForward create(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        IndicatorViewsForm ivf = (IndicatorViewsForm)form;
        WebUser user = SessionUtils.getWebUser((HttpSession)request.getSession());
        MeasurementPreferences preferences = user.getMeasurementPreferences();
        String newViewName = ivf.getView();
        if (newViewName.length() == 0) {
            RequestUtils.setError((HttpServletRequest)request, (String)"resource.common.monitor.visibility.view.error.empty");
            return mapping.findForward("currentHealth");
        }
        if (IndicatorChartsAction.indexOfSpecialChars((String)newViewName) > -1) {
            RequestUtils.setError((HttpServletRequest)request, (String)"error.input.badchars");
            return mapping.findForward("currentHealth");
        }
        EntityContext context = new EntityContext(ivf.getId(), Integer.valueOf(ivf.getGroupId()), Integer.valueOf(ivf.getParent()), ivf.getCtype());
        try {
            this.viewManager.createView(user.getSubject(), context, newViewName);
        }
        catch (MeasurementViewException mve) {
            RequestUtils.setError((HttpServletRequest)request, (String)"resource.common.monitor.visibility.view.error.exists");
            return mapping.findForward("currentHealth");
        }
        List viewNames = this.viewManager.getViewNames(user.getSubject(), context);
        ivf.setViews(viewNames.toArray(new String[viewNames.size()]));
        return this.update(mapping, (ActionForm)ivf, request, response);
    }

    public ActionForward update(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return mapping.findForward("currentHealth");
    }

    public ActionForward delete(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        IndicatorViewsForm ivf = (IndicatorViewsForm)form;
        Subject subject = WebUtility.getSubject((HttpServletRequest)request);
        String doomedView = ivf.getUpdate();
        EntityContext context = new EntityContext(ivf.getId(), Integer.valueOf(ivf.getGroupId()), Integer.valueOf(ivf.getParent()), ivf.getCtype());
        this.viewManager.deleteView(subject, context, doomedView);
        return mapping.findForward("currentHealth");
    }

    private MetricsDisplayMode getDisplayModeForSummary(MetricDisplaySummary summary) {
        if (summary.getResourceId() > 0) {
            return MetricsDisplayMode.RESOURCE;
        }
        if (summary.getGroupId() > 0) {
            return MetricsDisplayMode.COMPGROUP;
        }
        if (summary.getParentId() > 0 && summary.getChildTypeId() > 0) {
            return MetricsDisplayMode.AUTOGROUP;
        }
        log.debug((Object)("Mode could not be determined for " + summary));
        return MetricsDisplayMode.UNSET;
    }

    private static int getChildTypeId(HttpServletRequest request) {
        int type = WebUtility.getOptionalIntRequestParameter((ServletRequest)request, (String)"type", (int)-1);
        if (type == -1) {
            type = WebUtility.getRequiredIntRequestParameter((ServletRequest)request, (String)"ctype");
        }
        return type;
    }
}

