/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.legacy.action.resource.common.monitor.visibility;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.util.MessageResources;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.domain.resource.group.GroupCategory;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageList;
import org.rhq.enterprise.gui.legacy.WebUser;
import org.rhq.enterprise.gui.legacy.action.resource.common.monitor.visibility.MetricsControlForm;
import org.rhq.enterprise.gui.legacy.action.resource.common.monitor.visibility.MetricsControlFormPrepareAction;
import org.rhq.enterprise.gui.legacy.action.resource.common.monitor.visibility.MetricsDisplayForm;
import org.rhq.enterprise.gui.legacy.util.MonitorUtils;
import org.rhq.enterprise.gui.legacy.util.SessionUtils;
import org.rhq.enterprise.gui.util.WebUtility;
import org.rhq.enterprise.server.measurement.MeasurementPreferences;
import org.rhq.enterprise.server.measurement.uibean.MetricDisplaySummary;
import org.rhq.enterprise.server.resource.ResourceManagerLocal;
import org.rhq.enterprise.server.resource.group.ResourceGroupManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

public abstract class MetricsDisplayFormPrepareAction
extends MetricsControlFormPrepareAction {
    protected static Log log = LogFactory.getLog(MetricsDisplayFormPrepareAction.class);
    protected int groupId = -1;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response, Long begin, Long end) throws Exception {
        List metrics;
        int[] resourceIds;
        MetricsDisplayForm displayForm = (MetricsDisplayForm)form;
        displayForm.setShowNumberCollecting(this.getShowNumberCollecting());
        displayForm.setShowBaseline(this.getShowBaseline());
        displayForm.setShowMetricSource(this.getShowMetricSource());
        WebUser user = SessionUtils.getWebUser((HttpSession)request.getSession());
        this.groupId = WebUtility.getOptionalIntRequestParameter((ServletRequest)request, (String)"groupId", (int)-1);
        if (this.groupId > 0) {
            ResourceGroupManagerLocal resGrpMgr = LookupUtil.getResourceGroupManager();
            List resources = resGrpMgr.findResourcesForResourceGroup(user.getSubject(), this.groupId, GroupCategory.COMPATIBLE);
            if (resources.size() > 0) {
                ResourceType resourceType = ((Resource)resources.get(0)).getResourceType();
                request.setAttribute("ResourceType", (Object)resourceType);
            }
            resourceIds = new int[resources.size()];
            int i = 0;
            for (Resource res : resources) {
                resourceIds[i] = res.getId();
                ++i;
            }
        } else {
            resourceIds = WebUtility.getResourceIds((ServletRequest)request);
        }
        if (begin == null || end == null) {
            MeasurementPreferences preferences = user.getMeasurementPreferences();
            MeasurementPreferences.MetricRangePreferences rangePreferences = preferences.getMetricRangePreferences();
            begin = rangePreferences.begin;
            end = rangePreferences.end;
        }
        if ((metrics = displayForm.isFilterSubmitClicked() ? this.getMetrics(request, resourceIds, displayForm.getFilters(), displayForm.getKeyword(), begin, end) : this.getMetrics(request, resourceIds, 0x11111111L, null, begin, end)) != null) {
            ArrayList<MetricDisplaySummary> metricsTrait = new ArrayList<MetricDisplaySummary>();
            for (MetricDisplaySummary mds : metrics) {
                if (!mds.getIsTrait()) continue;
                metricsTrait.add(mds);
            }
            metrics.removeAll(metricsTrait);
            Integer resourceCount = MonitorUtils.formatMetrics((List)metrics, (Locale)request.getLocale(), (MessageResources)this.getResources(request));
            request.setAttribute("NumChildResources", (Object)resourceCount);
            request.setAttribute("MetricSummaries", (Object)metrics);
            request.setAttribute("MetricSummariesTrait", metricsTrait);
            ResourceManagerLocal resourceManager = LookupUtil.getResourceManager();
            PageList groupMemberHealthSummaries = resourceManager.findResourceHealth(user.getSubject(), resourceIds, new PageControl());
            request.setAttribute("GroupMemberHealthSummaries", (Object)groupMemberHealthSummaries);
            displayForm.setMeasurementSummaryList(metrics);
        } else {
            log.trace((Object)"no metrics were returned by getMetrics(...)");
        }
        SessionUtils.clearWorkflow((HttpSession)request.getSession(), (String)"visibility/MetricDisplayRange");
        return super.execute(mapping, form, request, response);
    }

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.execute(mapping, form, request, response, null, null);
    }

    protected Boolean getShowNumberCollecting() {
        return Boolean.FALSE;
    }

    protected Boolean getShowBaseline() {
        return Boolean.FALSE;
    }

    protected Boolean getShowMetricSource() {
        return Boolean.FALSE;
    }

    protected abstract List<MetricDisplaySummary> getMetrics(HttpServletRequest var1, int[] var2, long var3, String var5, Long var6, Long var7) throws Exception;

    private void prepareForm(HttpServletRequest request, MetricsDisplayForm form) throws IllegalArgumentException {
        WebUser user = SessionUtils.getWebUser((HttpSession)request.getSession());
        MeasurementPreferences preferences = user.getMeasurementPreferences();
        Integer threshold = preferences.getMetricThresholdPreference();
        switch (threshold) {
            case 2: {
                form.setDisplayHighRange(Boolean.TRUE);
                break;
            }
            case 3: {
                form.setDisplayLowRange(Boolean.TRUE);
                break;
            }
            default: {
                form.setDisplayBaseline(Boolean.TRUE);
                threshold = 1;
            }
        }
        form.setT(threshold);
        if (form.isCurrentClicked()) {
            // empty if block
        }
        if (form.isHighlightClicked()) {
            form.setH(Boolean.TRUE);
            log.trace((Object)"calculating highlights");
        } else if (form.isClearClicked()) {
            log.trace((Object)"clearing highlights");
            form.setH(Boolean.FALSE);
            form.setHv(null);
            form.setHp(null);
            form.setHt(null);
        } else if (form.isAddClicked() || form.isRemoveClicked()) {
            form.setM(new Integer[0]);
        }
        super.prepareForm(request, (MetricsControlForm)form);
    }
}

