/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.legacy.portlet.autodiscovery;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.tiles.ComponentContext;
import org.apache.struts.tiles.actions.TilesAction;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.composite.DisambiguationReport;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.util.IntExtractor;
import org.rhq.core.util.exception.ThrowableUtil;
import org.rhq.enterprise.gui.legacy.WebUser;
import org.rhq.enterprise.gui.legacy.WebUserPreferences;
import org.rhq.enterprise.gui.legacy.portlet.autodiscovery.AIQueueForm;
import org.rhq.enterprise.gui.legacy.util.RequestUtils;
import org.rhq.enterprise.gui.legacy.util.SessionUtils;
import org.rhq.enterprise.server.authz.PermissionException;
import org.rhq.enterprise.server.discovery.DiscoveryBossLocal;
import org.rhq.enterprise.server.resource.ResourceManagerLocal;
import org.rhq.enterprise.server.resource.disambiguation.DefaultDisambiguationUpdateStrategies;
import org.rhq.enterprise.server.resource.disambiguation.DisambiguationUpdateStrategy;
import org.rhq.enterprise.server.util.LookupUtil;

/*
 * Exception performing whole class analysis ignored.
 */
public class ViewAction
extends TilesAction {
    private static final Log log = LogFactory.getLog(ViewAction.class);
    private static final IntExtractor<Resource> RESOURCE_ID_EXTRACTOR = new /* Unavailable Anonymous Inner Class!! */;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionForward execute(ComponentContext context, ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Map queuedResources = new HashMap();
        try {
            Exception exc;
            PageControl pageControl;
            DiscoveryBossLocal discoveryBoss = LookupUtil.getDiscoveryBoss();
            ResourceManagerLocal resourceManager = LookupUtil.getResourceManager();
            WebUser user = SessionUtils.getWebUser((HttpSession)request.getSession());
            if (user == null) {
                ActionForward actionForward = null;
                return actionForward;
            }
            WebUserPreferences preferences = user.getWebPreferences();
            Subject subject = user.getSubject();
            AIQueueForm queueForm = (AIQueueForm)form;
            try {
                int size = preferences.getAutoDiscoveryRange();
                pageControl = size < 1 ? PageControl.getUnlimitedInstance() : new PageControl(0, size);
            }
            catch (Exception e) {
                pageControl = new PageControl(0, 10);
            }
            try {
                queuedResources = ViewAction.disambiguateQueuedResources((Map)discoveryBoss.getQueuedPlatformsAndServers(subject, pageControl), (ResourceManagerLocal)resourceManager);
                if (queuedResources.isEmpty()) {
                    int count = LookupUtil.getAgentManager().getAgentCount();
                    request.setAttribute("hasNoAgents", (Object)(count == 0 ? 1 : 0));
                }
            }
            catch (PermissionException pe) {
                queuedResources = new HashMap();
            }
            ArrayList<Integer> platformsToProcess = new ArrayList<Integer>(queuedResources.size());
            ArrayList<Integer> serversToProcess = new ArrayList<Integer>();
            for (DisambiguationReport platform : queuedResources.keySet()) {
                platformsToProcess.add(((Resource)platform.getOriginal()).getId());
                List servers1 = (List)queuedResources.get(platform);
                for (DisambiguationReport server : servers1) {
                    serversToProcess.add(((Resource)server.getOriginal()).getId());
                }
            }
            queueForm.setPlatformsToProcess(platformsToProcess.toArray(new Integer[0]));
            queueForm.setServersToProcess(serversToProcess.toArray(new Integer[0]));
            SessionUtils.resetReturnPath((HttpSession)request.getSession());
            Object ignoreErr = request.getSession().getAttribute("IgnoreError");
            if (ignoreErr != null) {
                ActionMessage err = new ActionMessage("dash.autoDiscovery.import.ignore.Error");
                RequestUtils.setError((HttpServletRequest)request, (ActionMessage)err, (String)"org.apache.struts.action.GLOBAL_MESSAGE");
                request.getSession().setAttribute("IgnoreError", null);
            }
            if ((exc = (Exception)request.getSession().getAttribute("ImportError")) != null) {
                request.getSession().removeAttribute("ImportError");
                log.error((Object)"Failed to approve AI report", (Throwable)exc);
                ActionMessage err = new ActionMessage("dash.autoDiscovery.import.general.Error", (Object)ThrowableUtil.getAllMessages((Throwable)exc, (boolean)true));
                RequestUtils.setError((HttpServletRequest)request, (ActionMessage)err, (String)"org.apache.struts.action.GLOBAL_MESSAGE");
            }
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Dashboard Portlet [AutoDiscovery] experienced an error: " + e.getMessage()), (Throwable)e);
            } else {
                log.error((Object)("Dashboard Portlet [AutoDiscovery] experienced an error: " + e.getMessage()));
            }
        }
        finally {
            context.putAttribute("resources", queuedResources);
        }
        return null;
    }

    private static Map<DisambiguationReport<Resource>, List<DisambiguationReport<Resource>>> disambiguateQueuedResources(Map<Resource, List<Resource>> queuedResources, ResourceManagerLocal resourceManager) {
        HashMap<DisambiguationReport<Resource>, List<DisambiguationReport<Resource>>> ret = new HashMap<DisambiguationReport<Resource>, List<DisambiguationReport<Resource>>>();
        ArrayList<Resource> platforms = new ArrayList<Resource>(queuedResources.keySet());
        List disambiguatedPlatforms = resourceManager.disambiguate(platforms, RESOURCE_ID_EXTRACTOR, (DisambiguationUpdateStrategy)DefaultDisambiguationUpdateStrategies.getDefault());
        for (DisambiguationReport platform : disambiguatedPlatforms) {
            List<Resource> servers = queuedResources.get(platform.getOriginal());
            List disambiguatedServers = resourceManager.disambiguate(servers, RESOURCE_ID_EXTRACTOR, (DisambiguationUpdateStrategy)DefaultDisambiguationUpdateStrategies.getDefault());
            ret.put((DisambiguationReport<Resource>)platform, disambiguatedServers);
        }
        return ret;
    }
}

