/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.operation.schedule;

import org.quartz.SchedulerException;
import org.quartz.SimpleTrigger;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.gui.util.FacesContextUtility;
import org.rhq.enterprise.gui.common.scheduling.OperationDetailsScheduleComponent;
import org.rhq.enterprise.gui.operation.model.OperationParameters;
import org.rhq.enterprise.gui.util.EnterpriseFacesContextUtility;
import org.rhq.enterprise.server.operation.OperationManagerLocal;
import org.rhq.enterprise.server.operation.OperationSchedule;
import org.rhq.enterprise.server.scheduler.SchedulerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

public abstract class OperationScheduleDetailsUIBean {
    protected OperationManagerLocal manager = LookupUtil.getOperationManager();
    protected OperationSchedule schedule;
    private OperationParameters parameters;
    private OperationDetailsScheduleComponent operationDetails;

    protected void init() {
        if (this.schedule == null) {
            Subject subject = EnterpriseFacesContextUtility.getSubject();
            String jobId = FacesContextUtility.getRequiredRequestParameter((String)"jobId");
            SchedulerLocal scheduler = LookupUtil.getSchedulerBean();
            try {
                this.schedule = this.getOperationSchedule(subject, jobId);
            }
            catch (Exception e) {
                throw new IllegalStateException(e.getMessage(), e);
            }
            this.parameters = new OperationParameters(this.schedule);
            String jobName = this.schedule.getJobName();
            String jobGroup = this.schedule.getJobGroup();
            SimpleTrigger quartzTrigger = null;
            try {
                quartzTrigger = (SimpleTrigger)scheduler.getTrigger(jobName, jobGroup);
            }
            catch (SchedulerException se) {
                throw new IllegalStateException(se.getMessage(), se);
            }
            this.operationDetails = new OperationDetailsScheduleComponent(quartzTrigger);
        }
    }

    public abstract OperationSchedule getOperationSchedule(Subject var1, String var2) throws Exception;

    public OperationSchedule getSchedule() {
        this.init();
        return this.schedule;
    }

    public OperationParameters getParameters() {
        this.init();
        return this.parameters;
    }

    public OperationDetailsScheduleComponent getOperationDetails() {
        this.init();
        return this.operationDetails;
    }

    public OperationManagerLocal getManager() {
        return this.manager;
    }

    public void setManager(OperationManagerLocal manager) {
        this.manager = manager;
    }

    public void setSchedule(OperationSchedule schedule) {
        this.schedule = schedule;
    }

    public void setParameters(OperationParameters parameters) {
        this.parameters = parameters;
    }

    public void setOperationDetails(OperationDetailsScheduleComponent operationDetails) {
        this.operationDetails = operationDetails;
    }
}

