/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.perspectives;

import java.util.List;
import javax.faces.application.FacesMessage;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.cloud.Server;
import org.rhq.core.gui.util.FacesContextUtility;
import org.rhq.enterprise.gui.util.EnterpriseFacesContextUtility;
import org.rhq.enterprise.server.perspective.MenuItem;
import org.rhq.enterprise.server.perspective.PerspectiveException;
import org.rhq.enterprise.server.perspective.PerspectiveManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

@Name(value="PerspectiveUIBean")
@Scope(value=ScopeType.PAGE)
public class PerspectiveUIBean {
    PerspectiveManagerLocal perspectiveManager = LookupUtil.getPerspectiveManager();

    public List<MenuItem> getCoreMenu() {
        Subject subject = EnterpriseFacesContextUtility.getSubject();
        List result = null;
        try {
            result = this.perspectiveManager.getMenu(subject);
        }
        catch (PerspectiveException e) {
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)"Failed to get core menu.", (Throwable)e);
        }
        return result;
    }

    public String getUrlViaKey() {
        String targetUrlKey = FacesContextUtility.getRequiredRequestParameter((String)"targetUrlKey");
        String result = null;
        try {
            result = this.perspectiveManager.getUrlViaKey(Integer.valueOf(targetUrlKey).intValue());
            result = this.addContextParams(result);
        }
        catch (NumberFormatException e) {
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)("Required request parameter 'targetUrlKey' was not numeric: " + targetUrlKey), (Throwable)e);
        }
        catch (Exception e) {
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)("Could not get url for targetUrlKey: " + targetUrlKey), (Throwable)e);
        }
        return result;
    }

    private String addContextParams(String url) {
        StringBuilder sb = new StringBuilder(url);
        Server server = LookupUtil.getServerManager().getServer();
        String host = server.getAddress();
        String port = String.valueOf(server.getPort());
        Subject subject = EnterpriseFacesContextUtility.getSubject();
        String username = subject.getName();
        String sessionId = String.valueOf(subject.getSessionId());
        String resourceId = FacesContextUtility.getOptionalRequestParameter((String)"id", (String)"-1");
        this.addContextParam(sb, "rhqServerHost", host, url.contains("?") ? "&" : "?");
        this.addContextParam(sb, "rhqServerPort", port, "&");
        this.addContextParam(sb, "rhqUsername", username, "&");
        this.addContextParam(sb, "rhqSessionId", sessionId, "&");
        if (!"-1".equals(resourceId)) {
            this.addContextParam(sb, "rhqResourceId", resourceId, "&");
        }
        return sb.toString();
    }

    private void addContextParam(StringBuilder sb, String name, String value, String separator) {
        sb.append(separator);
        sb.append(name);
        sb.append("=");
        sb.append(value);
    }
}

