/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.admin.role;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import javax.ejb.EJBException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.tiles.ComponentContext;
import org.apache.struts.tiles.actions.TilesAction;
import org.rhq.core.domain.authz.Role;
import org.rhq.core.domain.resource.group.LdapGroup;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageList;
import org.rhq.core.domain.util.PageOrdering;
import org.rhq.enterprise.gui.admin.role.AddLdapGroupsForm;
import org.rhq.enterprise.gui.legacy.util.RequestUtils;
import org.rhq.enterprise.gui.legacy.util.SessionUtils;
import org.rhq.enterprise.gui.util.WebUtility;
import org.rhq.enterprise.server.exception.LdapCommunicationException;
import org.rhq.enterprise.server.exception.LdapFilterException;
import org.rhq.enterprise.server.resource.group.LdapGroupManagerLocal;
import org.rhq.enterprise.server.system.SystemManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

public class AddLdapGroupsFormPrepareAction
extends TilesAction {
    final String LDAP_GROUP_CACHE = "ldapGroupCache";
    LdapGroupManagerLocal ldapManager = LookupUtil.getLdapGroupManager();

    public ActionForward execute(ComponentContext context, ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Role role;
        Log log = LogFactory.getLog((String)AddLdapGroupsFormPrepareAction.class.getName());
        AddLdapGroupsForm addForm = (AddLdapGroupsForm)form;
        Integer roleId = addForm.getR();
        if (roleId == null) {
            roleId = RequestUtils.getRoleId((HttpServletRequest)request);
        }
        if ((role = (Role)request.getAttribute("Role")) == null) {
            RequestUtils.setError((HttpServletRequest)request, (String)"admin.role.error.RoleNotFound");
            return null;
        }
        Set cachedAvailableLdapGroups = null;
        cachedAvailableLdapGroups = (Set)request.getSession().getAttribute("ldapGroupCache");
        addForm.setR(Integer.valueOf(role.getId()));
        PageControl pca = WebUtility.getPageControl((ServletRequest)request, (String)"a");
        PageControl pcp = WebUtility.getPageControl((ServletRequest)request, (String)"p");
        List pendingGroupIds = new ArrayList();
        Set allGroups = new HashSet();
        PageList assignedList = new PageList();
        Set availableGroupsSet = new HashSet();
        Set pendingSet = new HashSet();
        PageList pendingGroups = new PageList(pendingSet, 0, pcp);
        PageList availableGroups = new PageList(availableGroupsSet, 0, pca);
        pendingGroupIds = SessionUtils.getListAsListStr((HttpSession)request.getSession(), (String)"pendingResGrps");
        log.trace((Object)("getting pending groups for role [" + roleId + ")"));
        String name = "foo";
        try {
            allGroups = cachedAvailableLdapGroups == null ? this.ldapManager.findAvailableGroups() : cachedAvailableLdapGroups;
            cachedAvailableLdapGroups = allGroups;
            assignedList = this.ldapManager.findLdapGroupsByRole(role.getId(), PageControl.getUnlimitedInstance());
            allGroups = this.filterExisting((List)assignedList, allGroups);
            HashSet pendingIds = new HashSet(pendingGroupIds);
            pendingSet = this.findPendingGroups(pendingIds, allGroups);
            pendingGroups = new PageList(pendingSet, pendingSet.size(), pcp);
            log.trace((Object)("getting available groups for role [" + roleId + "]"));
            availableGroupsSet = this.findAvailableGroups(pendingIds, allGroups);
            availableGroups = new PageList(availableGroupsSet, availableGroupsSet.size(), pca);
            PageList sizedAvailableGroups = new PageList();
            availableGroups = sizedAvailableGroups = this.paginateLdapGroupData(sizedAvailableGroups, availableGroups, pca);
            availableGroups.setTotalSize(availableGroupsSet.size());
            availableGroups.setPageControl(pca);
            PageList pagedPendingGroups = new PageList();
            pendingGroups = pagedPendingGroups = this.paginateLdapGroupData(pagedPendingGroups, pendingGroups, pcp);
            pendingGroups.setTotalSize(pendingSet.size());
            pendingGroups.setPageControl(pcp);
        }
        catch (EJBException ejx) {
            Exception cause = ejx.getCausedByException();
            if (cause == null) {
                ActionMessages actionMessages = new ActionMessages();
                actionMessages.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage("errors.cam.general"));
                this.saveErrors(request, actionMessages);
            } else if (cause instanceof LdapFilterException) {
                ActionMessages actionMessages = new ActionMessages();
                actionMessages.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage("admin.role.LdapGroupFilterMessage"));
                this.saveErrors(request, actionMessages);
            } else if (cause instanceof LdapCommunicationException) {
                ActionMessages actionMessages = new ActionMessages();
                SystemManagerLocal manager = LookupUtil.getSystemManager();
                Properties options = manager.getSystemConfiguration(LookupUtil.getSubjectManager().getOverlord());
                String providerUrl = options.getProperty("CAM_LDAP_NAMING_PROVIDER_URL", "(unavailable)");
                actionMessages.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage("admin.role.LdapCommunicationMessage", (Object)providerUrl));
                this.saveErrors(request, actionMessages);
            }
        }
        catch (LdapFilterException lce) {
            ActionMessages actionMessages = new ActionMessages();
            actionMessages.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage("admin.role.LdapGroupFilterMessage"));
            this.saveErrors(request, actionMessages);
        }
        catch (LdapCommunicationException lce) {
            ActionMessages actionMessages = new ActionMessages();
            SystemManagerLocal manager = LookupUtil.getSystemManager();
            Properties options = manager.getSystemConfiguration(LookupUtil.getSubjectManager().getOverlord());
            String providerUrl = options.getProperty("CAM_LDAP_NAMING_PROVIDER_URL", "(unavailable)");
            actionMessages.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage("admin.role.LdapCommunicationMessage", (Object)providerUrl));
            this.saveErrors(request, actionMessages);
        }
        request.setAttribute("PendingResGrps", (Object)pendingGroups);
        request.setAttribute("NumPendingResGrps", (Object)new Integer(pendingGroups.getTotalSize()));
        request.setAttribute("AvailableResGrps", (Object)availableGroups);
        request.setAttribute("NumAvailableResGrps", (Object)new Integer(allGroups.size()));
        request.getSession().setAttribute("ldapGroupCache", cachedAvailableLdapGroups);
        return null;
    }

    private Set<Map<String, String>> findPendingGroups(Set<String> pending, Set<Map<String, String>> allGroups) {
        HashSet<Map<String, String>> ret = new HashSet<Map<String, String>>();
        for (Map<String, String> group : allGroups) {
            if (!pending.contains(group.get("name"))) continue;
            ret.add(group);
        }
        return ret;
    }

    private Set<Map<String, String>> findAvailableGroups(Set<String> pending, Set<Map<String, String>> allGroups) {
        HashSet<Map<String, String>> ret = new HashSet<Map<String, String>>();
        for (Map<String, String> group : allGroups) {
            if (pending.contains(group.get("name"))) continue;
            ret.add(group);
        }
        return ret;
    }

    private Set<Map<String, String>> filterExisting(List<LdapGroup> pendingItems, Set<Map<String, String>> allGroups) {
        HashSet<String> pending = new HashSet<String>();
        for (LdapGroup group : pendingItems) {
            pending.add(group.getName());
        }
        HashSet<Map<String, String>> ret = new HashSet<Map<String, String>>();
        for (Map<String, String> group : allGroups) {
            if (pending.contains(group.get("name"))) continue;
            ret.add(group);
        }
        return ret;
    }

    private PageList<Map<String, String>> paginateLdapGroupData(PageList<Map<String, String>> pagedGroupData, PageList<Map<String, String>> fullGroupData, PageControl pc) {
        String sortColumn;
        if (pagedGroupData == null) {
            pagedGroupData = new PageList();
        }
        if (fullGroupData == null || fullGroupData.isEmpty()) {
            return pagedGroupData;
        }
        if (pc == null) {
            pc = new PageControl(0, 15);
        }
        int returnAmount = pc.getPageSize();
        int returnIndex = pc.getPageNumber();
        PageOrdering sortOrder = pc.getPrimarySortOrder();
        if (sortOrder == null) {
            sortOrder = PageOrdering.ASC;
            pc.setPrimarySortOrder(sortOrder);
        }
        if ((sortColumn = pc.getPrimarySortColumn()) == null) {
            sortColumn = "lg.name";
            pc.setPrimarySort(sortColumn, sortOrder);
        }
        ArrayList groupsValues = fullGroupData.getValues();
        HashMap<Integer, Map> groupLookup = new HashMap<Integer, Map>();
        TreeMap groupNames = new TreeMap();
        TreeMap groupDescriptions = new TreeMap();
        for (int i = 0; i < groupsValues.size(); ++i) {
            Map entry = (Map)groupsValues.get(i);
            Integer key = i;
            groupLookup.put(key, entry);
            groupNames.put(entry.get("name"), key);
            groupDescriptions.put(entry.get("description"), key);
        }
        int start = returnIndex * returnAmount;
        int end = start + returnAmount;
        boolean descending = false;
        if (PageOrdering.DESC == sortOrder) {
            descending = true;
        }
        if (sortColumn.equalsIgnoreCase("lg.name")) {
            ArrayList keyList;
            int i = 0;
            if (descending) {
                keyList = new ArrayList(groupNames.keySet());
                Collections.reverse(keyList);
            } else {
                keyList = new ArrayList(groupNames.keySet());
                Collections.sort(keyList);
            }
            for (String key : keyList) {
                if (i >= start && i < end) {
                    pagedGroupData.add(groupLookup.get(groupNames.get(key)));
                }
                ++i;
            }
        } else {
            ArrayList keyList;
            int i = 0;
            if (descending) {
                keyList = new ArrayList(groupDescriptions.keySet());
                Collections.reverse(keyList);
            } else {
                keyList = new ArrayList(groupDescriptions.keySet());
                Collections.sort(keyList);
            }
            for (String key : keyList) {
                if (i >= start && i < end) {
                    pagedGroupData.add(groupLookup.get(groupDescriptions.get(key)));
                }
                ++i;
            }
        }
        return pagedGroupData;
    }
}

