/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.admin.role;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.rhq.core.util.collection.ArrayUtils;
import org.rhq.enterprise.gui.admin.role.AddUsersForm;
import org.rhq.enterprise.gui.legacy.action.BaseAction;
import org.rhq.enterprise.gui.legacy.action.BaseValidatorForm;
import org.rhq.enterprise.gui.legacy.util.RequestUtils;
import org.rhq.enterprise.gui.legacy.util.SessionUtils;
import org.rhq.enterprise.server.authz.PermissionException;
import org.rhq.enterprise.server.util.LookupUtil;

public class AddUsersAction
extends BaseAction {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Log log = LogFactory.getLog((String)AddUsersAction.class.getName());
        HttpSession session = request.getSession();
        AddUsersForm addForm = (AddUsersForm)form;
        Integer roleId = addForm.getR();
        ActionForward forward = this.checkSubmit(request, mapping, form, "r", (Object)roleId);
        if (forward != null) {
            BaseValidatorForm spiderForm = (BaseValidatorForm)form;
            if (spiderForm.isCancelClicked() || spiderForm.isResetClicked()) {
                log.trace((Object)"removing pending user list");
                SessionUtils.removeList((HttpSession)session, (String)"pendingUsers");
            } else if (spiderForm.isAddClicked()) {
                log.trace((Object)"adding to pending user list");
                SessionUtils.addToList((HttpSession)session, (String)"pendingUsers", (Integer[])addForm.getAvailableUsers());
            } else if (spiderForm.isRemoveClicked()) {
                log.trace((Object)"removing from pending user list");
                SessionUtils.removeFromList((HttpSession)session, (String)"pendingUsers", (Integer[])addForm.getPendingUsers());
            }
            return forward;
        }
        log.debug((Object)("getting role [" + roleId + "]"));
        log.debug((Object)"getting pending user list");
        int[] pendingUserIds = ArrayUtils.unwrapArray((Integer[])SessionUtils.getList((HttpSession)request.getSession(), (String)"pendingUsers"));
        for (int i = 0; i < pendingUserIds.length; ++i) {
            log.debug((Object)("adding user [" + pendingUserIds[i] + "] for role [" + roleId + "]"));
        }
        try {
            LookupUtil.getRoleManager().addSubjectsToRole(RequestUtils.getSubject((HttpServletRequest)request), roleId.intValue(), pendingUserIds);
        }
        catch (PermissionException pe) {
            RequestUtils.setError((HttpServletRequest)request, (String)"admin.role.error.StaticRole");
            ActionForward actionForward = this.returnFailure(request, mapping, "r", (Object)roleId);
            return actionForward;
        }
        finally {
            log.debug((Object)"removing pending user list");
            SessionUtils.removeList((HttpSession)session, (String)"pendingUsers");
        }
        RequestUtils.setConfirmation((HttpServletRequest)request, (String)"admin.role.confirm.AddUsers");
        return this.returnSuccess(request, mapping, "r", (Object)roleId);
    }
}

