/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.content;

import javax.faces.application.FacesMessage;
import javax.faces.model.SelectItem;
import org.rhq.core.clientapi.agent.configuration.ConfigurationUtility;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.domain.content.ContentSource;
import org.rhq.core.domain.content.DownloadMode;
import org.rhq.core.gui.util.FacesContextUtility;
import org.rhq.core.util.exception.ThrowableUtil;
import org.rhq.enterprise.gui.util.EnterpriseFacesContextUtility;
import org.rhq.enterprise.server.content.ContentSourceManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

public class ContentProviderDetailsUIBean {
    private ContentSource contentSource;

    public ContentSource getContentSource() {
        this.loadContentSource();
        return this.contentSource;
    }

    public String edit() {
        return "edit";
    }

    public String save() {
        Subject subject = EnterpriseFacesContextUtility.getSubject();
        ContentSourceManagerLocal manager = LookupUtil.getContentSourceManager();
        try {
            manager.updateContentSource(subject, this.contentSource, true);
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_INFO, (String)("The content source [" + this.contentSource.getName() + "] has been updated."));
        }
        catch (Exception e) {
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_WARN, (String)("Failed to update content source [" + this.contentSource.getName() + "]"), (Throwable)e);
        }
        return "success";
    }

    public String cancel() {
        return "success";
    }

    public String test() {
        ContentSourceManagerLocal manager = LookupUtil.getContentSourceManager();
        try {
            manager.testContentSourceConnection(this.contentSource.getId());
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_INFO, (String)("Test passed - the remote repository for [" + this.contentSource.getName() + "] is available."));
        }
        catch (Exception e) {
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_WARN, (String)("Test failed - failed to connect to the remote repository for [" + this.contentSource.getName() + "] - check the configuration and make sure the remote repository is up and reachable. Details: " + ThrowableUtil.getAllMessages((Throwable)e)));
        }
        return "success";
    }

    public String sync() {
        ContentSourceManagerLocal contentSourceManager = LookupUtil.getContentSourceManager();
        try {
            contentSourceManager.testContentSourceConnection(this.contentSource.getId());
        }
        catch (Exception e) {
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)("Failed to connect to the remote repository for [" + this.contentSource.getName() + "] - check the configuration and make sure the remote repository is up and reachable. Details: " + ThrowableUtil.getAllMessages((Throwable)e)));
            return "success";
        }
        Subject subject = EnterpriseFacesContextUtility.getSubject();
        try {
            contentSourceManager.synchronizeAndLoadContentSource(subject, this.contentSource.getId());
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_INFO, (String)("Synchronizing content source [" + this.contentSource.getName() + "] now."));
        }
        catch (Exception e) {
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_WARN, (String)("Failed to start the synchronization process for [" + this.contentSource.getName() + "]"), (Throwable)e);
        }
        return "success";
    }

    public SelectItem[] getDownloadModes() {
        DownloadMode[] modes = DownloadMode.values();
        SelectItem[] items = new SelectItem[modes.length];
        int i = 0;
        for (DownloadMode mode : modes) {
            items[i++] = new SelectItem((Object)mode.name());
        }
        return items;
    }

    public String getSelectedDownloadMode() {
        return this.contentSource.getDownloadMode().name();
    }

    public void setSelectedDownloadMode(String mode) {
        this.contentSource.setDownloadMode(DownloadMode.valueOf((String)mode));
    }

    public ConfigurationDefinition getContentSourceTypeConfigurationDefinition() {
        this.loadContentSource();
        return this.contentSource.getContentSourceType().getContentSourceConfigurationDefinition();
    }

    private void loadContentSource() {
        Integer id = (Integer)FacesContextUtility.getRequiredRequestParameter((String)"id", Integer.class);
        if (this.contentSource == null || this.contentSource != null && this.contentSource.getId() != id.intValue()) {
            Subject subject = EnterpriseFacesContextUtility.getSubject();
            ContentSourceManagerLocal manager = LookupUtil.getContentSourceManager();
            this.contentSource = manager.getContentSource(subject, id.intValue());
            String cstName = this.contentSource.getContentSourceType().getName();
            this.contentSource.setContentSourceType(manager.getContentSourceType(cstName));
            ConfigurationUtility.normalizeConfiguration((Configuration)this.contentSource.getConfiguration(), (ConfigurationDefinition)this.contentSource.getContentSourceType().getContentSourceConfigurationDefinition());
        }
    }

    public String finishAddMap() {
        FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_INFO, (String)"Map added.");
        return "success";
    }

    public String finishEditMap() {
        FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_INFO, (String)"Map updated.");
        return "success";
    }
}

