/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.content;

import java.util.ArrayList;
import javax.faces.application.FacesMessage;
import javax.faces.model.SelectItem;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.authz.Permission;
import org.rhq.core.domain.content.ContentSyncStatus;
import org.rhq.core.domain.content.Repo;
import org.rhq.core.domain.content.RepoSyncResults;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageList;
import org.rhq.core.gui.util.FacesContextUtility;
import org.rhq.enterprise.gui.util.EnterpriseFacesContextUtility;
import org.rhq.enterprise.server.auth.SubjectManagerLocal;
import org.rhq.enterprise.server.content.ContentException;
import org.rhq.enterprise.server.content.RepoManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

public class RepoDetailsUIBean {
    private final Log log = LogFactory.getLog(this.getClass());
    private Repo repo;

    public Repo getRepo() {
        this.loadRepo();
        return this.repo;
    }

    public String edit() {
        return "edit";
    }

    public void reloadRepo() {
        this.repo = null;
        this.loadRepo();
    }

    public boolean getCurrentlySyncing() {
        String syncStatus = this.getSyncStatus();
        return !syncStatus.equals(ContentSyncStatus.SUCCESS.toString()) && !syncStatus.equals(ContentSyncStatus.FAILURE.toString()) && !syncStatus.equals(ContentSyncStatus.NONE.toString()) && !syncStatus.equals(ContentSyncStatus.CANCELLED.toString()) && !syncStatus.equals(ContentSyncStatus.CANCELLING.toString());
    }

    public String getSyncStatus() {
        Subject subject = EnterpriseFacesContextUtility.getSubject();
        Integer id = (Integer)FacesContextUtility.getRequiredRequestParameter((String)"id", Integer.class);
        String retval = LookupUtil.getRepoManagerLocal().calculateSyncStatus(subject, id.intValue());
        return retval;
    }

    public RepoSyncResults getSyncResults() {
        Subject subject = EnterpriseFacesContextUtility.getSubject();
        Integer id = (Integer)FacesContextUtility.getRequiredRequestParameter((String)"id", Integer.class);
        return LookupUtil.getRepoManagerLocal().getMostRecentSyncResults(subject, id.intValue());
    }

    public String getPercentComplete() {
        Subject subject = EnterpriseFacesContextUtility.getSubject();
        Integer id = (Integer)FacesContextUtility.getRequiredRequestParameter((String)"id", Integer.class);
        RepoSyncResults r = LookupUtil.getRepoManagerLocal().getMostRecentSyncResults(subject, id.intValue());
        String retval = r != null && r.getPercentComplete() != null ? r.getPercentComplete().toString() : "0";
        return retval;
    }

    public boolean isRepositoryManager() {
        Subject subject = EnterpriseFacesContextUtility.getSubject();
        return LookupUtil.getAuthorizationManager().hasGlobalPermission(subject, Permission.MANAGE_REPOSITORIES);
    }

    public boolean isEditable() {
        Subject subject = EnterpriseFacesContextUtility.getSubject();
        return LookupUtil.getAuthorizationManager().canUpdateRepo(subject, this.getRepo().getId());
    }

    public boolean isInventoryManager() {
        Subject subject = EnterpriseFacesContextUtility.getSubject();
        return LookupUtil.getAuthorizationManager().isInventoryManager(subject);
    }

    public boolean getHasContentSources() {
        return this.getRepo().getContentSources().size() > 0;
    }

    public SelectItem[] getAvailableOwners() {
        SubjectManagerLocal subjectManager = LookupUtil.getSubjectManager();
        PageList subjects = subjectManager.findAllSubjects(PageControl.getUnlimitedInstance());
        ArrayList<SelectItem> items = new ArrayList<SelectItem>(subjects.size());
        items.add(new SelectItem(null, "--None--"));
        for (Subject s : subjects) {
            SelectItem item = new SelectItem((Object)s.getName(), s.getName());
            items.add(item);
        }
        return items.toArray(new SelectItem[items.size()]);
    }

    public String sync() {
        Subject subject = EnterpriseFacesContextUtility.getSubject();
        int[] repoIds = new int[]{(Integer)FacesContextUtility.getRequiredRequestParameter((String)"id", Integer.class)};
        int syncCount = 0;
        try {
            syncCount = LookupUtil.getRepoManagerLocal().synchronizeRepos(subject, repoIds);
        }
        catch (Exception e) {
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)("Error: " + e.getMessage()));
            this.log.error((Object)("Error synchronizing repo ID [" + repoIds + "]"), (Throwable)e);
            return "edit";
        }
        if (syncCount > 0) {
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_INFO, (String)"The repository is syncing.");
        } else {
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_INFO, (String)"Nothing to sync for this repository.");
        }
        return "success";
    }

    public String save() {
        Subject subject = EnterpriseFacesContextUtility.getSubject();
        RepoManagerLocal manager = LookupUtil.getRepoManagerLocal();
        try {
            this.updateRepoOwner(subject);
            manager.updateRepo(subject, this.repo);
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_INFO, (String)"The repository has been updated.");
        }
        catch (ContentException ce) {
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)("Error: " + ce.getMessage()));
            return "edit";
        }
        return "success";
    }

    public String cancelSync() {
        Subject subject = EnterpriseFacesContextUtility.getSubject();
        RepoManagerLocal manager = LookupUtil.getRepoManagerLocal();
        Integer repoId = (Integer)FacesContextUtility.getRequiredRequestParameter((String)"id", Integer.class);
        try {
            manager.cancelSync(subject, repoId.intValue());
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_INFO, (String)"The synchronization has been cancelled.");
        }
        catch (Exception ce) {
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)("Error: " + ce.getMessage()));
            return "success";
        }
        return "success";
    }

    public String cancel() {
        return "success";
    }

    private void loadRepo() {
        if (this.repo == null) {
            Subject subject = EnterpriseFacesContextUtility.getSubject();
            Integer id = (Integer)FacesContextUtility.getRequiredRequestParameter((String)"id", Integer.class);
            RepoManagerLocal manager = LookupUtil.getRepoManagerLocal();
            this.repo = manager.getRepo(subject, id.intValue());
            this.repo.setSyncStatus(manager.calculateSyncStatus(subject, id.intValue()));
            if (this.repo.getOwner() == null) {
                this.repo.setOwner(new Subject());
            }
        }
    }

    private void updateRepoOwner(Subject loggedInSubject) {
        if (this.repo.getOwner().getName() == null) {
            this.repo.setOwner(null);
        } else if (this.repo.getOwner().getName().equals(loggedInSubject.getName())) {
            this.repo.setOwner(loggedInSubject);
        } else {
            SubjectManagerLocal subjectManager = LookupUtil.getSubjectManager();
            Subject s = subjectManager.getSubjectByName(this.repo.getOwner().getName());
            this.repo.setOwner(s);
        }
    }
}

