/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.download;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.rhq.core.domain.cloud.Server;
import org.rhq.core.util.stream.StreamUtil;
import org.rhq.enterprise.server.util.LookupUtil;

public class DownloadServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static String SYSPROP_SHOW_DOWNLOADS_LISTING = "rhq.server.show-downloads-listing";
    private static int numActiveDownloads = 0;
    private static boolean showDownloadsListing;

    public void init() throws ServletException {
        this.log("Starting the download servlet");
        String propValue = System.getProperty(SYSPROP_SHOW_DOWNLOADS_LISTING, "true");
        showDownloadsListing = Boolean.parseBoolean(propValue);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.disableBrowserCache(resp);
        if (this.isServerAcceptingRequests()) {
            File requestedDirectory = this.getRequestedDirectory(req);
            if (requestedDirectory == null) {
                ++numActiveDownloads;
                this.download(req, resp);
                --numActiveDownloads;
            } else if (showDownloadsListing) {
                this.outputFileList(requestedDirectory, req, resp);
            } else {
                this.disableBrowserCache(resp);
                resp.sendError(403, "Listing disabled");
            }
        } else {
            this.sendErrorServerNotAcceptingRequests(resp);
        }
    }

    private File getRequestedDirectory(HttpServletRequest req) throws ServletException {
        File rootDownloadsDir;
        String pathInfo = req.getPathInfo();
        try {
            rootDownloadsDir = this.getRootDownloadsDir();
        }
        catch (Throwable t) {
            throw new ServletException(t);
        }
        if (pathInfo == null || pathInfo.equals("") || pathInfo.equals("/")) {
            return rootDownloadsDir;
        }
        File downloadDir = new File(rootDownloadsDir, pathInfo);
        if (downloadDir.isDirectory()) {
            return downloadDir;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void download(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        block6: {
            try {
                File downloadDir = this.getRootDownloadsDir();
                File downloadFile = new File(downloadDir, req.getPathInfo());
                if (this.isForbiddenPath(downloadFile, resp)) break block6;
                if (!downloadFile.exists()) {
                    this.disableBrowserCache(resp);
                    resp.sendError(404, "File does not exist: " + downloadFile.getName());
                    return;
                }
                resp.setContentType(this.getMimeType(downloadFile));
                resp.setHeader("Content-Disposition", "attachment; filename=" + downloadFile.getName());
                resp.setContentLength((int)downloadFile.length());
                resp.setDateHeader("Last-Modified", downloadFile.lastModified());
                FileInputStream stream = new FileInputStream(downloadFile);
                try {
                    StreamUtil.copy((InputStream)stream, (OutputStream)resp.getOutputStream(), (boolean)false);
                }
                finally {
                    stream.close();
                }
            }
            catch (Throwable t) {
                this.log("Failed to stream download content", t);
                this.disableBrowserCache(resp);
                resp.sendError(500, "Failed to download content");
            }
        }
    }

    private String getMimeType(File file) {
        String mimeType = null;
        try {
            mimeType = this.getServletContext().getMimeType(file.getName());
        }
        catch (Throwable t) {
            this.log("Failed to get mime type for [" + file + "]. Cause: " + t);
        }
        if (mimeType == null) {
            mimeType = "application/octet-stream";
        }
        return mimeType;
    }

    private void outputFileList(File requestedDirectory, HttpServletRequest req, HttpServletResponse resp) throws ServletException {
        try {
            if (!this.isForbiddenPath(requestedDirectory, resp)) {
                String dirName = requestedDirectory.getName();
                this.disableBrowserCache(resp);
                resp.setContentType("text/html");
                PrintWriter writer = resp.getWriter();
                writer.println(String.format("<html><head><title>Available Downloads: %s</title></head>", dirName));
                writer.println("<body><h1>Available Downloads</h1>");
                writer.println(String.format("<font size=\"+2\"><b><pre>%s</pre></b></font>", dirName));
                List files = this.getDownloadFiles(requestedDirectory);
                if (files.size() > 0) {
                    String pathInfo = req.getPathInfo();
                    if (!pathInfo.endsWith("/")) {
                        pathInfo = pathInfo + "/";
                    }
                    writer.println("<ul>");
                    for (File file : files) {
                        writer.println("<li><a href=\"" + req.getServletPath() + pathInfo + file.getName() + "\">" + file.getName() + "</a></li>");
                    }
                    writer.println("</ul>");
                } else {
                    writer.println("<h4>NONE</h4>");
                }
                writer.println("</body></html>");
            }
        }
        catch (Exception e) {
            throw new ServletException("Cannot get downloads listing", (Throwable)e);
        }
    }

    private boolean isForbiddenPath(File requestedFile, HttpServletResponse resp) throws IOException {
        boolean forbidden = true;
        if (requestedFile.toString().contains("rhq-agent")) {
            resp.sendError(403, "Use /agentupdate/download to obtain the agent");
        } else if (requestedFile.toString().contains("rhq-client")) {
            resp.sendError(403, "Use /client/download to obtain the client");
        } else {
            forbidden = false;
        }
        return forbidden;
    }

    private void sendErrorServerNotAcceptingRequests(HttpServletResponse resp) throws IOException {
        this.disableBrowserCache(resp);
        resp.sendError(403, "Server Is Down For Maintenance");
    }

    private void disableBrowserCache(HttpServletResponse resp) {
        resp.setHeader("Cache-Control", "no-cache, no-store");
        resp.setHeader("Expires", "-1");
        resp.setHeader("Pragma", "no-cache");
    }

    private List<File> getDownloadFiles(File requestedDirectory) throws Exception {
        File[] filesArray = requestedDirectory.listFiles();
        ArrayList<File> files = new ArrayList<File>();
        if (filesArray != null) {
            for (File file : filesArray) {
                if (!file.isFile()) continue;
                files.add(file);
            }
        }
        return files;
    }

    private File getRootDownloadsDir() throws Exception {
        File serverHomeDir = LookupUtil.getCoreServer().getJBossServerHomeDir();
        File downloadDir = new File(serverHomeDir, "deploy/rhq.ear/rhq-downloads");
        if (!downloadDir.exists()) {
            throw new FileNotFoundException("Missing downloads directory at [" + downloadDir + "]");
        }
        return downloadDir;
    }

    private boolean isServerAcceptingRequests() {
        try {
            Server.OperationMode mode = LookupUtil.getServerManager().getServer().getOperationMode();
            return mode == Server.OperationMode.NORMAL;
        }
        catch (Exception e) {
            return false;
        }
    }
}

