/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.image;

import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;

/*
 * Exception performing whole class analysis ignored.
 */
public class ImageUtil {
    public static BufferedImage convertToIndexColorImage(BufferedImage image) {
        byte[][] clrs = ImageUtil.scrapeColors((BufferedImage)image);
        IndexColorModel model = new IndexColorModel(8, clrs[0].length, clrs[0], clrs[1], clrs[2], 0);
        BufferedImage copy = new BufferedImage(image.getWidth(), image.getHeight(), 13, model);
        ImageUtil.copyPixels((BufferedImage)image, (BufferedImage)copy);
        return copy;
    }

    private static void copyPixels(BufferedImage src, BufferedImage dst, byte[][] rgb) {
        IndexColorModel model = (IndexColorModel)dst.getColorModel();
        int size = model.getMapSize();
        byte[] r = new byte[size];
        byte[] g = new byte[size];
        byte[] b = new byte[size];
        model.getReds(r);
        model.getGreens(g);
        model.getBlues(b);
        WritableRaster srcRaster = src.getRaster();
        int[][] srcPixels = new int[srcRaster.getNumBands()][];
        for (int band = 0; band < srcRaster.getNumBands(); ++band) {
            srcPixels[band] = srcRaster.getSamples(0, 0, srcRaster.getWidth(), srcRaster.getHeight(), band, (int[])null);
        }
        WritableRaster dstRaster = dst.getRaster();
        int[] dstPixels = new int[dstRaster.getWidth() * dstRaster.getHeight()];
        for (int pixel = 0; pixel < dstPixels.length; ++pixel) {
            int i;
            for (i = 0; i < r.length; ++i) {
                byte red = (byte)srcPixels[0][pixel];
                byte green = (byte)srcPixels[1][pixel];
                byte blue = (byte)srcPixels[2][pixel];
                if (red != r[i] || green != g[i] || blue != b[i]) continue;
                dstPixels[pixel] = i;
                break;
            }
            if (i != r.length) continue;
            System.out.println("Missing Color");
        }
        dstRaster.setPixels(0, 0, dstRaster.getWidth(), dstRaster.getHeight(), dstPixels);
    }

    private static void copyPixels(BufferedImage src, BufferedImage dst) {
        IndexColorModel model = (IndexColorModel)dst.getColorModel();
        int size = model.getMapSize();
        byte[] r = new byte[size];
        byte[] g = new byte[size];
        byte[] b = new byte[size];
        model.getReds(r);
        model.getGreens(g);
        model.getBlues(b);
        WritableRaster srcRaster = src.getRaster();
        int[][] srcPixels = new int[srcRaster.getNumBands()][];
        for (int band = 0; band < srcRaster.getNumBands(); ++band) {
            srcPixels[band] = srcRaster.getSamples(0, 0, srcRaster.getWidth(), srcRaster.getHeight(), band, (int[])null);
        }
        WritableRaster dstRaster = dst.getRaster();
        int[] dstPixels = new int[dstRaster.getWidth() * dstRaster.getHeight()];
        for (int pixel = 0; pixel < dstPixels.length; ++pixel) {
            int i;
            for (i = 0; i < r.length; ++i) {
                byte red = (byte)srcPixels[0][pixel];
                byte green = (byte)srcPixels[1][pixel];
                byte blue = (byte)srcPixels[2][pixel];
                if (red != r[i] || green != g[i] || blue != b[i]) continue;
                dstPixels[pixel] = i;
                break;
            }
            if (i != r.length) continue;
            System.out.println("Missing Color");
        }
        dstRaster.setPixels(0, 0, dstRaster.getWidth(), dstRaster.getHeight(), dstPixels);
    }

    private static byte[] findUnusedColor(byte[][] clrs) {
        byte r = 1;
        byte g = 1;
        byte b = 1;
        for (int i = 0; i < clrs.length && (r == clrs[0][i] || g == clrs[1][i] || b == clrs[2][i]); r = (byte)(r + 1), g = (byte)(g + 1), b = (byte)(b + 1), ++i) {
        }
        byte[] result = new byte[]{r, g, b};
        return result;
    }

    public static BufferedImage loadImage(String path) throws IOException {
        ClassLoader ldr = ImageUtil.class.getClassLoader();
        InputStream i = ldr.getResourceAsStream(path);
        BufferedImage result = ImageIO.read(i);
        i.close();
        return result;
    }

    public static byte[][] scrapeColors(BufferedImage image) {
        WritableRaster raster = image.getRaster();
        byte[][] clrs = new byte[raster.getNumBands()][256];
        int[][] pixels = new int[raster.getNumBands()][];
        int nextClr = 0;
        for (int band = 0; band < raster.getNumBands(); ++band) {
            pixels[band] = raster.getSamples(0, 0, raster.getWidth(), raster.getHeight(), band, (int[])null);
        }
        for (int pixel = 0; pixel < pixels[0].length; ++pixel) {
            int i;
            byte red = 0;
            byte green = 0;
            byte blue = 0;
            for (i = 0; i < clrs[0].length; ++i) {
                red = (byte)pixels[0][pixel];
                green = (byte)pixels[1][pixel];
                blue = (byte)pixels[2][pixel];
                if (red == clrs[0][i] && green == clrs[1][i] && blue == clrs[2][i]) break;
            }
            if (i != clrs[0].length || nextClr >= 256) continue;
            clrs[0][nextClr] = red;
            clrs[1][nextClr] = green;
            clrs[2][nextClr++] = blue;
        }
        return clrs;
    }
}

