/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.image.chart;

import org.rhq.enterprise.gui.image.chart.DataPointCollection;
import org.rhq.enterprise.gui.image.data.IStackedDataPoint;

public class PerfDataPointCollection
extends DataPointCollection {
    public static final int UNKNOWN = 0;
    public static final int ENDUSER = 1;
    public static final int WEBSERVER = 2;
    public static final int APPSERVER = 3;
    private static final String ENDUSER_NAME = "End User";
    private static final String WEBSERVER_NAME = "Virtual Host";
    private static final String APPSERVER_NAME = "Web Application";
    private String m_url;
    private int m_type;
    private String m_typeName;
    private int m_requests;

    public int getRequest() {
        return this.m_requests;
    }

    public int getType() {
        return this.m_type;
    }

    public String getTypeName() {
        return this.m_typeName;
    }

    public String getTypeString() {
        String result;
        switch (this.m_type) {
            case 1: {
                result = ENDUSER_NAME;
                break;
            }
            case 2: {
                result = WEBSERVER_NAME;
                break;
            }
            case 3: {
                result = APPSERVER_NAME;
                break;
            }
            default: {
                result = "";
            }
        }
        return result;
    }

    public String getURL() {
        return this.m_url;
    }

    public void setRequest(int requests) {
        this.m_requests = requests;
    }

    public void setType(int type) {
        this.m_type = type;
    }

    public void setType(int type, String name) {
        this.setType(type);
        this.setTypeName(name);
    }

    public void setTypeName(String name) {
        this.m_typeName = name;
    }

    public void setURL(String url) {
        this.m_url = url;
    }

    public boolean isStacked() {
        return this.size() > 0 && this.get(0) instanceof IStackedDataPoint;
    }
}

