/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.navigation.contextmenu;

import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.component.html.HtmlGraphicImage;
import javax.faces.component.html.HtmlOutputLink;
import javax.servlet.http.HttpServletRequest;
import org.rhq.core.domain.resource.composite.ResourceFacets;
import org.rhq.core.gui.util.FacesComponentUtility;
import org.rhq.core.gui.util.FacesContextUtility;
import org.rhq.enterprise.gui.navigation.contextmenu.MenuItemDescriptor;
import org.rhq.enterprise.gui.navigation.contextmenu.MetricMenuItemDescriptor;
import org.rhq.enterprise.gui.navigation.contextmenu.QuickLinksDescriptor;
import org.rhq.enterprise.server.resource.ResourceTypeManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;
import org.richfaces.component.html.ContextMenu;
import org.richfaces.component.html.HtmlMenuGroup;
import org.richfaces.component.html.HtmlMenuItem;
import org.richfaces.component.html.HtmlMenuSeparator;

public abstract class TreeContextMenuBase {
    private static final String STYLE_QUICK_LINKS_ICON = "margin: 2px;";
    private ContextMenu menu;
    private ResourceTypeManagerLocal resourceTypeManager = LookupUtil.getResourceTypeManager();

    public ContextMenu getMenu() {
        return this.menu;
    }

    public void setMenu(ContextMenu menu) throws Exception {
        this.menu = menu;
        menu.getChildren().clear();
        this.init();
        if (this.shouldCreateMenu()) {
            for (String header : this.getMenuHeaders()) {
                this.addMenuItem(null, header, true);
            }
            ResourceFacets facets = this.resourceTypeManager.getResourceFacets(this.getResourceTypeId());
            this.addQuickLinks(this.getMenuQuickLinks(), facets);
            this.addAdditionalMenuItems(menu);
            menu.getChildren().add(new HtmlMenuSeparator());
            this.addGenericSubMenu("View Metric Chart", this.getViewChartsMenuItems());
            this.addMeasurementGraphToViewsMenu(this.getGraphToViewMenuItems());
            this.addGenericSubMenu("Execute Operation", this.getOperationsMenuItems());
        }
    }

    protected void addMenuItem(String id, String value, boolean disabled) {
        HtmlMenuItem nameItem = new HtmlMenuItem();
        if (id != null) {
            nameItem.setId(id);
        }
        nameItem.setValue((Object)value);
        nameItem.setDisabled(disabled);
        nameItem.setStyle("color: black;");
        this.menu.getChildren().add(nameItem);
    }

    private void addQuickLinks(QuickLinksDescriptor descriptor, ResourceFacets facets) {
        HtmlGraphicImage image;
        HtmlOutputLink link;
        HtmlMenuItem quickLinksItem = new HtmlMenuItem();
        quickLinksItem.setSubmitMode("none");
        quickLinksItem.setId(descriptor.getMenuItemId());
        if (descriptor.getMonitoringUrl() != null) {
            link = FacesComponentUtility.addOutputLink((UIComponent)quickLinksItem, null, (String)descriptor.getMonitoringUrl());
            image = FacesComponentUtility.addGraphicImage((UIComponent)link, null, (String)"/images/icons/Monitor_grey_16.png", (String)"Monitor");
            image.setStyle(STYLE_QUICK_LINKS_ICON);
        }
        if (descriptor.getInventoryUrl() != null) {
            link = FacesComponentUtility.addOutputLink((UIComponent)quickLinksItem, null, (String)descriptor.getInventoryUrl());
            image = FacesComponentUtility.addGraphicImage((UIComponent)link, null, (String)"/images/icons/Inventory_grey_16.png", (String)"Inventory");
            image.setStyle(STYLE_QUICK_LINKS_ICON);
        }
        if (descriptor.getAlertsUrl() != null) {
            link = FacesComponentUtility.addOutputLink((UIComponent)quickLinksItem, null, (String)descriptor.getAlertsUrl());
            image = FacesComponentUtility.addGraphicImage((UIComponent)link, null, (String)"/images/icons/Alert_grey_16.png", (String)"Alerts");
            image.setStyle(STYLE_QUICK_LINKS_ICON);
        }
        if (descriptor.getConfigurationUrl() != null && facets.isConfiguration()) {
            link = FacesComponentUtility.addOutputLink((UIComponent)quickLinksItem, null, (String)descriptor.getConfigurationUrl());
            image = FacesComponentUtility.addGraphicImage((UIComponent)link, null, (String)"/images/icons/Configure_grey_16.png", (String)"Configuration");
            image.setStyle(STYLE_QUICK_LINKS_ICON);
        }
        if (descriptor.getOperationUrl() != null && facets.isOperation()) {
            link = FacesComponentUtility.addOutputLink((UIComponent)quickLinksItem, null, (String)descriptor.getOperationUrl());
            image = FacesComponentUtility.addGraphicImage((UIComponent)link, null, (String)"/images/icons/Operation_grey_16.png", (String)"Operations");
            image.setStyle(STYLE_QUICK_LINKS_ICON);
        }
        if (descriptor.getEventUrl() != null && facets.isEvent()) {
            link = FacesComponentUtility.addOutputLink((UIComponent)quickLinksItem, null, (String)descriptor.getEventUrl());
            image = FacesComponentUtility.addGraphicImage((UIComponent)link, null, (String)"/images/icons/Events_grey_16.png", (String)"Events");
            image.setStyle(STYLE_QUICK_LINKS_ICON);
        }
        if (descriptor.getContentUrl() != null && facets.isContent()) {
            link = FacesComponentUtility.addOutputLink((UIComponent)quickLinksItem, null, (String)descriptor.getContentUrl());
            image = FacesComponentUtility.addGraphicImage((UIComponent)link, null, (String)"/images/icons/Content_grey_16.png", (String)"Content");
            image.setStyle(STYLE_QUICK_LINKS_ICON);
        }
        this.menu.getChildren().add(quickLinksItem);
    }

    private void addMeasurementGraphToViewsMenu(List<MetricMenuItemDescriptor> descriptors) {
        boolean onMonitorGraphsSubtab;
        HttpServletRequest request = FacesContextUtility.getRequest();
        String requestURL = request.getRequestURL().toString().toLowerCase();
        boolean bl = onMonitorGraphsSubtab = requestURL.indexOf("/monitor/graphs.xhtml") != -1;
        if (onMonitorGraphsSubtab && descriptors != null) {
            HtmlMenuGroup measurementMenu = new HtmlMenuGroup();
            measurementMenu.setValue((Object)"Add Graph to View");
            this.menu.getChildren().add(measurementMenu);
            measurementMenu.setDisabled(descriptors.isEmpty());
            for (MetricMenuItemDescriptor descriptor : descriptors) {
                HtmlMenuItem menuItem = new HtmlMenuItem();
                menuItem.setValue((Object)descriptor.getName());
                menuItem.setId(descriptor.getMenuItemId());
                String onClickAddMeasurements = "addMetric('" + descriptor.getMetricToken() + "');";
                String onClickRefreshPage = "setTimeout(window.location.reload(), 5000);";
                menuItem.setSubmitMode("none");
                menuItem.setOnclick(onClickAddMeasurements + onClickRefreshPage);
                measurementMenu.getChildren().add(menuItem);
            }
        }
    }

    private void addGenericSubMenu(String menuName, List<MenuItemDescriptor> descriptors) {
        if (descriptors != null) {
            HtmlMenuGroup subMenu = new HtmlMenuGroup();
            subMenu.setValue((Object)menuName);
            this.menu.getChildren().add(subMenu);
            subMenu.setDisabled(descriptors.isEmpty());
            for (MenuItemDescriptor descriptor : descriptors) {
                HtmlMenuItem menuItem = new HtmlMenuItem();
                menuItem.setValue((Object)descriptor.getName());
                menuItem.setId(descriptor.getMenuItemId());
                menuItem.setSubmitMode("none");
                menuItem.setOnclick("document.location.href='" + descriptor.getUrl() + "'");
                subMenu.getChildren().add(menuItem);
            }
        }
    }

    protected abstract void init() throws Exception;

    protected abstract boolean shouldCreateMenu();

    protected abstract List<String> getMenuHeaders();

    protected abstract int getResourceTypeId();

    protected abstract QuickLinksDescriptor getMenuQuickLinks();

    protected void addAdditionalMenuItems(ContextMenu menu) {
    }

    protected abstract List<MenuItemDescriptor> getViewChartsMenuItems();

    protected abstract List<MetricMenuItemDescriptor> getGraphToViewMenuItems();

    protected abstract List<MenuItemDescriptor> getOperationsMenuItems();
}

