/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.startup;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.Connection;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import javax.management.Attribute;
import javax.management.MBeanServer;
import javax.management.MBeanServerInvocationHandler;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.sql.DataSource;
import org.jboss.mx.util.MBeanServerLocator;
import org.quartz.SchedulerException;
import org.rhq.core.db.DatabaseType;
import org.rhq.core.db.DatabaseTypeFactory;
import org.rhq.core.domain.cloud.Server;
import org.rhq.core.domain.configuration.PropertyDynamicType;
import org.rhq.core.domain.resource.Agent;
import org.rhq.core.gui.configuration.helper.DynamicPropertyRetriever;
import org.rhq.core.gui.configuration.helper.PropertyRenderingUtility;
import org.rhq.core.server.ExternalizableStrategy;
import org.rhq.core.util.ObjectNameFactory;
import org.rhq.enterprise.communications.command.server.CommandListener;
import org.rhq.enterprise.communications.util.SecurityUtil;
import org.rhq.enterprise.gui.configuration.DatabaseDynamicPropertyRetriever;
import org.rhq.enterprise.gui.startup.ExternalizableStrategyCommandListener;
import org.rhq.enterprise.gui.startup.ShutdownListener;
import org.rhq.enterprise.gui.startup.StartupServlet;
import org.rhq.enterprise.server.alert.engine.internal.AlertConditionCacheCoordinator;
import org.rhq.enterprise.server.auth.SessionManager;
import org.rhq.enterprise.server.auth.prefs.SubjectPreferencesCache;
import org.rhq.enterprise.server.cloud.instance.ServerManagerLocal;
import org.rhq.enterprise.server.core.AgentManagerLocal;
import org.rhq.enterprise.server.core.CustomJaasDeploymentServiceMBean;
import org.rhq.enterprise.server.core.comm.ServerCommunicationsServiceUtil;
import org.rhq.enterprise.server.core.plugin.PluginDeploymentScannerMBean;
import org.rhq.enterprise.server.plugin.pc.MasterServerPluginContainer;
import org.rhq.enterprise.server.plugin.pc.ServerPluginServiceManagement;
import org.rhq.enterprise.server.resource.ResourceTypeManagerLocal;
import org.rhq.enterprise.server.scheduler.SchedulerLocal;
import org.rhq.enterprise.server.scheduler.jobs.AsyncResourceDeleteJob;
import org.rhq.enterprise.server.scheduler.jobs.CheckForSuspectedAgentsJob;
import org.rhq.enterprise.server.scheduler.jobs.CheckForTimedOutConfigUpdatesJob;
import org.rhq.enterprise.server.scheduler.jobs.CheckForTimedOutContentRequestsJob;
import org.rhq.enterprise.server.scheduler.jobs.CheckForTimedOutOperationsJob;
import org.rhq.enterprise.server.scheduler.jobs.CloudManagerJob;
import org.rhq.enterprise.server.scheduler.jobs.DataPurgeJob;
import org.rhq.enterprise.server.scheduler.jobs.DynaGroupAutoRecalculationJob;
import org.rhq.enterprise.server.scheduler.jobs.PurgeResourceTypesJob;
import org.rhq.enterprise.server.scheduler.jobs.SavedSearchResultCountRecalculationJob;
import org.rhq.enterprise.server.util.LookupUtil;
import org.rhq.enterprise.server.util.concurrent.AlertSerializer;
import org.rhq.enterprise.server.util.concurrent.AvailabilityReportSerializer;

public class StartupServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;

    public void init() throws ServletException {
        this.log("All business tier deployments are complete - finishing the startup");
        LookupUtil.getSystemManager().undeployInstaller();
        AlertConditionCacheCoordinator.getInstance();
        SessionManager.getInstance();
        SubjectPreferencesCache.getInstance();
        AlertSerializer.getSingleton();
        AvailabilityReportSerializer.getSingleton();
        try {
            ResourceTypeManagerLocal typeManager = LookupUtil.getResourceTypeManager();
            typeManager.reloadResourceFacetsCache();
        }
        catch (Throwable t) {
            this.log("Could not load ResourceFacets cache", t);
        }
        this.initializeServer();
        this.startHibernateStatistics();
        this.initScheduler();
        this.startPluginDeployer();
        this.startServerPluginContainer();
        this.installJaasModules();
        this.startServerCommunicationServices();
        this.startScheduler();
        this.scheduleJobs();
        this.startAgentClients();
        this.startEmbeddedAgent();
        this.registerShutdownListener();
        PropertyRenderingUtility.putDynamicPropertyRetriever((PropertyDynamicType)PropertyDynamicType.DATABASE, (DynamicPropertyRetriever)new DatabaseDynamicPropertyRetriever());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeServer() {
        Connection conn = null;
        try {
            DataSource ds = LookupUtil.getDataSource();
            conn = ds.getConnection();
            DatabaseTypeFactory.setDefaultDatabaseType((DatabaseType)DatabaseTypeFactory.getDatabaseType((Connection)conn));
        }
        catch (Exception e) {
            this.log("Could not initialize server: ", (Throwable)e);
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Exception e) {
                    this.log("Failed to close temporary connection used for server initialization: ", (Throwable)e);
                }
            }
        }
        this.createDefaultServerIfNecessary();
        ServerManagerLocal serverManager = LookupUtil.getServerManager();
        if (ServerCommunicationsServiceUtil.getService().getMaintenanceModeAtStartup().booleanValue()) {
            this.log("Server is configured to start up in MAINTENANCE mode");
            Server server = serverManager.getServer();
            Integer[] serverId = new Integer[]{new Integer(server.getId())};
            LookupUtil.getCloudManager().updateServerMode(serverId, Server.OperationMode.MAINTENANCE);
        }
        serverManager.establishCurrentServerMode();
    }

    private void createDefaultServerIfNecessary() {
        String identity = LookupUtil.getServerManager().getIdentity();
        Server server = LookupUtil.getCloudManager().getServerByName(identity);
        if (server == null) {
            server = new Server();
            server.setName(identity);
            String address = "localhost";
            try {
                address = InetAddress.getLocalHost().getCanonicalHostName();
            }
            catch (UnknownHostException e) {
                address = "localhost";
            }
            server.setAddress(address);
            server.setPort(7080);
            server.setSecurePort(7443);
            server.setComputePower(1);
            server.setOperationMode(Server.OperationMode.INSTALLED);
            LookupUtil.getServerManager().create(server);
            this.log("Default server created: " + server);
        }
    }

    private void startHibernateStatistics() throws ServletException {
        this.log("Starting hibernate statistics monitoring");
        try {
            LookupUtil.getSystemManager().enableHibernateStatistics();
        }
        catch (Exception e) {
            throw new ServletException("Cannot start hibernate statistics monitoring", (Throwable)e);
        }
    }

    private void startPluginDeployer() throws ServletException {
        this.log("Starting the agent/server plugin deployer");
        try {
            MBeanServer mbs = MBeanServerLocator.locateJBoss();
            ObjectName name = PluginDeploymentScannerMBean.OBJECT_NAME;
            Class<PluginDeploymentScannerMBean> iface = PluginDeploymentScannerMBean.class;
            PluginDeploymentScannerMBean deployer_mbean = MBeanServerInvocationHandler.newProxyInstance(mbs, name, iface, false);
            deployer_mbean.startDeployment();
        }
        catch (Exception e) {
            throw new ServletException("Cannot start the agent/server plugin deployer", (Throwable)e);
        }
    }

    private void installJaasModules() throws ServletException {
        this.log("Installing JAAS Modules");
        try {
            MBeanServer mbs = MBeanServerLocator.locateJBoss();
            ObjectName name = CustomJaasDeploymentServiceMBean.OBJECT_NAME;
            Class<CustomJaasDeploymentServiceMBean> iface = CustomJaasDeploymentServiceMBean.class;
            CustomJaasDeploymentServiceMBean jaas_mbean = MBeanServerInvocationHandler.newProxyInstance(mbs, name, iface, false);
            jaas_mbean.installJaasModules();
        }
        catch (Exception e) {
            throw new ServletException("Cannot deploy our JAAS login modules!", (Throwable)e);
        }
    }

    private void initScheduler() throws ServletException {
        this.log("Initializing the scheduler");
        try {
            LookupUtil.getSchedulerBean().initQuartzScheduler();
        }
        catch (SchedulerException e) {
            throw new ServletException("Cannot initialize the scheduler!", (Throwable)e);
        }
    }

    private void startScheduler() throws ServletException {
        this.log("Starting the scheduler");
        try {
            LookupUtil.getSchedulerBean().startQuartzScheduler();
        }
        catch (SchedulerException e) {
            throw new ServletException("Cannot start the scheduler!", (Throwable)e);
        }
    }

    private void startServerCommunicationServices() throws ServletException {
        long ensureDownTimeSecs = 70L;
        try {
            ensureDownTimeSecs = Long.parseLong(System.getProperty("rhq.server.ensure-down-time-secs", "70"));
        }
        catch (Exception e) {
            // empty catch block
        }
        long elapsed = this.getElapsedTimeSinceStartup();
        long sleepTime = ensureDownTimeSecs * 1000L - elapsed;
        if (sleepTime > 0L) {
            try {
                this.log("Forcing the server to wait [" + sleepTime + "]ms to ensure agents know we went down");
                Thread.sleep(sleepTime);
            }
            catch (InterruptedException ignore) {
                // empty catch block
            }
        }
        this.log("Starting the server-agent communications services");
        try {
            ServerCommunicationsServiceUtil.getService().startCommunicationServices();
            ServerCommunicationsServiceUtil.getService().getServiceContainer().addCommandListener((CommandListener)new ExternalizableStrategyCommandListener(ExternalizableStrategy.Subsystem.AGENT));
        }
        catch (Exception e) {
            throw new ServletException("Cannot start the server-side communications services", (Throwable)e);
        }
    }

    private void scheduleJobs() throws ServletException {
        long interval;
        long initialDelay;
        this.log("Scheduling some jobs that need to be run");
        SchedulerLocal scheduler = LookupUtil.getSchedulerBean();
        LookupUtil.getServerManager().scheduleServerHeartbeat();
        LookupUtil.getCacheConsistenyManager().scheduleServerCacheReloader();
        LookupUtil.getSystemManager().scheduleConfigCacheReloader();
        try {
            initialDelay = 60000L;
            interval = 60000L;
            scheduler.scheduleSimpleRepeatingJob(SavedSearchResultCountRecalculationJob.class, true, false, 60000L, 60000L);
        }
        catch (Exception e) {
            this.log("Cannot schedule asynchronous resource deletion job: " + e.getMessage());
        }
        try {
            initialDelay = 60000L;
            interval = 300000L;
            scheduler.scheduleSimpleRepeatingJob(AsyncResourceDeleteJob.class, true, false, 60000L, 300000L);
        }
        catch (Exception e) {
            this.log("Cannot schedule asynchronous resource deletion job: " + e.getMessage());
        }
        try {
            long initialDelay2 = 60000L;
            interval = 300000L;
            scheduler.scheduleSimpleRepeatingJob(PurgeResourceTypesJob.class, true, false, 60000L, 300000L);
        }
        catch (Exception e) {
            this.log("Cannot schedule purge resource types job: " + e.getMessage());
        }
        try {
            long initialDelay3 = 60000L;
            interval = 60000L;
            scheduler.scheduleSimpleRepeatingJob(DynaGroupAutoRecalculationJob.class, true, false, 60000L, 60000L);
        }
        catch (Exception e) {
            this.log("Cannot schedule DynaGroup auto-recalculation job: " + e.getMessage());
        }
        try {
            String oldJobName = "org.rhq.enterprise.server.scheduler.jobs.ClusterManagerJob";
            boolean foundAndDeleted = scheduler.deleteJob(oldJobName, oldJobName);
            if (foundAndDeleted) {
                this.log("Unscheduling deprecated job references for " + oldJobName);
            } else {
                this.log("No deprecated job references found for " + oldJobName);
            }
            long initialDelay4 = 120000L;
            long interval2 = 30000L;
            scheduler.scheduleSimpleRepeatingJob(CloudManagerJob.class, true, false, 120000L, 30000L);
        }
        catch (Exception e) {
            this.log("Cannot schedule cloud management job: " + e.getMessage());
        }
        try {
            long initialDelay5 = 600000L;
            interval = 60000L;
            scheduler.scheduleSimpleRepeatingJob(CheckForSuspectedAgentsJob.class, true, false, 600000L, 60000L);
        }
        catch (Exception e) {
            this.log("Cannot schedule suspected Agents job: " + e.getMessage());
        }
        try {
            long initialDelay6 = 180000L;
            interval = 600000L;
            scheduler.scheduleSimpleRepeatingJob(CheckForTimedOutOperationsJob.class, true, false, 180000L, 600000L);
        }
        catch (Exception e) {
            this.log("Cannot schedule check-for-timed-out-operations job: " + e.getMessage());
        }
        try {
            long initialDelay7 = 240000L;
            interval = 600000L;
            scheduler.scheduleSimpleRepeatingJob(CheckForTimedOutConfigUpdatesJob.class, true, false, 240000L, 600000L);
        }
        catch (Exception e) {
            this.log("Cannot schedule check-for-timed-out-configuration-update-requests job: " + e.getMessage());
        }
        try {
            long initialDelay8 = 300000L;
            interval = 900000L;
            scheduler.scheduleSimpleRepeatingJob(CheckForTimedOutContentRequestsJob.class, true, false, 300000L, 900000L);
        }
        catch (Exception e) {
            this.log("Cannot schedule check-for-timed-out-artifact-requests job: " + e.getMessage());
        }
        try {
            String cronString = "0 0 * * * ?";
            scheduler.scheduleSimpleCronJob(DataPurgeJob.class, true, false, cronString);
        }
        catch (Exception e) {
            this.log("Cannot schedule data purge job: " + e.getMessage());
        }
        try {
            ServerPluginServiceManagement mbean = LookupUtil.getServerPluginService();
            MasterServerPluginContainer masterPC = mbean.getMasterPluginContainer();
            masterPC.scheduleAllPluginJobs();
        }
        catch (Exception e) {
            this.log("Cannot schedule server plugin jobs: " + e.getMessage());
        }
    }

    private void startAgentClients() {
        this.log("Starting agent clients - any persisted messages with guaranteed delivery will be sent");
        AgentManagerLocal agentManager = LookupUtil.getAgentManager();
        List agents = agentManager.getAllAgents();
        if (agents != null) {
            for (Agent agent : agents) {
                agentManager.getAgentClient(agent);
            }
        }
    }

    private void startEmbeddedAgent() throws ServletException {
        ObjectName agentBootstrapMBean = ObjectNameFactory.create((String)"rhq:service=EmbeddedAgentBootstrap");
        String agentEnabledAttribute = "AgentEnabled";
        String startAgentMethod = "startAgent";
        String configurationOverridesAttribute = "ConfigurationOverrides";
        MBeanServer mbs = MBeanServerLocator.locateJBoss();
        try {
            String enabled = (String)mbs.getAttribute(agentBootstrapMBean, "AgentEnabled");
            try {
                if (Boolean.valueOf(enabled).booleanValue()) {
                    this.log("The embedded Agent is installed and enabled - it will now be started...");
                    String AgentConfigurationConstants_SERVER_TRANSPORT = "rhq.agent.server.transport";
                    String AgentConfigurationConstants_SERVER_BIND_ADDRESS = "rhq.agent.server.bind-address";
                    String AgentConfigurationConstants_SERVER_BIND_PORT = "rhq.agent.server.bind-port";
                    Properties overrides = (Properties)mbs.getAttribute(agentBootstrapMBean, "ConfigurationOverrides");
                    String serverTransport = overrides.getProperty(AgentConfigurationConstants_SERVER_TRANSPORT);
                    String serverAddress = overrides.getProperty(AgentConfigurationConstants_SERVER_BIND_ADDRESS);
                    String serverPort = overrides.getProperty(AgentConfigurationConstants_SERVER_BIND_PORT);
                    String agentAddress = overrides.getProperty("rhq.communications.connector.bind-address");
                    Server server = LookupUtil.getServerManager().getServer();
                    if (agentAddress == null || agentAddress.trim().equals("")) {
                        overrides.setProperty("rhq.communications.connector.bind-address", server.getAddress());
                    }
                    if (serverAddress == null || serverAddress.trim().equals("")) {
                        overrides.setProperty(AgentConfigurationConstants_SERVER_BIND_ADDRESS, server.getAddress());
                    }
                    if (serverPort == null || serverPort.trim().equals("")) {
                        if (SecurityUtil.isTransportSecure((String)serverTransport)) {
                            overrides.setProperty(AgentConfigurationConstants_SERVER_BIND_PORT, Integer.toString(server.getSecurePort()));
                        } else {
                            overrides.setProperty(AgentConfigurationConstants_SERVER_BIND_PORT, Integer.toString(server.getPort()));
                        }
                    }
                    mbs.setAttribute(agentBootstrapMBean, new Attribute("ConfigurationOverrides", overrides));
                    1 agentStartRunnable = new /* Unavailable Anonymous Inner Class!! */;
                    Thread agentStartThread = new Thread((Runnable)agentStartRunnable, "Embedded Agent Startup");
                    agentStartThread.setDaemon(true);
                    agentStartThread.start();
                } else {
                    this.log("The embedded Agent is not enabled, so it will not be started.");
                }
            }
            catch (Throwable t) {
                throw new ServletException("Failed to start the embedded Agent.", t);
            }
        }
        catch (ServletException se) {
            throw se;
        }
        catch (Throwable t) {
            this.log("The embedded Agent is not installed, so it will not be started (" + t + ").");
        }
    }

    private void startServerPluginContainer() throws ServletException {
        this.log("Starting the master server plugin container...");
        try {
            ServerPluginServiceManagement mbean = LookupUtil.getServerPluginService();
            mbean.startMasterPluginContainerWithoutSchedulingJobs();
        }
        catch (Exception e) {
            throw new ServletException("Cannot start the master server plugin container!", (Throwable)e);
        }
    }

    private void registerShutdownListener() throws ServletException {
        try {
            ObjectName jbossServerName = new ObjectName("jboss.system:type=Server");
            MBeanServer jbossServer = MBeanServerLocator.locateJBoss();
            jbossServer.addNotificationListener(jbossServerName, (NotificationListener)new ShutdownListener(), null, null);
        }
        catch (Exception e) {
            throw new ServletException("Failed to register the Server Shutdown Listener", (Throwable)e);
        }
    }

    private long getElapsedTimeSinceStartup() throws ServletException {
        long elapsed;
        try {
            ObjectName jbossServerName = new ObjectName("jboss.system:type=Server");
            MBeanServer jbossServer = MBeanServerLocator.locateJBoss();
            Date startTime = (Date)jbossServer.getAttribute(jbossServerName, "StartDate");
            long currentTime = System.currentTimeMillis();
            elapsed = currentTime - startTime.getTime();
        }
        catch (Exception e) {
            elapsed = 0L;
        }
        return elapsed;
    }
}

