/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.legacy.action.resource.common.monitor.alerts;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.alert.Alert;
import org.rhq.core.domain.alert.AlertCondition;
import org.rhq.core.domain.alert.AlertConditionCategory;
import org.rhq.core.domain.alert.AlertDampening;
import org.rhq.core.domain.alert.AlertDefinition;
import org.rhq.core.domain.alert.AlertDefinitionContext;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.measurement.DataType;
import org.rhq.core.domain.measurement.MeasurementSchedule;
import org.rhq.core.domain.measurement.MeasurementUnits;
import org.rhq.core.domain.operation.OperationDefinition;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.domain.resource.group.ResourceGroup;
import org.rhq.core.server.MeasurementConverter;
import org.rhq.enterprise.gui.legacy.action.resource.ResourceForm;
import org.rhq.enterprise.gui.legacy.beans.AlertConditionBean;
import org.rhq.enterprise.gui.legacy.beans.OptionItem;
import org.rhq.enterprise.gui.legacy.exception.ParameterNotFoundException;
import org.rhq.enterprise.gui.legacy.util.RequestUtils;
import org.rhq.enterprise.gui.util.EnterpriseFacesContextUtility;
import org.rhq.enterprise.server.alert.AlertDefinitionManagerLocal;
import org.rhq.enterprise.server.measurement.util.MeasurementFormatter;
import org.rhq.enterprise.server.operation.OperationManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

/*
 * Exception performing whole class analysis ignored.
 */
public final class AlertDefUtil {
    private static Log log = LogFactory.getLog(AlertDefUtil.class);

    public static long getSecondsConsideringUnits(Integer duration, AlertDampening.TimeUnits units) {
        return units.getNumberOfSeconds() * (long)duration.intValue();
    }

    public static List<AlertConditionBean> getAlertConditionBeanList(Subject subject, HttpServletRequest request, Set<AlertCondition> conds) {
        ArrayList<AlertConditionBean> alertCondBeans = new ArrayList<AlertConditionBean>(conds.size());
        boolean first = true;
        for (AlertCondition cond : conds) {
            String conditionDisplayText = AlertDefUtil.formatAlertConditionForDisplay((AlertCondition)cond, (HttpServletRequest)request);
            AlertConditionBean alertCondBean = new AlertConditionBean(conditionDisplayText, first);
            alertCondBeans.add(alertCondBean);
            first = false;
        }
        return alertCondBeans;
    }

    public static String formatAlertConditionForDisplay(AlertCondition cond, HttpServletRequest request) {
        AlertConditionCategory category = cond.getCategory();
        StringBuffer textValue = new StringBuffer();
        if (category == AlertConditionCategory.CONTROL) {
            try {
                AlertDefinitionManagerLocal alertDefinitionManager = LookupUtil.getAlertDefinitionManager();
                Integer alertDefinitionId = cond.getAlertDefinition().getId();
                Integer resourceTypeId = null;
                resourceTypeId = alertDefinitionManager.isTemplate(alertDefinitionId) ? Integer.valueOf(cond.getAlertDefinition().getResourceType().getId()) : (alertDefinitionManager.isGroupAlertDefinition(alertDefinitionId) ? Integer.valueOf(cond.getAlertDefinition().getGroup().getResourceType().getId()) : Integer.valueOf(cond.getAlertDefinition().getResource().getResourceType().getId()));
                String operationName = cond.getName();
                OperationManagerLocal operationManager = LookupUtil.getOperationManager();
                OperationDefinition definition = operationManager.getOperationDefinitionByResourceTypeAndName(resourceTypeId.intValue(), operationName, false);
                textValue.append(definition.getDisplayName()).append(' ');
            }
            catch (Exception e) {
                textValue.append(cond.getName()).append(' ');
            }
        } else if (category == AlertConditionCategory.RESOURCE_CONFIG) {
            textValue.append(RequestUtils.message((HttpServletRequest)request, (String)"alert.config.props.CB.Content.ResourceConfiguration")).append(' ');
        } else if (cond.getMeasurementDefinition() != null && cond.getMeasurementDefinition().getDataType().equals((Object)DataType.CALLTIME)) {
            textValue.append(cond.getMeasurementDefinition().getDisplayName());
            textValue.append(" (");
            textValue.append(cond.getOption());
            if (cond.getName() != null && !cond.getName().equals("")) {
                textValue.append("; pattern=[");
                textValue.append(cond.getName());
                textValue.append("]");
            }
            textValue.append(") ");
        } else {
            textValue.append(cond.getName()).append(' ');
        }
        if (category == AlertConditionCategory.CONTROL) {
            textValue.append(cond.getOption());
        } else if (category == AlertConditionCategory.THRESHOLD || category == AlertConditionCategory.BASELINE) {
            textValue.append(cond.getComparator());
            textValue.append(' ');
            MeasurementSchedule schedule = null;
            double value = cond.getThreshold();
            MeasurementUnits units = category == AlertConditionCategory.THRESHOLD ? cond.getMeasurementDefinition().getUnits() : MeasurementUnits.PERCENTAGE;
            String formatted = MeasurementConverter.format((Double)value, (MeasurementUnits)units, (boolean)true);
            textValue.append(formatted);
            if (category == AlertConditionCategory.BASELINE) {
                textValue.append(" of ");
                textValue.append(MeasurementFormatter.getBaselineText((String)cond.getOption(), schedule));
            }
        } else if (category == AlertConditionCategory.RESOURCE_CONFIG || category == AlertConditionCategory.CHANGE || category == AlertConditionCategory.TRAIT) {
            if (cond.getComparator() != null) {
                textValue.append(RequestUtils.message((HttpServletRequest)request, (String)"common.field.value")).append(' ');
                textValue.append(RequestUtils.message((HttpServletRequest)request, (String)("alert.config.props.CB.Content.CalltimeOperators." + cond.getComparator())));
            } else {
                textValue.append(RequestUtils.message((HttpServletRequest)request, (String)"alert.current.list.ValueChanged"));
            }
            if (cond.getThreshold() != null) {
                textValue.append(" ").append(RequestUtils.message((HttpServletRequest)request, (String)"alert.config.props.CB.Content.AtLeast"));
                textValue.append(" ").append(MeasurementConverter.format((Double)cond.getThreshold(), (MeasurementUnits)MeasurementUnits.PERCENTAGE, (boolean)true));
            }
        } else if (category == AlertConditionCategory.EVENT) {
            String msgKey = "alert.config.props.CB.EventSeverity";
            ArrayList<String> args = new ArrayList<String>(2);
            args.add(cond.getName());
            if (cond.getOption() != null && cond.getOption().length() > 0) {
                msgKey = msgKey + ".RegexMatch";
                args.add(cond.getOption());
            }
            textValue = new StringBuffer(RequestUtils.message((HttpServletRequest)request, (String)msgKey, (Object[])args.toArray()));
        } else if (category == AlertConditionCategory.AVAILABILITY) {
            textValue = new StringBuffer(RequestUtils.message((HttpServletRequest)request, (String)"alert.config.props.CB.Availability", (Object[])new String[]{cond.getOption()}));
        }
        return textValue.toString();
    }

    public static void setAlertDampeningRequestAttributes(HttpServletRequest request, AlertDefinition alertDefinition) {
        String enableActionsResource;
        AlertDampening alertDampening = alertDefinition.getAlertDampening();
        Integer enableActionsHowLong = alertDampening.getPeriod();
        AlertDampening.TimeUnits enableActionsHowLongUnits = alertDampening.getPeriodUnits();
        Integer enableActionsHowMany = alertDampening.getValue();
        AlertDampening.TimeUnits enableActionsHowManyUnits = alertDampening.getValueUnits();
        AlertDampening.Category alertDampeningCategory = alertDampening.getCategory();
        if (alertDampeningCategory == AlertDampening.Category.NONE) {
            enableActionsResource = "alert.config.props.CB.DampenNone";
        } else if (alertDampeningCategory == AlertDampening.Category.ONCE) {
            enableActionsResource = "alert.config.props.CB.DampenOnce";
        } else if (alertDampeningCategory == AlertDampening.Category.CONSECUTIVE_COUNT) {
            enableActionsResource = "alert.config.props.CB.DampenConsecutiveCount";
        } else if (alertDampeningCategory == AlertDampening.Category.PARTIAL_COUNT) {
            enableActionsResource = "alert.config.props.CB.DampenPartialCount";
        } else if (alertDampeningCategory == AlertDampening.Category.INVERSE_COUNT) {
            enableActionsResource = "alert.config.props.CB.DampenInverseCount";
        } else if (alertDampeningCategory == AlertDampening.Category.DURATION_COUNT) {
            enableActionsResource = "alert.config.props.CB.DampenDurationCount";
        } else {
            throw new RuntimeException("Alert dampening category " + alertDampeningCategory + " does not have a corresponding message in ApplicationResources.properties");
        }
        request.setAttribute("enableActionsResource", (Object)enableActionsResource);
        request.setAttribute("enableActionsHowLong", (Object)enableActionsHowLong);
        request.setAttribute("enableActionsHowLongUnits", (Object)enableActionsHowLongUnits);
        request.setAttribute("enableActionsHowMany", (Object)enableActionsHowMany);
        request.setAttribute("enableActionsHowManyUnits", (Object)enableActionsHowManyUnits);
    }

    @Deprecated
    public static AlertDefinition getAlertDefinition(HttpServletRequest request) throws ServletException {
        AlertDefinition alertDefinition = (AlertDefinition)request.getAttribute("alertDef");
        if (null == alertDefinition) {
            String alertDefinitionParameter = request.getParameter("ad");
            if (null == alertDefinitionParameter) {
                throw new ParameterNotFoundException("ad");
            }
            Subject user = RequestUtils.getSubject((HttpServletRequest)request);
            int alertDefinitionId = Integer.parseInt(alertDefinitionParameter);
            alertDefinition = LookupUtil.getAlertDefinitionManager().getAlertDefinitionById(user, alertDefinitionId);
            request.setAttribute("alertDef", (Object)alertDefinition);
            request.setAttribute("alertNotifCount", (Object)alertDefinition.getAlertNotifications().size());
            AlertDefinitionContext context = AlertDefinitionContext.get((AlertDefinition)alertDefinition);
            if (context == AlertDefinitionContext.Type) {
                RequestUtils.setResourceType((HttpServletRequest)request, (ResourceType)alertDefinition.getResourceType());
            } else if (context == AlertDefinitionContext.Group) {
                RequestUtils.setResourceGroup((HttpServletRequest)request, (ResourceGroup)alertDefinition.getGroup());
            } else {
                RequestUtils.setResource((HttpServletRequest)request, (Resource)alertDefinition.getResource());
            }
            log.trace((Object)("adv.id=" + alertDefinitionId));
        }
        return alertDefinition;
    }

    public static List<OptionItem> getControlActions(Subject subject, Integer id, ResourceForm.FormContext context) throws Exception {
        ArrayList<OptionItem> operations = new ArrayList<OptionItem>();
        OperationManagerLocal operationManager = LookupUtil.getOperationManager();
        List operationDefinitions = null;
        if (context == ResourceForm.FormContext.Type) {
            operationDefinitions = operationManager.findSupportedResourceTypeOperations(subject, id.intValue(), true);
        } else if (context == ResourceForm.FormContext.Group) {
            operationDefinitions = operationManager.findSupportedGroupOperations(subject, id.intValue(), true);
        } else if (context == ResourceForm.FormContext.Resource) {
            operationDefinitions = operationManager.findSupportedResourceOperations(subject, id.intValue(), true);
        } else {
            throw new IllegalArgumentException("Unsupported form context: " + context);
        }
        for (OperationDefinition definition : operationDefinitions) {
            if (definition.getParametersConfigurationDefinition() != null) continue;
            OptionItem next = new OptionItem(definition.getDisplayName(), String.valueOf(definition.getId()));
            operations.add(next);
        }
        return operations;
    }

    public static String getAlertRecoveryInfo(Alert alert, int resourceId) {
        Subject subject = EnterpriseFacesContextUtility.getSubject();
        if (alert.getRecoveryId() != 0) {
            Integer recoveryAlertId = alert.getRecoveryId();
            AlertDefinitionManagerLocal alertDefinitionManagerLocal = LookupUtil.getAlertDefinitionManager();
            AlertDefinition recoveryAlertDefinition = alertDefinitionManagerLocal.getAlertDefinitionById(subject, recoveryAlertId.intValue());
            return "Triggered '<a href=\"/alerts/Config.do?mode=viewRoles&id=" + resourceId + "&ad" + recoveryAlertId + "\">" + recoveryAlertDefinition.getName() + "</a>' to be re-enabled";
        }
        if (alert.getWillRecover()) {
            return "This alert caused its alert definition to be disabled";
        }
        return "N/A";
    }
}

