/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.legacy.action.resource.group.inventory;

import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.domain.resource.group.GroupCategory;
import org.rhq.core.domain.resource.group.ResourceGroup;
import org.rhq.core.util.collection.ArrayUtils;
import org.rhq.enterprise.gui.legacy.action.BaseAction;
import org.rhq.enterprise.gui.legacy.action.resource.group.inventory.GroupForm;
import org.rhq.enterprise.gui.legacy.util.RequestUtils;
import org.rhq.enterprise.server.resource.ResourceTypeManagerLocal;
import org.rhq.enterprise.server.resource.ResourceTypeNotFoundException;
import org.rhq.enterprise.server.resource.group.ResourceGroupManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

public class NewGroupAction
extends BaseAction {
    private Log log = LogFactory.getLog(NewGroupAction.class);

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        GroupForm newForm = (GroupForm)form;
        ActionForward forward = this.checkSubmit(request, mapping, form);
        if (forward != null) {
            return forward;
        }
        Subject subject = RequestUtils.getSubject((HttpServletRequest)request);
        Integer resourceTypeId = newForm.getResourceTypeId();
        String newGroupName = newForm.getName();
        GroupCategory category = null;
        try {
            category = newForm.getGroupCategory();
        }
        catch (Exception e) {
            RequestUtils.setError((HttpServletRequest)request, (String)"resource.group.inventory.error.GroupTypeIsRequired");
            return this.returnFailure(request, mapping);
        }
        ResourceTypeManagerLocal resourceTypeManager = LookupUtil.getResourceTypeManager();
        ResourceGroupManagerLocal resourceGroupManager = LookupUtil.getResourceGroupManager();
        ResourceGroup newGroup = new ResourceGroup(newGroupName);
        try {
            if (category == GroupCategory.COMPATIBLE) {
                ResourceType groupResourceType = resourceTypeManager.getResourceTypeById(subject, resourceTypeId.intValue());
                newGroup.setResourceType(groupResourceType);
            }
        }
        catch (ResourceTypeNotFoundException ex) {
            this.log.debug((Object)"group created failed: ", (Throwable)ex);
            RequestUtils.setError((HttpServletRequest)request, (String)"resource.group.inventory.error.ResourceTypeIdNotFound");
            return this.returnFailure(request, mapping);
        }
        String location = newForm.getLocation();
        String description = newForm.getDescription();
        boolean recursive = newForm.isRecursive();
        try {
            newGroup.setDescription(description);
            newGroup.setRecursive(recursive);
            this.log.trace((Object)("creating group [" + newForm.getName() + "]" + " with attributes " + newForm));
            resourceGroupManager.createResourceGroup(subject, newGroup);
        }
        catch (Throwable t) {
            this.log.debug((Object)"group creation failed: ", t);
            RequestUtils.setError((HttpServletRequest)request, (String)"resource.group.inventory.error.GroupCreateError", (String)t.getMessage());
            return this.returnFailure(request, mapping);
        }
        int groupId = newGroup.getId();
        Integer[] newResourceIds = newForm.getResourceIds();
        if (newResourceIds != null && newResourceIds.length > 0) {
            HttpSession session = request.getSession();
            session.removeAttribute("ResourceIds");
            session.removeAttribute("ResourceType");
            resourceGroupManager.addResourcesToGroup(subject, groupId, ArrayUtils.unwrapArray((Integer[])newResourceIds));
        }
        RequestUtils.setConfirmation((HttpServletRequest)request, (String)"resource.group.inventory.confirm.CreateGroup", (Object)newGroupName);
        HashMap<String, Object> forwardParams = new HashMap<String, Object>(2);
        forwardParams.put("groupId", groupId);
        forwardParams.put("category", category.name());
        return this.returnNew(request, mapping, forwardParams);
    }
}

