/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.legacy.taglib.display;

import javax.servlet.http.HttpServletRequest;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.domain.resource.composite.ResourceComposite;
import org.rhq.core.domain.resource.composite.ResourceFacets;
import org.rhq.enterprise.gui.legacy.taglib.display.QuicknavDecorator;
import org.rhq.enterprise.server.resource.ResourceFacetsCache;

public class ResourceQuicknavDecorator
extends QuicknavDecorator {
    private static final String MONITOR_URL = "/rhq/resource/monitor/graphs.xhtml";
    private static final String EVENTS_URL = "/rhq/resource/events/history.xhtml";
    private static final String INVENTORY_URL = "/rhq/resource/inventory/view.xhtml";
    private static final String CONFIGURE_URL = "/rhq/resource/configuration/view.xhtml";
    private static final String OPERATIONS_URL = "/rhq/resource/operation/resourceOperationScheduleNew.xhtml";
    private static final String ALERT_URL = "/rhq/resource/alert/listAlertDefinitions.xhtml";
    private static final String CONTENT_URL = "/rhq/resource/content/view.xhtml?mode=view";
    private ResourceComposite resourceComposite;
    private ResourceFacets resourceFacets;

    public String decorate(Object columnValue) throws Exception {
        this.resourceComposite = (ResourceComposite)columnValue;
        ResourceType type = this.resourceComposite.getResource().getResourceType();
        this.resourceFacets = type == null ? ResourceFacets.NONE : ResourceFacetsCache.getSingleton().getResourceFacets(type.getId());
        return this.getOutput();
    }

    protected String getFullURL(String url) {
        HttpServletRequest request = (HttpServletRequest)this.getPageContext().getRequest();
        return request.getContextPath() + url + (url.indexOf("?") == -1 ? "?" : "&") + "id" + "=" + this.resourceComposite.getResource().getId();
    }

    protected String getTagName() {
        return "resource-quicknav-decorator";
    }

    protected boolean isMonitorSupported() {
        return true;
    }

    protected boolean isEventsSupported() {
        return this.resourceFacets.isEvent();
    }

    protected boolean isInventorySupported() {
        return true;
    }

    protected boolean isConfigureSupported() {
        return this.resourceFacets.isConfiguration();
    }

    protected boolean isOperationsSupported() {
        return this.resourceFacets.isOperation();
    }

    protected boolean isAlertSupported() {
        return true;
    }

    protected boolean isContentSupported() {
        return this.resourceFacets.isContent();
    }

    protected boolean isMonitorAllowed() {
        return true;
    }

    protected boolean isEventsAllowed() {
        return true;
    }

    protected boolean isInventoryAllowed() {
        return true;
    }

    protected boolean isConfigureAllowed() {
        return true;
    }

    protected boolean isOperationsAllowed() {
        return true;
    }

    protected boolean isAlertAllowed() {
        return true;
    }

    protected boolean isContentAllowed() {
        return true;
    }

    protected String getMonitorURL() {
        return MONITOR_URL;
    }

    protected String getEventsURL() {
        return EVENTS_URL;
    }

    protected String getInventoryURL() {
        return INVENTORY_URL;
    }

    protected String getConfigureURL() {
        return CONFIGURE_URL;
    }

    protected String getOperationsURL() {
        return OPERATIONS_URL;
    }

    protected String getAlertURL() {
        return ALERT_URL;
    }

    protected String getContentURL() {
        return CONTENT_URL;
    }
}

