/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.measurement.schedule.autogroup;

import javax.faces.application.FacesMessage;
import javax.faces.model.DataModel;
import org.rhq.core.gui.util.FacesContextUtility;
import org.rhq.core.gui.util.StringUtility;
import org.rhq.enterprise.gui.common.framework.PagedDataTableUIBean;
import org.rhq.enterprise.gui.common.paging.PageControlView;
import org.rhq.enterprise.gui.common.time.DurationComponent;
import org.rhq.enterprise.gui.measurement.schedule.autogroup.ListAutoGroupMeasurementScheduleUIBean;
import org.rhq.enterprise.server.measurement.MeasurementScheduleManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

public class ListAutoGroupMeasurementScheduleUIBean
extends PagedDataTableUIBean {
    public static final String MANAGED_BEAN_NAME = "ListAutoGroupMeasurementScheduleUIBean";
    private MeasurementScheduleManagerLocal measurementScheduleManager = LookupUtil.getMeasurementScheduleManager();
    private DurationComponent duration;

    public DurationComponent getDuration() {
        return this.duration;
    }

    public void setDuration(DurationComponent duration) {
        this.duration = duration;
    }

    public String disableSelected() {
        int parentResourceId = (Integer)FacesContextUtility.getRequiredRequestParameter((String)"parent", Integer.class);
        int childResourceType = (Integer)FacesContextUtility.getRequiredRequestParameter((String)"type", Integer.class);
        int[] measurementDefinitionIds = this.getSelectedAutoGroupScheduleList();
        try {
            this.measurementScheduleManager.disableSchedulesForAutoGroup(this.getSubject(), parentResourceId, childResourceType, measurementDefinitionIds);
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_INFO, (String)("Disabled " + measurementDefinitionIds.length + " schedules."));
        }
        catch (Exception e) {
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)"Failed to disable selected schedules.", (Throwable)e);
        }
        return "success";
    }

    public String enableSelected() {
        int parentResourceId = (Integer)FacesContextUtility.getRequiredRequestParameter((String)"parent", Integer.class);
        int childResourceType = (Integer)FacesContextUtility.getRequiredRequestParameter((String)"type", Integer.class);
        int[] measurementDefinitionIds = this.getSelectedAutoGroupScheduleList();
        try {
            this.measurementScheduleManager.enableSchedulesForAutoGroup(this.getSubject(), parentResourceId, childResourceType, measurementDefinitionIds);
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_INFO, (String)("Enabled " + measurementDefinitionIds.length + " schedules."));
        }
        catch (Exception e) {
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)"Failed to enable selected schedules.", (Throwable)e);
        }
        return "success";
    }

    public String enableAndSetSelected() {
        long collectionInterval = this.duration.getMillis();
        int parentResourceId = (Integer)FacesContextUtility.getRequiredRequestParameter((String)"parent", Integer.class);
        int childResourceType = (Integer)FacesContextUtility.getRequiredRequestParameter((String)"type", Integer.class);
        int[] measurementDefinitionIds = this.getSelectedAutoGroupScheduleList();
        try {
            this.measurementScheduleManager.updateSchedulesForAutoGroup(this.getSubject(), parentResourceId, childResourceType, measurementDefinitionIds, collectionInterval);
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_INFO, (String)("Enabled and set " + measurementDefinitionIds.length + " schedules."));
        }
        catch (Exception e) {
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)"Failed to enabled and set selected schedules.", (Throwable)e);
        }
        return "success";
    }

    public DataModel getDataModel() {
        if (this.dataModel == null) {
            this.dataModel = new A(this, PageControlView.AutoGroupMeasurementScheduleList, MANAGED_BEAN_NAME);
        }
        return this.dataModel;
    }

    private int[] getSelectedAutoGroupScheduleList() {
        String[] resourceSchedules = FacesContextUtility.getRequest().getParameterValues("selectedAutoGroupSchedules");
        return StringUtility.getIntArray((String[])resourceSchedules);
    }

    static /* synthetic */ MeasurementScheduleManagerLocal access$000(ListAutoGroupMeasurementScheduleUIBean x0) {
        return x0.measurementScheduleManager;
    }
}

