/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.navigation.group;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.resource.flyweight.AutoGroupCompositeFlyweight;
import org.rhq.core.domain.resource.flyweight.ResourceFlyweight;
import org.rhq.core.domain.resource.group.ClusterKey;
import org.rhq.core.domain.resource.group.GroupCategory;
import org.rhq.core.domain.resource.group.ResourceGroup;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.gui.util.FacesContextUtility;
import org.rhq.enterprise.gui.navigation.group.ResourceGroupTreeNode;
import org.rhq.enterprise.gui.navigation.resource.ResourceTreeModelUIBean;
import org.rhq.enterprise.gui.navigation.resource.ResourceTreeNode;
import org.rhq.enterprise.gui.util.EnterpriseFacesContextUtility;
import org.rhq.enterprise.server.resource.ResourceManagerLocal;
import org.rhq.enterprise.server.resource.group.ResourceGroupManagerLocal;
import org.rhq.enterprise.server.util.HibernatePerformanceMonitor;
import org.rhq.enterprise.server.util.LookupUtil;

public class ResourceGroupTreeModelUIBean {
    private final Log log = LogFactory.getLog(ResourceGroupTreeModelUIBean.class);
    private ResourceGroupTreeNode rootNode = null;
    private List<ResourceGroupTreeNode> children = new ArrayList();
    private ResourceGroupManagerLocal groupManager = LookupUtil.getResourceGroupManager();
    private ResourceManagerLocal resourceManager = LookupUtil.getResourceManager();
    private String nodeTitle;

    private void loadTree() {
        ResourceGroup parentGroup;
        Integer parentGroupId = (Integer)FacesContextUtility.getOptionalRequestParameter((String)"parentGroupId", Integer.class);
        if (parentGroupId != null) {
            parentGroup = this.groupManager.getResourceGroupById(EnterpriseFacesContextUtility.getSubject(), parentGroupId.intValue(), GroupCategory.COMPATIBLE);
        } else {
            parentGroup = EnterpriseFacesContextUtility.getResourceGroup();
            if (parentGroup.getClusterResourceGroup() != null) {
                parentGroup = parentGroup.getClusterResourceGroup();
            }
        }
        long start = System.currentTimeMillis();
        long monitorId = HibernatePerformanceMonitor.get().start();
        List resources = this.resourceManager.findResourcesByCompatibleGroup(EnterpriseFacesContextUtility.getSubject(), parentGroup.getId(), PageControl.getUnlimitedInstance());
        long end = System.currentTimeMillis();
        HibernatePerformanceMonitor.get().stop(monitorId, "ResourceGroupTree group resources");
        this.log.debug((Object)("Loaded  " + resources.size() + " resources by group in " + (end - start)));
        start = System.currentTimeMillis();
        monitorId = HibernatePerformanceMonitor.get().start();
        List members = this.resourceManager.findExplicitResourceIdsByResourceGroup(parentGroup.getId());
        end = System.currentTimeMillis();
        HibernatePerformanceMonitor.get().stop(monitorId, "ResourceGroupTree group members");
        this.log.debug((Object)("Loaded  " + members.size() + " members by group in " + (end - start)));
        start = System.currentTimeMillis();
        monitorId = HibernatePerformanceMonitor.get().start();
        this.rootNode = this.load(parentGroup, resources, members);
        end = System.currentTimeMillis();
        HibernatePerformanceMonitor.get().stop(monitorId, "ResourceGroupTree tree construction");
        this.log.debug((Object)("Constructed tree in " + (end - start)));
    }

    private ResourceGroupTreeNode load(ResourceGroup group, List<ResourceFlyweight> resources, List<Integer> members) {
        HashSet<ResourceTreeNode> memberNodes = new HashSet<ResourceTreeNode>();
        for (Integer member : members) {
            memberNodes.add(ResourceTreeModelUIBean.load((int)member, resources));
        }
        ResourceGroupTreeNode root = new ResourceGroupTreeNode((Object)group, null);
        root.setClusterKey(new ClusterKey(group.getId()));
        root.addMembers(memberNodes);
        this.load(root, memberNodes);
        return root;
    }

    private void load(ResourceGroupTreeNode parentNode, Set<ResourceTreeNode> resources) {
        HashMap<Object, ResourceGroupTreeNode> children = new HashMap<Object, ResourceGroupTreeNode>();
        for (ResourceTreeNode childNode : parentNode.getMembers()) {
            for (ResourceTreeNode node : childNode.getChildren()) {
                Object level = node.getData();
                if (level instanceof AutoGroupCompositeFlyweight) {
                    AutoGroupCompositeFlyweight agc = (AutoGroupCompositeFlyweight)level;
                    Object key = agc.getResourceType() != null ? agc.getResourceType() : agc.getSubcategory();
                    ResourceGroupTreeNode childGroupNode = (ResourceGroupTreeNode)children.get(key);
                    if (childGroupNode == null) {
                        childGroupNode = new ResourceGroupTreeNode(level, parentNode);
                        children.put(key, childGroupNode);
                    }
                    childGroupNode.addMember(node);
                    childGroupNode.setClusterKey(parentNode.getClusterKey());
                    continue;
                }
                if (!(level instanceof ResourceFlyweight)) continue;
                ResourceFlyweight res = (ResourceFlyweight)level;
                ClusterKey parentKey = parentNode.getClusterKey();
                ClusterKey key = null;
                key = parentKey == null ? new ClusterKey(((ResourceGroup)parentNode.getData()).getId(), res.getResourceType().getId(), res.getResourceKey()) : new ClusterKey(parentKey, res.getResourceType().getId(), res.getResourceKey());
                ResourceGroupTreeNode childGroupNode = (ResourceGroupTreeNode)children.get(key);
                if (childGroupNode == null) {
                    childGroupNode = new ResourceGroupTreeNode((Object)key, parentNode);
                    childGroupNode.setClusterKey(key);
                    children.put(key, childGroupNode);
                }
                childGroupNode.addMember(node);
            }
        }
        parentNode.addChildren(children.values());
        for (ResourceGroupTreeNode child : children.values()) {
            HashSet childChildren = new HashSet();
            for (ResourceTreeNode childChild : child.getMembers()) {
                childChildren.addAll(childChild.getChildren());
            }
            if (childChildren.size() <= 0) continue;
            this.load(child, childChildren);
        }
    }

    public List<ResourceGroupTreeNode> getRoots() {
        if (this.rootNode == null) {
            long start = System.currentTimeMillis();
            this.loadTree();
            this.log.debug((Object)("Loaded full tree in " + (System.currentTimeMillis() - start)));
        }
        ArrayList<ResourceGroupTreeNode> roots = new ArrayList<ResourceGroupTreeNode>();
        roots.add(this.rootNode);
        return roots;
    }

    public List<ResourceGroupTreeNode> getChildren() {
        return this.children;
    }

    public String getNodeTitle() {
        return this.nodeTitle;
    }

    public void setNodeTitle(String nodeTitle) {
        this.nodeTitle = nodeTitle;
    }
}

