/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.navigation.resource;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.resource.Agent;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceCategory;
import org.rhq.core.domain.resource.flyweight.AutoGroupCompositeFlyweight;
import org.rhq.core.domain.resource.flyweight.MembersAvailabilityHint;
import org.rhq.core.domain.resource.flyweight.MembersCategoryHint;
import org.rhq.core.domain.resource.flyweight.ResourceFlyweight;
import org.rhq.core.domain.resource.flyweight.ResourceSubCategoryFlyweight;
import org.rhq.core.domain.resource.flyweight.ResourceTypeFlyweight;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.gui.util.FacesContextUtility;
import org.rhq.enterprise.gui.navigation.resource.ResourceTreeModelUIBean;
import org.rhq.enterprise.gui.navigation.resource.ResourceTreeNode;
import org.rhq.enterprise.gui.util.EnterpriseFacesContextUtility;
import org.rhq.enterprise.server.core.AgentManagerLocal;
import org.rhq.enterprise.server.resource.ResourceManagerLocal;
import org.rhq.enterprise.server.util.HibernatePerformanceMonitor;
import org.rhq.enterprise.server.util.LookupUtil;

/*
 * Exception performing whole class analysis ignored.
 */
public class ResourceTreeModelUIBean {
    private static final Log log = LogFactory.getLog(ResourceTreeModelUIBean.class);
    private List<ResourceTreeNode> roots = new ArrayList();
    private ResourceTreeNode rootNode = null;
    private ResourceManagerLocal resourceManager = LookupUtil.getResourceManager();
    private AgentManagerLocal agentManager = LookupUtil.getAgentManager();
    private String nodeTitle;

    private void loadTree() {
        Resource currentResource = EnterpriseFacesContextUtility.getResourceIfExists();
        int searchId = currentResource == null ? Integer.parseInt(FacesContextUtility.getOptionalRequestParameter((String)"parent")) : currentResource.getId();
        Subject user = EnterpriseFacesContextUtility.getSubject();
        long start = System.currentTimeMillis();
        long monitorId = HibernatePerformanceMonitor.get().start();
        Resource rootResource = this.resourceManager.getRootResourceForResource(searchId);
        long end = System.currentTimeMillis();
        HibernatePerformanceMonitor.get().stop(monitorId, "ResourceTree root resource");
        log.debug((Object)("Found root resource in " + (end - start)));
        Agent agent = this.agentManager.getAgentByResourceId(LookupUtil.getSubjectManager().getOverlord(), rootResource.getId());
        start = System.currentTimeMillis();
        monitorId = HibernatePerformanceMonitor.get().start();
        List resources = this.resourceManager.findResourcesByAgent(user, agent.getId(), PageControl.getUnlimitedInstance());
        end = System.currentTimeMillis();
        HibernatePerformanceMonitor.get().stop(monitorId, "ResourceTree agent resource");
        log.debug((Object)("Loaded " + resources.size() + " raw resources in " + (end - start)));
        start = System.currentTimeMillis();
        monitorId = HibernatePerformanceMonitor.get().start();
        this.rootNode = ResourceTreeModelUIBean.load((int)rootResource.getId(), (List)resources);
        end = System.currentTimeMillis();
        HibernatePerformanceMonitor.get().stop(monitorId, "ResourceTree tree construction");
        log.debug((Object)("Constructed tree in " + (end - start)));
    }

    public static ResourceTreeNode load(int rootId, List<ResourceFlyweight> resources) {
        ResourceFlyweight found = null;
        for (ResourceFlyweight res : resources) {
            if (res.getId() != rootId) continue;
            found = res;
        }
        ResourceTreeNode root = new ResourceTreeNode(found);
        long start = System.currentTimeMillis();
        ResourceTreeModelUIBean.load((ResourceTreeNode)root);
        return root;
    }

    public static void load(ResourceTreeNode parentNode) {
        if (parentNode.getData() instanceof ResourceFlyweight) {
            ResourceFlyweight parentResource = (ResourceFlyweight)parentNode.getData();
            HashMap children = new HashMap();
            for (ResourceFlyweight res : parentResource.getChildResources()) {
                if (res.getResourceType().getSubCategory() != null) {
                    ResourceSubCategoryFlyweight categoryKey = res.getResourceType().getSubCategory().getParentSubCategory();
                    if (categoryKey == null) {
                        categoryKey = res.getResourceType().getSubCategory();
                    }
                    ResourceTreeModelUIBean.addToList(children, (Object)categoryKey, (Object)res);
                    continue;
                }
                ResourceTreeModelUIBean.addToList(children, (Object)res.getResourceType(), (Object)res);
            }
            Set dupResourceTypeNames = ResourceTreeModelUIBean.getDuplicateResourceTypeNames(children);
            for (Map.Entry entry : children.entrySet()) {
                Object key = entry.getKey();
                List resources = (List)entry.getValue();
                double avail = 0.0;
                for (ResourceFlyweight res : resources) {
                    avail += res.getCurrentAvailability().getAvailabilityType() == AvailabilityType.UP ? 1.0 : 0.0;
                }
                avail /= (double)resources.size();
                Object nodeData = null;
                if (key instanceof ResourceSubCategoryFlyweight) {
                    nodeData = new AutoGroupCompositeFlyweight(Double.valueOf(avail), parentResource, (ResourceSubCategoryFlyweight)key, (long)resources.size());
                } else if (key instanceof ResourceTypeFlyweight) {
                    ResourceTypeFlyweight typeKey = (ResourceTypeFlyweight)key;
                    if (typeKey.isSingleton()) {
                        nodeData = resources.get(0);
                    } else {
                        boolean isDupResourceTypeName = dupResourceTypeNames.contains(typeKey.getName());
                        nodeData = new AutoGroupCompositeFlyweight(Double.valueOf(avail), parentResource, typeKey, (long)resources.size(), isDupResourceTypeName);
                    }
                }
                ResourceTreeNode node = new ResourceTreeNode(nodeData, parentNode);
                ResourceTreeModelUIBean.load((ResourceTreeNode)node);
                if (ResourceTreeModelUIBean.recursivelyLocked((ResourceTreeNode)node)) continue;
                parentNode.getChildren().add(node);
            }
        } else {
            AutoGroupCompositeFlyweight compositeParent = (AutoGroupCompositeFlyweight)parentNode.getData();
            HashMap children = new HashMap();
            log.debug((Object)("composite parent" + compositeParent));
            if (compositeParent != null) {
                MembersCategoryHint membersCategory = MembersCategoryHint.NONE;
                MembersAvailabilityHint membersAvailabilityHint = MembersAvailabilityHint.UP;
                for (ResourceFlyweight res : compositeParent.getParentResource().getChildResources()) {
                    boolean process = false;
                    if (compositeParent.getSubcategory() != null) {
                        if (res.getResourceType().getSubCategory() != null && compositeParent.getSubcategory().equals((Object)res.getResourceType().getSubCategory().getParentSubCategory()) && compositeParent.getParentResource().equals((Object)res.getParentResource())) {
                            ResourceTreeModelUIBean.addToList(children, (Object)res.getResourceType().getSubCategory(), (Object)res);
                            process = true;
                        } else if (compositeParent.getSubcategory().equals((Object)res.getResourceType().getSubCategory()) && compositeParent.getParentResource().equals((Object)res.getParentResource())) {
                            ResourceTreeModelUIBean.addToList(children, (Object)res.getResourceType(), (Object)res);
                            process = true;
                        }
                    } else if (compositeParent.getResourceType() != null && compositeParent.getResourceType().equals((Object)res.getResourceType()) && compositeParent.getParentResource().getId() == res.getParentResource().getId()) {
                        ResourceTreeModelUIBean.addToList(children, (Object)res.getResourceType(), (Object)res);
                        process = true;
                    }
                    if (!process) continue;
                    switch (1.$SwitchMap$org$rhq$core$domain$resource$flyweight$MembersCategoryHint[membersCategory.ordinal()]) {
                        case 1: {
                            membersCategory = MembersCategoryHint.fromResourceCategory((ResourceCategory)res.getResourceType().getCategory());
                            break;
                        }
                        case 2: {
                            break;
                        }
                        default: {
                            if (MembersCategoryHint.fromResourceCategory((ResourceCategory)res.getResourceType().getCategory()) == membersCategory) break;
                            membersCategory = MembersCategoryHint.MIXED;
                        }
                    }
                    switch (1.$SwitchMap$org$rhq$core$domain$resource$flyweight$MembersAvailabilityHint[membersAvailabilityHint.ordinal()]) {
                        case 1: {
                            membersAvailabilityHint = MembersAvailabilityHint.fromAvailabilityType((AvailabilityType)res.getCurrentAvailability().getAvailabilityType());
                            break;
                        }
                        case 2: {
                            if (res.getCurrentAvailability().getAvailabilityType() != AvailabilityType.DOWN) break;
                            membersAvailabilityHint = MembersAvailabilityHint.DOWN;
                            break;
                        }
                    }
                }
                compositeParent.setMembersCategoryHint(membersCategory);
                compositeParent.setMembersAvailabilityHint(membersAvailabilityHint);
            }
            AutoGroupCompositeFlyweight compositeParentNode = (AutoGroupCompositeFlyweight)parentNode.getData();
            for (Map.Entry entry : children.entrySet()) {
                Object key = entry.getKey();
                List resources = (List)entry.getValue();
                if (compositeParentNode.getSubcategory() != null) {
                    double avail = 0.0;
                    for (ResourceFlyweight res : resources) {
                        avail += res.getCurrentAvailability().getAvailabilityType() == AvailabilityType.UP ? 1.0 : 0.0;
                    }
                    avail /= (double)resources.size();
                    Object nodeData = null;
                    if (key instanceof ResourceSubCategoryFlyweight) {
                        nodeData = new AutoGroupCompositeFlyweight(Double.valueOf(avail), compositeParent.getParentResource(), (ResourceSubCategoryFlyweight)key, (long)resources.size());
                    } else if (key instanceof ResourceTypeFlyweight) {
                        ResourceTypeFlyweight typeKey = (ResourceTypeFlyweight)key;
                        nodeData = typeKey.isSingleton() ? resources.get(0) : new AutoGroupCompositeFlyweight(Double.valueOf(avail), compositeParent.getParentResource(), typeKey, (long)resources.size(), false);
                    }
                    ResourceTreeNode node = new ResourceTreeNode(nodeData, parentNode);
                    ResourceTreeModelUIBean.load((ResourceTreeNode)node);
                    if (ResourceTreeModelUIBean.recursivelyLocked((ResourceTreeNode)node)) continue;
                    parentNode.getChildren().add(node);
                    continue;
                }
                for (ResourceFlyweight res : resources) {
                    ResourceTreeNode node = new ResourceTreeNode((Object)res, parentNode);
                    ResourceTreeModelUIBean.load((ResourceTreeNode)node);
                    if (ResourceTreeModelUIBean.recursivelyLocked((ResourceTreeNode)node)) continue;
                    parentNode.getChildren().add(node);
                }
            }
        }
    }

    public static boolean recursivelyLocked(ResourceTreeNode node) {
        if (node.getData() instanceof ResourceFlyweight && !((ResourceFlyweight)node.getData()).isLocked()) {
            return false;
        }
        boolean allLocked = true;
        for (ResourceTreeNode child : node.getChildren()) {
            if (ResourceTreeModelUIBean.recursivelyLocked((ResourceTreeNode)child)) continue;
            allLocked = false;
        }
        return allLocked;
    }

    public ResourceTreeNode getTreeNode() {
        if (this.rootNode == null) {
            long start = System.currentTimeMillis();
            this.loadTree();
            log.debug((Object)("Loaded full tree in " + (System.currentTimeMillis() - start)));
        }
        return this.rootNode;
    }

    public List<ResourceTreeNode> getRoots() {
        if (this.roots.isEmpty()) {
            this.roots.add(this.getTreeNode());
        }
        return this.roots;
    }

    public String getNodeTitle() {
        return this.nodeTitle;
    }

    public void setNodeTitle(String nodeTitle) {
        this.nodeTitle = nodeTitle;
    }

    private static Set<String> getDuplicateResourceTypeNames(Map<Object, List<ResourceFlyweight>> children) {
        HashSet<String> resourceTypeNames = new HashSet<String>();
        HashSet<String> dupResourceTypeNames = new HashSet<String>();
        for (Object rsc : children.keySet()) {
            if (!(rsc instanceof ResourceTypeFlyweight)) continue;
            String resourceTypeName = ((ResourceTypeFlyweight)rsc).getName();
            if (resourceTypeNames.contains(resourceTypeName)) {
                dupResourceTypeNames.add(resourceTypeName);
            }
            resourceTypeNames.add(resourceTypeName);
        }
        return dupResourceTypeNames;
    }

    private static <K, V> void addToList(Map<K, List<V>> mapOfLists, K key, V value) {
        List<V> list = mapOfLists.get(key);
        if (list == null) {
            list = new ArrayList<V>();
            mapOfLists.put(key, list);
        }
        list.add(value);
    }
}

