/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.admin.user;

import javax.servlet.http.HttpServletRequest;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.rhq.enterprise.gui.legacy.action.BaseValidatorForm;

public class EditForm
extends BaseValidatorForm {
    private Integer id;
    private String lastName;
    private String firstName;
    private String department;
    private String name;
    private String emailAddress;
    private String smsAddress;
    private String phoneNumber;
    private String enableLogin;
    private String pageRefreshPeriod;
    private String groupConfigurationTimeout;
    private boolean editingCurrentUser;

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getDepartment() {
        return this.department;
    }

    public void setDepartment(String department) {
        this.department = department;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getEmailAddress() {
        return this.emailAddress;
    }

    public void setEmailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
    }

    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    public String getEnableLogin() {
        return this.enableLogin;
    }

    public void setEnableLogin(String enableLogin) {
        this.enableLogin = enableLogin;
    }

    public String getSmsAddress() {
        return this.smsAddress;
    }

    public void setSmsAddress(String add) {
        this.smsAddress = add;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append("id=" + this.id + " ");
        s.append("name=" + this.name + " firstName=" + this.firstName + " ");
        s.append("lastName=" + this.lastName + " emailAddress=" + this.emailAddress + " ");
        s.append("phoneNumber=" + this.phoneNumber + " ");
        s.append("department=" + this.department + " ");
        s.append("enableLogin=" + this.enableLogin + " ");
        s.append("smsAddress=" + this.smsAddress + " ");
        s.append("pageRefreshPeriod=" + this.pageRefreshPeriod + " ");
        s.append("groupConfigurationTimeout=" + this.groupConfigurationTimeout + " ");
        return s.toString();
    }

    public String getPageRefreshPeriod() {
        return this.pageRefreshPeriod;
    }

    public void setPageRefreshPeriod(String pageRefreshPeriod) {
        this.pageRefreshPeriod = pageRefreshPeriod;
    }

    public String getGroupConfigurationTimeout() {
        return this.groupConfigurationTimeout;
    }

    public void setGroupConfigurationTimeout(String groupConfigurationTimeout) {
        this.groupConfigurationTimeout = groupConfigurationTimeout;
    }

    public boolean isEditingCurrentUser() {
        return this.editingCurrentUser;
    }

    public void setEditingCurrentUser(boolean editingCurrentUser) {
        this.editingCurrentUser = editingCurrentUser;
    }

    public ActionErrors validate(ActionMapping mapping, HttpServletRequest request) {
        ActionErrors errors = super.validate(mapping, request);
        if (this.shouldValidateMyPreferences(mapping, request)) {
            int refreshPeriod = -1;
            ActionMessage errorMessage = null;
            try {
                refreshPeriod = Integer.valueOf(this.getPageRefreshPeriod());
                if (refreshPeriod < 0 || refreshPeriod > 86400) {
                    errorMessage = new ActionMessage("admin.user.error.mypreferences.pageRefreshPeriod.range");
                }
            }
            catch (NumberFormatException e) {
                errorMessage = new ActionMessage("admin.user.error.mypreferences.pageRefreshPeriod");
            }
            if (errorMessage != null) {
                if (errors == null) {
                    errors = new ActionErrors();
                }
                errors.add("pageRefreshPeriod", errorMessage);
            }
            int groupConfigTimeout = -1;
            errorMessage = null;
            try {
                groupConfigTimeout = Integer.valueOf(this.getGroupConfigurationTimeout());
                if (groupConfigTimeout < 30 || groupConfigTimeout > 300) {
                    errorMessage = new ActionMessage("admin.user.error.mypreferences.groupConfigurationTimeout.range");
                }
            }
            catch (NumberFormatException e) {
                errorMessage = new ActionMessage("admin.user.error.mypreferences.groupConfigurationTimeout");
            }
            if (errorMessage != null) {
                if (errors == null) {
                    errors = new ActionErrors();
                }
                errors.add("groupConfigurationTimeout", errorMessage);
            }
        }
        return errors;
    }

    private boolean shouldValidateMyPreferences(ActionMapping mapping, HttpServletRequest request) {
        return this.isEditingCurrentUser() && super.shouldValidate(mapping, request);
    }

    public void reset(ActionMapping mapping, HttpServletRequest request) {
        super.reset(mapping, request);
    }
}

