/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.content;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.faces.model.DataModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.clientapi.util.units.UnitNumber;
import org.rhq.core.clientapi.util.units.UnitsConstants;
import org.rhq.core.clientapi.util.units.UnitsFormat;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.domain.content.InstalledPackage;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageList;
import org.rhq.core.gui.util.FacesContextUtility;
import org.rhq.enterprise.gui.common.framework.PagedDataTableUIBean;
import org.rhq.enterprise.gui.common.paging.PageControlView;
import org.rhq.enterprise.gui.content.ListPackageHistoryUIBean;
import org.rhq.enterprise.server.content.ContentUIManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

public class ListPackageHistoryUIBean
extends PagedDataTableUIBean {
    private final Log log = LogFactory.getLog(this.getClass());
    private InstalledPackage currentPackage;

    public InstalledPackage getCurrentPackage() {
        if (this.currentPackage == null) {
            this.loadCurrentPackage();
        }
        return this.currentPackage;
    }

    public List<PackageTableDataValue> getPackageValues() {
        this.loadCurrentPackage();
        this.currentPackage = this.getCurrentPackage();
        if (this.currentPackage == null) {
            return null;
        }
        String oldPackageIdString = FacesContextUtility.getRequest().getParameter("oldPackageId");
        return this.toCombinedValues(this.currentPackage, null);
    }

    private List<PackageTableDataValue> toCombinedValues(InstalledPackage current, InstalledPackage old) {
        long fileSizeBytes;
        PageList results = new ArrayList();
        results.add(new PackageTableDataValue(this, "Name", current.getPackageVersion().getGeneralPackage().getName(), null));
        results.add(new PackageTableDataValue(this, "Version", current.getPackageVersion().getDisplayVersion(), old != null ? old.getPackageVersion().getDisplayVersion() : null));
        results.add(new PackageTableDataValue(this, "Architecture", current.getPackageVersion().getArchitecture().getName(), old != null ? old.getPackageVersion().getArchitecture().getName() : null));
        results.add(new PackageTableDataValue(this, "File Name", current.getPackageVersion().getFileSize() != null ? current.getPackageVersion().getFileName() : null, old != null ? (old.getPackageVersion().getFileSize() != null ? old.getPackageVersion().getFileName() : null) : null));
        long l = fileSizeBytes = current.getPackageVersion().getFileSize() != null ? current.getPackageVersion().getFileSize() : 0L;
        long oldFileSizeBytes = old != null ? (old.getPackageVersion().getFileSize() != null ? old.getPackageVersion().getFileSize() : 0L) : 0L;
        results.add(new PackageTableDataValue(this, "File Size", UnitsFormat.format((UnitNumber)new UnitNumber((double)fileSizeBytes, UnitsConstants.UNIT_BYTES)).toString(), UnitsFormat.format((UnitNumber)new UnitNumber((double)oldFileSizeBytes, UnitsConstants.UNIT_BYTES)).toString()));
        results.add(new PackageTableDataValue(this, "SHA256", current.getPackageVersion().getSHA256(), old != null ? old.getPackageVersion().getSHA256() : null));
        results.add(new PackageTableDataValue(this, "Installation Date", this.dateToString(current.getInstallationDate()), this.dateToString(old != null ? old.getInstallationDate() : null)));
        ConfigurationDefinition definition = current.getPackageVersion().getGeneralPackage().getPackageType().getDeploymentConfigurationDefinition();
        if (definition == null) {
            return results;
        }
        results = new PageList(results, results.size(), PageControl.getUnlimitedInstance());
        return results;
    }

    public DataModel getDataModel() {
        if (this.dataModel == null) {
            this.dataModel = new ListAllPackageVersionsDataModel(this, PageControlView.AllPackageVersionsList, "ListPackageHistoryUIBean");
        }
        return this.dataModel;
    }

    public void loadCurrentPackage() {
        if (this.currentPackage != null) {
            return;
        }
        int currentPackageId = Integer.parseInt(FacesContextUtility.getRequest().getParameter("currentPackageId"));
        ContentUIManagerLocal contentUIManager = LookupUtil.getContentUIManager();
        this.currentPackage = contentUIManager.getInstalledPackage(currentPackageId);
    }

    private String dateToString(Long date) {
        if (date == null) {
            return "";
        }
        return new Date(date).toString();
    }
}

