/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.legacy.action.resource.common.monitor.visibility;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.measurement.DataType;
import org.rhq.core.domain.measurement.MeasurementSchedule;
import org.rhq.core.domain.measurement.ui.MetricDisplaySummary;
import org.rhq.enterprise.gui.legacy.action.resource.common.monitor.visibility.MetricsDisplayFormPrepareAction;
import org.rhq.enterprise.gui.util.WebUtility;
import org.rhq.enterprise.server.measurement.MeasurementChartsManagerLocal;
import org.rhq.enterprise.server.measurement.MeasurementScheduleManagerLocal;
import org.rhq.enterprise.server.resource.group.ResourceGroupManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

public class ResourceMetricsFormPrepareAction
extends MetricsDisplayFormPrepareAction {
    protected static Log log = LogFactory.getLog(ResourceMetricsFormPrepareAction.class);

    protected Boolean getShowBaseline() {
        return Boolean.FALSE;
    }

    protected List<MetricDisplaySummary> getMetrics(HttpServletRequest request, int[] resourceIds, long filters, String keyword, Long begin, Long end) throws Exception {
        int[] definitionIds;
        Subject subject = WebUtility.getSubject((HttpServletRequest)request);
        int parent = WebUtility.getOptionalIntRequestParameter((ServletRequest)request, (String)"parent", (int)-1);
        int type = WebUtility.getOptionalIntRequestParameter((ServletRequest)request, (String)"type", (int)-1);
        int myGroupId = WebUtility.getOptionalIntRequestParameter((ServletRequest)request, (String)"groupId", (int)-1);
        MeasurementScheduleManagerLocal scheduleManager = LookupUtil.getMeasurementScheduleManager();
        MeasurementChartsManagerLocal chartsManager = LookupUtil.getMeasurementChartsManager();
        if (log.isTraceEnabled()) {
            log.trace((Object)("finding metric summaries for resource [" + Arrays.toString(resourceIds) + "] for range " + begin + ":" + end + " filters value: " + filters + " and keyword: " + keyword));
        }
        List metricSummaries = null;
        if (myGroupId > 0) {
            ResourceGroupManagerLocal resGrpMgr = LookupUtil.getResourceGroupManager();
            definitionIds = resGrpMgr.findDefinitionsForCompatibleGroup(subject, myGroupId, false);
            metricSummaries = chartsManager.getMetricDisplaySummariesForCompatibleGroup(subject, myGroupId, definitionIds, begin.longValue(), end.longValue(), false);
        } else if (parent > 0 && type > 0) {
            ResourceGroupManagerLocal resGrpMgr = LookupUtil.getResourceGroupManager();
            definitionIds = resGrpMgr.findDefinitionsForAutoGroup(subject, parent, type, false);
            metricSummaries = chartsManager.getMetricDisplaySummariesForAutoGroup(subject, parent, type, definitionIds, begin.longValue(), end.longValue(), false);
        } else if (resourceIds != null && resourceIds.length > 0) {
            int resourceId = resourceIds[0];
            List scheds = scheduleManager.findSchedulesForResourceAndType(subject, resourceId, null, null, false);
            int metricOrTraitCount = 0;
            for (MeasurementSchedule sched : scheds) {
                if (sched.getDefinition().getDataType() != DataType.MEASUREMENT && sched.getDefinition().getDataType() != DataType.TRAIT) continue;
                ++metricOrTraitCount;
            }
            int[] scheduleIds = new int[metricOrTraitCount];
            int index = 0;
            for (MeasurementSchedule sched : scheds) {
                if (sched.getDefinition().getDataType() != DataType.MEASUREMENT && sched.getDefinition().getDataType() != DataType.TRAIT) continue;
                scheduleIds[index++] = sched.getId();
            }
            metricSummaries = chartsManager.getMetricDisplaySummariesForResource(subject, resourceId, scheduleIds, begin.longValue(), end.longValue());
        } else {
            throw new IllegalArgumentException("Unknown operation mode");
        }
        boolean dataPresent = false;
        for (MetricDisplaySummary sum : metricSummaries) {
            if (!sum.getValuesPresent()) continue;
            dataPresent = true;
            break;
        }
        if (!dataPresent) {
            metricSummaries = new ArrayList();
        }
        return metricSummaries;
    }
}

