/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.legacy.taglib.display;

import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.domain.resource.composite.ResourceFacets;
import org.rhq.core.domain.resource.group.GroupCategory;
import org.rhq.core.domain.resource.group.composite.ResourceGroupComposite;
import org.rhq.core.gui.util.UrlUtility;
import org.rhq.enterprise.gui.legacy.taglib.display.QuicknavDecorator;
import org.rhq.enterprise.server.resource.ResourceFacetsCache;

public class GroupQuicknavDecorator
extends QuicknavDecorator {
    private static final String MONITOR_URL = "/rhq/group/monitor/graphs.xhtml";
    private static final String EVENTS_URL = "/rhq/group/events/history.xhtml";
    private static final String INVENTORY_URL = "/rhq/group/inventory/view.xhtml";
    private static final String CONFIGURE_URL = "/rhq/group/configuration/viewCurrent.xhtml";
    private static final String OPERATIONS_URL = "/rhq/group/operation/groupOperationScheduleNew.xhtml";
    private static final String ALERT_URL = "/rhq/group/alert/listGroupAlertDefinitions.xhtml";
    private static final String CONTENT_URL = "/rhq/group/content/view.xhtml?mode=view";
    private ResourceGroupComposite resourceGroupComposite;
    private ResourceFacets resourceFacets;

    public String decorate(Object columnValue) throws Exception {
        this.resourceGroupComposite = (ResourceGroupComposite)columnValue;
        ResourceType type = this.resourceGroupComposite.getResourceGroup().getResourceType();
        this.resourceFacets = type == null ? ResourceFacets.NONE : ResourceFacetsCache.getSingleton().getResourceFacets(type.getId());
        return this.getOutput();
    }

    protected String getFullURL(String url) {
        HttpServletRequest request = (HttpServletRequest)this.getPageContext().getRequest();
        HashMap<String, String> params = new HashMap<String, String>();
        if (url.equals(MONITOR_URL) || url.equals(EVENTS_URL) || url.equals(INVENTORY_URL) || url.equals(OPERATIONS_URL)) {
            params.put("category", this.resourceGroupComposite.getCategory().name());
        }
        params.put("groupId", String.valueOf(this.resourceGroupComposite.getResourceGroup().getId()));
        String fullURL = request.getContextPath() + UrlUtility.addParametersToQueryString((String)url, params);
        return fullURL;
    }

    protected String getTagName() {
        return "group-quicknav-decorator";
    }

    protected boolean isMonitorSupported() {
        return this.isCompatibleGroup();
    }

    protected boolean isEventsSupported() {
        return this.isCompatibleGroup() && this.resourceFacets.isEvent();
    }

    protected boolean isInventorySupported() {
        return true;
    }

    protected boolean isConfigureSupported() {
        return this.isCompatibleGroup() && this.resourceFacets.isConfiguration();
    }

    protected boolean isOperationsSupported() {
        return this.isCompatibleGroup() && this.resourceFacets.isOperation();
    }

    protected boolean isAlertSupported() {
        return this.isCompatibleGroup();
    }

    protected boolean isContentSupported() {
        return false;
    }

    private boolean isCompatibleGroup() {
        return this.resourceGroupComposite.getResourceGroup().getGroupCategory() == GroupCategory.COMPATIBLE;
    }

    protected boolean isMonitorAllowed() {
        return true;
    }

    protected boolean isEventsAllowed() {
        return true;
    }

    protected boolean isInventoryAllowed() {
        return true;
    }

    protected boolean isConfigureAllowed() {
        return true;
    }

    protected boolean isOperationsAllowed() {
        return true;
    }

    protected boolean isAlertAllowed() {
        return true;
    }

    protected boolean isContentAllowed() {
        return false;
    }

    protected String getMonitorURL() {
        return MONITOR_URL;
    }

    protected String getEventsURL() {
        return EVENTS_URL;
    }

    protected String getInventoryURL() {
        return INVENTORY_URL;
    }

    protected String getConfigureURL() {
        return CONFIGURE_URL;
    }

    protected String getOperationsURL() {
        return OPERATIONS_URL;
    }

    protected String getAlertURL() {
        return ALERT_URL;
    }

    protected String getContentURL() {
        return CONTENT_URL;
    }
}

