/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.operation.history.resource;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.faces.application.FacesMessage;
import javax.faces.model.DataModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.operation.ResourceOperationHistory;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.gui.util.FacesContextUtility;
import org.rhq.core.gui.util.StringUtility;
import org.rhq.core.util.exception.ThrowableUtil;
import org.rhq.enterprise.gui.common.framework.PagedDataTableUIBean;
import org.rhq.enterprise.gui.common.paging.PageControlView;
import org.rhq.enterprise.gui.operation.history.resource.ResourceOperationCompletedHistoryUIBean;
import org.rhq.enterprise.gui.util.EnterpriseFacesContextUtility;
import org.rhq.enterprise.server.operation.OperationManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

public class ResourceOperationCompletedHistoryUIBean
extends PagedDataTableUIBean {
    private final Log log = LogFactory.getLog(ResourceOperationCompletedHistoryUIBean.class);
    public static final String MANAGED_BEAN_NAME = "ResourceOperationCompletedHistoryUIBean";
    private OperationManagerLocal manager = LookupUtil.getOperationManager();
    private ResourceOperationHistory latestCompletedResourceOperation = null;

    public ResourceOperationHistory getLatestCompletedResourceOperation() {
        if (this.latestCompletedResourceOperation == null) {
            Subject subject = EnterpriseFacesContextUtility.getSubject();
            Resource resource = EnterpriseFacesContextUtility.getResource();
            OperationManagerLocal manager = LookupUtil.getOperationManager();
            this.latestCompletedResourceOperation = manager.getLatestCompletedResourceOperation(subject, resource.getId());
        }
        return this.latestCompletedResourceOperation;
    }

    public DataModel getDataModel() {
        if (this.dataModel == null) {
            this.dataModel = new A(this, PageControlView.ResourceOperationCompletedHistory, MANAGED_BEAN_NAME);
        }
        return this.dataModel;
    }

    public String delete() {
        Subject subject = EnterpriseFacesContextUtility.getSubject();
        String[] selectedItems = FacesContextUtility.getRequest().getParameterValues("completedSelectedItems");
        ArrayList<String> success = new ArrayList<String>();
        HashMap<String, String> failure = new HashMap<String, String>();
        String next = null;
        long start = System.currentTimeMillis();
        for (int i = 0; i < selectedItems.length; ++i) {
            try {
                next = selectedItems[i];
                Integer doomed = Integer.valueOf(next);
                this.manager.deleteOperationHistory(subject, doomed.intValue(), true);
                success.add(next);
                continue;
            }
            catch (Exception e) {
                failure.put(next, ThrowableUtil.getAllMessages((Throwable)e, (boolean)true));
            }
        }
        long end = System.currentTimeMillis();
        this.log.debug((Object)("Performance: took [" + (end - start) + "]ms to delete " + selectedItems.length + " Resource OperationHistory elements"));
        if (success.size() > 0) {
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_INFO, (String)("Deleted resource operation records: " + StringUtility.getListAsDelimitedString(success)));
        }
        for (Map.Entry error : failure.entrySet()) {
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)("Failed to delete resource operation record " + (String)error.getKey() + ". Cause: " + (String)error.getValue()));
        }
        return "success";
    }
}

