/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.operation.schedule;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.application.FacesMessage;
import javax.faces.model.DataModel;
import org.quartz.SimpleTrigger;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.operation.bean.OperationSchedule;
import org.rhq.core.domain.operation.bean.ResourceOperationSchedule;
import org.rhq.core.gui.util.FacesContextUtility;
import org.rhq.core.gui.util.StringUtility;
import org.rhq.core.util.exception.ThrowableUtil;
import org.rhq.enterprise.gui.common.framework.PagedDataTableUIBean;
import org.rhq.enterprise.gui.common.paging.PageControlView;
import org.rhq.enterprise.gui.common.scheduling.OperationDetailsScheduleComponent;
import org.rhq.enterprise.gui.operation.definition.OperationDefinitionParametersUIBean;
import org.rhq.enterprise.gui.operation.definition.OperationDefinitionUIBean;
import org.rhq.enterprise.gui.operation.definition.group.ResourceGroupOperationDefinitionUIBean;
import org.rhq.enterprise.gui.operation.definition.resource.ResourceOperationDefinitionUIBean;
import org.rhq.enterprise.gui.operation.schedule.OperationScheduleUIBean;
import org.rhq.enterprise.gui.operation.schedule.group.ResourceGroupOperationScheduleUIBean;
import org.rhq.enterprise.gui.operation.schedule.resource.ResourceOperationScheduleUIBean;
import org.rhq.enterprise.gui.util.EnterpriseFacesContextUtility;
import org.rhq.enterprise.server.operation.OperationManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

public abstract class OperationScheduleUIBean
extends PagedDataTableUIBean {
    private OperationSchedule selectedOperationSchedule;
    protected OperationManagerLocal manager = LookupUtil.getOperationManager();
    private OperationDetailsScheduleComponent operationDetails;

    public OperationSchedule getSelectedOperationSchedule() {
        return this.selectedOperationSchedule;
    }

    public void setSelectedOperationSchedule(OperationSchedule selectedOperationSchedule) {
        this.selectedOperationSchedule = selectedOperationSchedule;
    }

    public String selectScheduleToView() {
        ResourceOperationSchedule operationSchedule = (ResourceOperationSchedule)FacesContextUtility.getRequest().getAttribute("item");
        this.setSelectedOperationSchedule((OperationSchedule)operationSchedule);
        return "success";
    }

    public OperationDetailsScheduleComponent getOperationDetails() {
        if (this.operationDetails == null) {
            this.operationDetails = new OperationDetailsScheduleComponent();
        }
        return this.operationDetails;
    }

    public void setOperationDetails(OperationDetailsScheduleComponent operationDetails) {
        this.operationDetails = operationDetails;
    }

    public String schedule() {
        try {
            OperationDefinitionUIBean operationDefUIBean;
            Subject subject = EnterpriseFacesContextUtility.getSubject();
            SimpleTrigger simpleTrigger = this.getTrigger();
            long startTime = simpleTrigger.getStartTime().getTime();
            long now = System.currentTimeMillis();
            if (now - startTime > 60000L) {
                throw new IllegalArgumentException("Can not schedule operations in the past");
            }
            OperationDefinitionParametersUIBean operationParametersUIBean = (OperationDefinitionParametersUIBean)FacesContextUtility.getBean(OperationDefinitionParametersUIBean.class);
            Configuration configuration = operationParametersUIBean.getConfiguration();
            if (this instanceof ResourceOperationScheduleUIBean) {
                operationDefUIBean = (OperationDefinitionUIBean)FacesContextUtility.getBean(ResourceOperationDefinitionUIBean.class);
            } else if (this instanceof ResourceGroupOperationScheduleUIBean) {
                operationDefUIBean = (OperationDefinitionUIBean)FacesContextUtility.getBean(ResourceGroupOperationDefinitionUIBean.class);
            } else {
                throw new IllegalStateException("Unsupported class - this is a bug, please report it: " + this.getClass().toString());
            }
            String timeout = operationDefUIBean.getTimeout();
            if (!timeout.trim().equals("")) {
                Integer.parseInt(timeout);
                if (configuration == null) {
                    configuration = new Configuration();
                }
                configuration.put((Property)new PropertySimple("rhq.timeout", (Object)timeout));
            }
            String operationName = operationDefUIBean.getName();
            String description = operationDefUIBean.getDescription();
            this.scheduleOperation(subject, operationName, configuration, simpleTrigger, description);
        }
        catch (Exception e) {
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)("There was an error scheduling your operation: " + e.getMessage()));
            return "validationError";
        }
        if (this.getOperationDetails().getDeferred()) {
            return "viewOperationSchedules";
        }
        try {
            Thread.sleep(1500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return "viewOperationHistory";
    }

    public String unschedule() {
        Subject subject = EnterpriseFacesContextUtility.getSubject();
        String[] selectedItems = FacesContextUtility.getRequest().getParameterValues("selectedItems");
        ArrayList<String> success = new ArrayList<String>();
        HashMap<String, String> failure = new HashMap<String, String>();
        for (String doomedJobId : selectedItems) {
            try {
                this.unscheduleOperation(subject, doomedJobId);
                success.add(doomedJobId);
            }
            catch (Exception e) {
                failure.put(doomedJobId, ThrowableUtil.getAllMessages((Throwable)e, (boolean)true));
            }
        }
        if (success.size() > 0) {
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_INFO, (String)("Removed operation schedules: " + StringUtility.getListAsDelimitedString(success)));
        }
        for (Map.Entry error : failure.entrySet()) {
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)("Failed to remove operation schedules: " + (String)error.getKey() + ". Cause: " + (String)error.getValue()));
        }
        return "success";
    }

    public abstract void scheduleOperation(Subject var1, String var2, Configuration var3, SimpleTrigger var4, String var5) throws Exception;

    public abstract void unscheduleOperation(Subject var1, String var2) throws Exception;

    public DataModel getDataModel() {
        if (this.dataModel == null) {
            this.dataModel = new ListOperationScheduleDataModel(this, PageControlView.NONE, this.getManagedBeanName());
        }
        return this.dataModel;
    }

    public abstract String getManagedBeanName();

    public abstract List<? extends OperationSchedule> getOperationScheduleList();

    public SimpleTrigger getTrigger() {
        OperationDetailsScheduleComponent component = this.getOperationDetails();
        SimpleTrigger trigger = new SimpleTrigger();
        Date now = Calendar.getInstance().getTime();
        if (component.getStart().equals("immediate")) {
            trigger.setStartTime(now);
        } else {
            component.setDeferred(true);
            if (component.getStartDate() == null) {
                throw new IllegalArgumentException("Please select a start date");
            }
            if (now.after(component.getStartDate())) {
                throw new IllegalArgumentException("Scheduling cannot occur in the past");
            }
            trigger.setStartTime(component.getStartDate());
            if (!component.getRecur().equals("never")) {
                trigger.setRepeatCount(-1);
                component.setRepeat(true);
                long repeatInterval = component.getUnit().getMillis() * (long)component.getRepeatInterval();
                trigger.setRepeatInterval(repeatInterval);
                if (component.getEnd().equals("endDate")) {
                    if (component.getEndDate() == null) {
                        throw new IllegalArgumentException("Please select an end date");
                    }
                    component.setTerminate(true);
                    if (component.getEndDate().before(component.getStartDate())) {
                        throw new IllegalArgumentException("Scheduling cannot occur before the start date");
                    }
                    trigger.setEndTime(component.getEndDate());
                }
            }
        }
        return trigger;
    }
}

