/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.operation.schedule.resource;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.quartz.JobDetail;
import org.quartz.SchedulerException;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.operation.bean.ResourceOperationSchedule;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.gui.util.FacesContextUtility;
import org.rhq.enterprise.gui.operation.schedule.OperationScheduleUIBean;
import org.rhq.enterprise.gui.util.EnterpriseFacesContextUtility;
import org.rhq.enterprise.server.scheduler.SchedulerLocal;
import org.rhq.enterprise.server.util.LookupUtil;
import org.rhq.enterprise.server.util.QuartzUtil;

public class ResourceOperationScheduleUIBean
extends OperationScheduleUIBean {
    private Resource resource;

    public String getManagedBeanName() {
        return "ResourceOperationScheduleUIBean";
    }

    public List<ResourceOperationSchedule> getOperationScheduleList() {
        Subject subject = EnterpriseFacesContextUtility.getSubject();
        Resource requestResource = EnterpriseFacesContextUtility.getResourceIfExists();
        if (requestResource == null) {
            requestResource = this.resource;
        } else {
            this.resource = requestResource;
        }
        List results = null;
        try {
            results = this.manager.findScheduledResourceOperations(subject, requestResource.getId());
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
        return results;
    }

    public void unscheduleOperation(Subject subject, String doomedJobId) throws Exception {
        if (this.resource == null) {
            this.resource = EnterpriseFacesContextUtility.getResource();
            if (this.resource == null) {
                throw new IllegalStateException("Could not find resource from which to delete operation schedules");
            }
        }
        this.manager.unscheduleResourceOperation(subject, doomedJobId, this.resource.getId());
    }

    public void scheduleOperation(Subject subject, String operationName, Configuration parameters, SimpleTrigger simpleTrigger, String description) throws Exception {
        if (this.resource == null) {
            this.resource = EnterpriseFacesContextUtility.getResource();
            if (this.resource == null) {
                throw new IllegalStateException("Could not find resource against which to schedule operations");
            }
        }
        this.manager.scheduleResourceOperation(subject, this.resource.getId(), operationName, parameters, (Trigger)simpleTrigger, description);
    }

    public String executeNow() throws Exception {
        Subject subject = EnterpriseFacesContextUtility.getSubject();
        HttpServletRequest request = FacesContextUtility.getRequest();
        String[] selectedItems = request.getParameterValues("selectedItems");
        if (selectedItems == null || selectedItems.length == 0) {
            selectedItems = request.getParameterValues("jobId");
        }
        if (selectedItems == null || selectedItems.length == 0) {
            throw new IllegalStateException("No job selected to execute");
        }
        SchedulerLocal scheduler = LookupUtil.getSchedulerBean();
        for (String jobIdString : selectedItems) {
            ResourceOperationSchedule resourceSchedule;
            try {
                resourceSchedule = this.manager.getResourceOperationSchedule(subject, jobIdString);
            }
            catch (SchedulerException se) {
                throw new IllegalStateException(se.getMessage(), se);
            }
            JobDetail jobDetail = scheduler.getJobDetail(resourceSchedule.getJobName(), resourceSchedule.getJobGroup());
            this.scheduleOperation(subject, resourceSchedule.getOperationName(), resourceSchedule.getParameters(), (SimpleTrigger)QuartzUtil.getFireOnceImmediateTrigger((JobDetail)jobDetail), resourceSchedule.getDescription());
        }
        return "viewOperationHistory";
    }
}

