/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.common.paging;

import java.util.Collection;
import java.util.List;
import org.rhq.core.domain.resource.composite.DisambiguationReport;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageList;
import org.rhq.core.util.IntExtractor;
import org.rhq.enterprise.gui.common.paging.PageControlView;
import org.rhq.enterprise.gui.common.paging.PagedListDataModel;
import org.rhq.enterprise.server.resource.ResourceManagerLocal;
import org.rhq.enterprise.server.resource.disambiguation.DefaultDisambiguationUpdateStrategies;
import org.rhq.enterprise.server.resource.disambiguation.DisambiguationUpdateStrategy;
import org.rhq.enterprise.server.util.LookupUtil;

public abstract class ResourceNameDisambiguatingPagedListDataModel<T>
extends PagedListDataModel<DisambiguationReport<T>> {
    private boolean alwaysIncludeParents;
    private ResourceManagerLocal resourceManager = LookupUtil.getResourceManager();

    public ResourceNameDisambiguatingPagedListDataModel(PageControlView view, String beanName, boolean alwaysIncludeParents) {
        super(view, beanName);
        this.alwaysIncludeParents = alwaysIncludeParents;
    }

    public PageList<DisambiguationReport<T>> fetchPage(PageControl pc) {
        PageList data = this.fetchDataForPage(pc);
        List disambiguation = this.resourceManager.disambiguate((List)data, this.getResourceIdExtractor(), (DisambiguationUpdateStrategy)DefaultDisambiguationUpdateStrategies.getDefault());
        return new PageList((Collection)disambiguation, data.getTotalSize(), data.getPageControl());
    }

    protected abstract PageList<T> fetchDataForPage(PageControl var1);

    protected abstract IntExtractor<T> getResourceIdExtractor();
}

