/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.common.tabbar;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBase;
import javax.faces.context.FacesContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rhq.core.gui.util.FacesComponentUtility;
import org.rhq.enterprise.gui.common.tabbar.SubtabComponent;
import org.rhq.enterprise.gui.common.tabbar.TabComponent;

public class TabBarComponent
extends UIComponentBase {
    public static final String COMPONENT_TYPE = "org.jboss.on.TabBar";
    public static final String COMPONENT_FAMILY = "org.jboss.on.TabBar";
    private String selectedTabName;
    private Map<String, String> parameters = new HashMap();
    private Object[] stateValues;

    public String getFamily() {
        return "org.jboss.on.TabBar";
    }

    public String getSelectedTabName() {
        if (this.selectedTabName == null) {
            this.selectedTabName = FacesComponentUtility.getExpressionAttribute((UIComponent)this, (String)"selectedTabName");
        }
        return this.selectedTabName;
    }

    public void setSelectedTabName(String selectedTabName) {
        this.selectedTabName = selectedTabName;
    }

    @NotNull
    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public void setParameters(@NotNull Map<String, String> parameters) {
        this.parameters = parameters;
    }

    public void selectTab(@NotNull String fullTabName) {
        String tabName;
        String subtabName = null;
        if (fullTabName.contains(".")) {
            int dotIndex = fullTabName.indexOf(46);
            tabName = fullTabName.substring(0, dotIndex);
            subtabName = fullTabName.substring(dotIndex + 1);
        } else {
            tabName = fullTabName;
        }
        TabComponent selectedTab = this.getTabByName(tabName);
        if (selectedTab == null) {
            throw new IllegalStateException("'" + tabName + "' is not a valid tab name for this tab bar.");
        }
        selectedTab.setSelected(true);
        if (subtabName != null) {
            SubtabComponent selectedSubtab = selectedTab.getSubtabByName(subtabName);
            if (selectedSubtab == null) {
                throw new IllegalStateException("'" + subtabName + "' is not a valid subtab name for the '" + selectedTab.getName() + "' tab.");
            }
            selectedSubtab.setSelected(true);
        }
    }

    @NotNull
    public List<TabComponent> getTabs() {
        ArrayList<TabComponent> tabs = new ArrayList<TabComponent>();
        if (this.getChildCount() == 0) {
            return tabs;
        }
        List children = this.getChildren();
        for (UIComponent child : children) {
            if (!(child instanceof TabComponent)) continue;
            tabs.add((TabComponent)child);
        }
        return tabs;
    }

    @Nullable
    public TabComponent getTabByName(String tabName) {
        TabComponent selectedTab = null;
        for (TabComponent tab : this.getTabs()) {
            if (!tab.getName().equals(tabName)) continue;
            selectedTab = tab;
            break;
        }
        return selectedTab;
    }

    @NotNull
    public TabComponent getSelectedTab() {
        List tabs = this.getTabs();
        for (TabComponent tab : tabs) {
            if (!tab.isSelected()) continue;
            return tab;
        }
        throw new IllegalStateException("No tab is selected.");
    }

    public Object saveState(FacesContext facesContext) {
        if (this.stateValues == null) {
            this.stateValues = new Object[2];
        }
        this.stateValues[0] = super.saveState(facesContext);
        this.stateValues[1] = this.selectedTabName;
        return this.stateValues;
    }

    public void restoreState(FacesContext context, Object stateValues) {
        this.stateValues = (Object[])stateValues;
        super.restoreState(context, this.stateValues[0]);
        this.selectedTabName = (String)this.stateValues[1];
    }
}

