/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.common.time;

import com.sun.faces.util.MessageUtils;
import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.Renderer;
import org.rhq.core.gui.util.FacesContextUtility;
import org.rhq.enterprise.gui.common.time.DurationComponent;

public class DurationRenderer
extends Renderer {
    public void decode(FacesContext context, UIComponent component) {
        super.decode(context, component);
        if (context == null) {
            throw new NullPointerException(MessageUtils.getExceptionMessageString((String)"com.sun.faces.NULL_PARAMETERS_ERROR", (Object[])new Object[]{"context"}));
        }
        if (component == null) {
            throw new NullPointerException(MessageUtils.getExceptionMessageString((String)"com.sun.faces.NULL_PARAMETERS_ERROR", (Object[])new Object[]{"component"}));
        }
        if (!component.isRendered()) {
            return;
        }
        if (!(component instanceof DurationComponent)) {
            return;
        }
        DurationComponent duration = (DurationComponent)component;
        duration.setValue(this.getDurationValue());
        duration.setUnit(this.getDurationUnit());
    }

    public int getDurationValue() {
        return (Integer)FacesContextUtility.getRequiredRequestParameter((String)"durationComponentValue", Integer.class);
    }

    public String getDurationUnit() {
        return (String)FacesContextUtility.getRequiredRequestParameter((String)"durationComponentUnit", String.class);
    }

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        super.encodeBegin(context, component);
        ResponseWriter writer = context.getResponseWriter();
        DurationComponent duration = (DurationComponent)component;
        writer.startElement("input", (UIComponent)duration);
        writer.writeAttribute("id", (Object)"durationComponentValue", null);
        writer.writeAttribute("name", (Object)"durationComponentValue", null);
        writer.writeAttribute("style", (Object)"width: 50px;", null);
        writer.writeAttribute("value", (Object)duration.getValue(), "durationComponentValue");
        writer.endElement("input");
        writer.write(" ");
        writer.startElement("select", (UIComponent)duration);
        writer.writeAttribute("id", (Object)"durationComponentUnit", null);
        writer.writeAttribute("name", (Object)"durationComponentUnit", null);
        for (DurationComponent.TimeUnit unit : duration.getUnitOptions()) {
            writer.startElement("option", (UIComponent)duration);
            writer.writeAttribute("value", (Object)unit.name(), null);
            if (unit.name().equals(duration.getUnit())) {
                writer.writeAttribute("SELECTED", (Object)"SELECTED", null);
            }
            writer.write(unit.getDisplayName());
            writer.endElement("option");
        }
        writer.endElement("select");
    }
}

