/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.legacy.action.resource.common.monitor.visibility;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.tiles.ComponentContext;
import org.apache.struts.tiles.actions.TilesAction;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.measurement.DataType;
import org.rhq.core.domain.measurement.ui.MetricDisplaySummary;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.domain.resource.composite.ResourceWithAvailability;
import org.rhq.core.domain.resource.group.composite.AutoGroupComposite;
import org.rhq.enterprise.gui.legacy.WebUser;
import org.rhq.enterprise.gui.legacy.util.RequestUtils;
import org.rhq.enterprise.gui.legacy.util.SessionUtils;
import org.rhq.enterprise.gui.uibeans.AutoGroupCompositeDisplaySummary;
import org.rhq.enterprise.gui.util.WebUtility;
import org.rhq.enterprise.server.measurement.MeasurementChartsManagerLocal;
import org.rhq.enterprise.server.measurement.MeasurementDataManagerLocal;
import org.rhq.enterprise.server.measurement.MeasurementException;
import org.rhq.enterprise.server.measurement.MeasurementPreferences;
import org.rhq.enterprise.server.resource.ResourceManagerLocal;
import org.rhq.enterprise.server.resource.ResourceTypeManagerLocal;
import org.rhq.enterprise.server.resource.ResourceTypeNotFoundException;
import org.rhq.enterprise.server.util.LookupUtil;

public class ListChildrenAction
extends TilesAction {
    protected static final Log log = LogFactory.getLog(ListChildrenAction.class);
    MeasurementDataManagerLocal dataManager;
    MeasurementChartsManagerLocal chartsManager;

    /*
     * Enabled aggressive block sorting
     */
    public ActionForward execute(ComponentContext context, ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ArrayList<AutoGroupCompositeDisplaySummary> displaySummary;
        this.dataManager = LookupUtil.getMeasurementDataManager();
        this.chartsManager = LookupUtil.getMeasurementChartsManager();
        WebUser user = SessionUtils.getWebUser((HttpSession)request.getSession());
        Subject subject = user.getSubject();
        Resource resource = (Resource)request.getAttribute("Resource");
        MeasurementPreferences preferences = user.getMeasurementPreferences();
        MeasurementPreferences.MetricRangePreferences rangePreferences = preferences.getMetricRangePreferences();
        long begin = rangePreferences.begin;
        long end = rangePreferences.end;
        int parentId = -1;
        int resourceTypeId = -1;
        if (resource == null) {
            parentId = WebUtility.getOptionalIntRequestParameter((ServletRequest)request, (String)"parent", (int)-1);
            if (parentId <= 0) {
                RequestUtils.setError((HttpServletRequest)request, (String)"resource.common.error.ResourceNotFound");
                return null;
            }
            resourceTypeId = WebUtility.getOptionalIntRequestParameter((ServletRequest)request, (String)"type", (int)-1);
            ArrayList children = this.getAutoGroupChildren(subject, parentId, resourceTypeId);
            if (children == null) {
                children = new ArrayList();
            }
            displaySummary = new ArrayList(children.size() + 1);
            ResourceManagerLocal resourceManager = LookupUtil.getResourceManager();
            AutoGroupComposite parentComposite = resourceManager.getResourceAutoGroup(subject, parentId);
            if (parentComposite != null) {
                parentComposite.setMainResource(true);
                List metricSummaries = null;
                metricSummaries = this.chartsManager.getMetricDisplaySummariesForMetrics(subject, parentId, DataType.MEASUREMENT, begin, end, true, true);
                displaySummary.add(0, new AutoGroupCompositeDisplaySummary(parentComposite, metricSummaries));
            }
            ArrayList<Integer> resourceIds = new ArrayList<Integer>();
            for (AutoGroupComposite child : children) {
                List resources = child.getResources();
                ResourceWithAvailability rwa = (ResourceWithAvailability)resources.get(0);
                resourceIds.add(rwa.getResource().getId());
            }
            Map summaries = this.dataManager.findNarrowedMetricDisplaySummariesForResourcesAndParent(subject, resourceTypeId, parentId, resourceIds, begin, end);
            for (AutoGroupComposite child : children) {
                if (parentComposite != null) {
                    child.increaseDepth(1);
                }
                List resources = child.getResources();
                ResourceWithAvailability rwa = (ResourceWithAvailability)resources.get(0);
                List sumList = (List)summaries.get(rwa.getResource().getId());
                displaySummary.add(new AutoGroupCompositeDisplaySummary(child, sumList));
            }
        } else {
            List children = this.getResourceChildren(resource, subject);
            displaySummary = new ArrayList<AutoGroupCompositeDisplaySummary>(children.size());
            for (AutoGroupComposite child : children) {
                List metrics = this.getMetrics(resource, child, subject, begin, end);
                displaySummary.add(new AutoGroupCompositeDisplaySummary(child, metrics));
            }
        }
        context.putAttribute("summaries", displaySummary);
        return null;
    }

    public List<MetricDisplaySummary> getMetrics(Resource parentResource, AutoGroupComposite resourceGroupComposite, Subject subject, long beginTime, long endTime) throws MeasurementException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("finding metric summaries for resourceType [" + resourceGroupComposite.getResourceType().getName()));
        }
        List metricSummaries = null;
        List resources = resourceGroupComposite.getResources();
        if (resources != null && resources.size() == 1) {
            ResourceWithAvailability resource = (ResourceWithAvailability)resources.get(0);
            metricSummaries = this.chartsManager.getMetricDisplaySummariesForMetrics(subject, resource.getResource().getId(), DataType.MEASUREMENT, beginTime, endTime, true, true);
        } else if (resources != null && resources.size() > 1) {
            ArrayList<Resource> res = new ArrayList<Resource>();
            for (Object o : resources) {
                if (!(o instanceof ResourceWithAvailability)) continue;
                ResourceWithAvailability rwa = (ResourceWithAvailability)o;
                res.add(rwa.getResource());
            }
            Map sumMap = this.dataManager.findNarrowedMetricDisplaySummariesForCompatibleResources(subject, res, beginTime, endTime);
            metricSummaries = (List)sumMap.values().iterator().next();
            for (MetricDisplaySummary tmp : metricSummaries) {
                tmp.setParentId(parentResource.getId());
                tmp.setChildTypeId(resourceGroupComposite.getResourceType().getId());
            }
        }
        return metricSummaries;
    }

    private List<AutoGroupComposite> getResourceChildren(Resource resource, Subject subject) {
        ResourceManagerLocal resourceManager = LookupUtil.getResourceManager();
        List children = resourceManager.findChildrenAutoGroups(subject, resource.getId());
        AutoGroupComposite resourceGroupComposite = resourceManager.getResourceAutoGroup(subject, resource.getId());
        if (resourceGroupComposite == null) {
            return new ArrayList<AutoGroupComposite>();
        }
        resourceGroupComposite.setMainResource(true);
        for (AutoGroupComposite child : children) {
            child.setDepth(child.getDepth() + 1);
        }
        children.add(0, resourceGroupComposite);
        Resource parentResource = resourceManager.getParentResource(resource.getId());
        AutoGroupComposite parentGroupComposite = null;
        if (parentResource != null) {
            parentGroupComposite = resourceManager.getResourceAutoGroup(subject, parentResource.getId());
        }
        if (parentGroupComposite != null) {
            for (AutoGroupComposite child : children) {
                child.increaseDepth(1);
            }
            children.add(0, parentGroupComposite);
        }
        return children;
    }

    private List<AutoGroupComposite> getAutoGroupChildren(Subject subject, int parentId, int resourceTypeId) {
        ArrayList<AutoGroupComposite> children = new ArrayList<AutoGroupComposite>();
        ResourceManagerLocal resourceManager = LookupUtil.getResourceManager();
        ResourceTypeManagerLocal resourceTypeMananger = LookupUtil.getResourceTypeManager();
        Resource parentResource = resourceManager.getResourceById(subject, parentId);
        ResourceType resourceType = null;
        try {
            resourceType = resourceTypeMananger.getResourceTypeById(subject, resourceTypeId);
        }
        catch (ResourceTypeNotFoundException e) {
            return children;
        }
        if (resourceType != null && parentResource != null) {
            List resourcesForAutoGroup = resourceManager.findResourcesByParentAndType(subject, parentResource, resourceType);
            int i = 0;
            int[] resourceIds = new int[resourcesForAutoGroup.size()];
            for (ResourceWithAvailability resourceInAutoGroup : resourcesForAutoGroup) {
                int id = resourceInAutoGroup.getResource().getId();
                resourceIds[i++] = id;
            }
            List composites = resourceManager.findResourcesAutoGroups(subject, resourceIds);
            return composites;
        }
        return children;
    }
}

