/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.navigation.resource;

import java.util.Set;
import java.util.TreeSet;
import org.rhq.core.domain.resource.composite.ResourceWithAvailability;
import org.rhq.core.domain.resource.flyweight.AutoGroupCompositeFlyweight;
import org.rhq.core.domain.resource.flyweight.ResourceFlyweight;
import org.rhq.core.util.sort.HumaneStringComparator;

public class ResourceTreeNode
implements Comparable<ResourceTreeNode> {
    private Set<ResourceTreeNode> children = new TreeSet();
    private Object level;
    private ResourceTreeNode parent;

    public ResourceTreeNode(Object level) {
        this.level = level;
    }

    public ResourceTreeNode(Object level, ResourceTreeNode parent) {
        this.level = level;
        this.parent = parent;
    }

    public Set<ResourceTreeNode> getChildren() {
        return this.children;
    }

    public Object getData() {
        return this.level;
    }

    public ResourceTreeNode getParent() {
        return this.parent;
    }

    public void setParent(ResourceTreeNode parent) {
        this.parent = parent;
    }

    public String getNodeType() {
        if (this.level instanceof AutoGroupCompositeFlyweight) {
            return "AutoGroupComposite";
        }
        if (this.level instanceof ResourceFlyweight) {
            return ((ResourceFlyweight)this.level).isLocked() ? "LockedResource" : "Resource";
        }
        return this.level.getClass().getSimpleName();
    }

    public String toString() {
        if (this.level == null) {
            return "";
        }
        if (this.level instanceof AutoGroupCompositeFlyweight) {
            AutoGroupCompositeFlyweight composite = (AutoGroupCompositeFlyweight)this.level;
            return composite.getName();
        }
        if (this.level instanceof ResourceWithAvailability) {
            return ((ResourceWithAvailability)this.level).getResource().getName();
        }
        if (this.level instanceof ResourceFlyweight) {
            ResourceFlyweight fly = (ResourceFlyweight)this.level;
            String name = fly.getName();
            if (fly.isLocked()) {
                name = name + " (locked)";
            }
            return name;
        }
        return this.level.toString();
    }

    @Override
    public int compareTo(ResourceTreeNode that) {
        int i = HumaneStringComparator.DEFAULT.compare(this.toString(), that.toString());
        if (i == 0) {
            i = new Integer(this.level.hashCode()).compareTo(that.level.hashCode());
        }
        return i;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceTreeNode that = (ResourceTreeNode)o;
        return this.level.equals(that.level);
    }

    public int hashCode() {
        return this.level.hashCode();
    }
}

