/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.startup;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Properties;
import java.util.logging.LogManager;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertyDynamicType;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.gui.configuration.helper.DynamicPropertyRetriever;
import org.rhq.core.gui.configuration.helper.PropertyRenderingUtility;
import org.rhq.enterprise.gui.configuration.DatabaseDynamicPropertyRetriever;
import org.rhq.enterprise.server.util.LookupUtil;

public final class Configurator
implements ServletContextListener {
    private static final Log LOG = LogFactory.getLog((String)Configurator.class.getName());
    private static final String SERVER_INTERNALS_FILE = "/WEB-INF/rhq-server-internals.properties";
    private static final String DEFAULT_USER_PREFERENCES_FILE = "/WEB-INF/DefaultUserPreferences.properties";
    private static final String TAGLIB_PROPERTIES_FILE = "/WEB-INF/taglib.properties";
    private static final String LOGGING_PROPERTIES_RESOURCE = "logging.properties";
    private static final String SYSPROP_KEY = "org.jboss.on.sysprop";

    public void contextInitialized(ServletContextEvent sce) {
        ServletContext ctx = sce.getServletContext();
        this.loadConfig(ctx);
        this.loadPreferences(ctx);
        this.loadTablePreferences(ctx);
        this.loadBuildVersion(ctx);
        this.loadJavaLoggingConfiguration();
        this.registerDynamicPropertyRetrievers();
    }

    public void contextDestroyed(ServletContextEvent sce) {
    }

    private void loadConfig(ServletContext ctx) {
        Properties props;
        try {
            props = this.loadProperties(ctx, SERVER_INTERNALS_FILE);
        }
        catch (Exception e) {
            LOG.error((Object)"unable to load server internals file [/WEB-INF/rhq-server-internals.properties]", (Throwable)e);
            return;
        }
        if (props == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"server internals file [/WEB-INF/rhq-server-internals.properties] does not exist");
            }
            return;
        }
        Enumeration<?> names = props.propertyNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            if (name.startsWith(SYSPROP_KEY)) {
                System.setProperty(name, props.getProperty(name));
                continue;
            }
            ctx.setAttribute(name, (Object)props.getProperty(name));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"loaded server internals [/WEB-INF/rhq-server-internals.properties]");
        }
    }

    private void loadPreferences(ServletContext ctx) {
        try {
            Configuration userPrefs = new Configuration();
            Properties userProps = this.loadProperties(ctx, DEFAULT_USER_PREFERENCES_FILE);
            Enumeration<Object> keys = userProps.keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                userPrefs.put((Property)new PropertySimple(key, (Object)userProps.getProperty(key)));
            }
            ctx.setAttribute("userPrefs", (Object)userPrefs);
        }
        catch (Exception e) {
            LOG.error((Object)"failed to load user preferences at [/WEB-INF/DefaultUserPreferences.properties]: ", (Throwable)e);
        }
    }

    private void loadTablePreferences(ServletContext ctx) {
        try {
            Properties tableProps = this.loadProperties(ctx, TAGLIB_PROPERTIES_FILE);
            ctx.setAttribute("display", (Object)tableProps);
        }
        catch (Exception e) {
            LOG.error((Object)"failed to load the taglib properties at [/WEB-INF/taglib.properties]: ", (Throwable)e);
        }
    }

    private void loadBuildVersion(ServletContext servletContext) {
        String version = LookupUtil.getCoreServer().getVersion();
        servletContext.setAttribute("RHQVersion", (Object)version);
    }

    private Properties loadProperties(ServletContext context, String filename) throws Exception {
        Properties props = new Properties();
        InputStream is = context.getResourceAsStream(filename);
        if (is != null) {
            props.load(is);
            is.close();
        }
        return props;
    }

    private void loadJavaLoggingConfiguration() {
        InputStream loggingPropertiesStream = Configurator.class.getClassLoader().getResourceAsStream(LOGGING_PROPERTIES_RESOURCE);
        if (loggingPropertiesStream != null) {
            try {
                LogManager.getLogManager().readConfiguration(loggingPropertiesStream);
            }
            catch (IOException e) {
                LOG.error((Object)"Failed to load 'logging.properties' from webapp classloader.");
            }
        }
    }

    private void registerDynamicPropertyRetrievers() {
        PropertyRenderingUtility.putDynamicPropertyRetriever((PropertyDynamicType)PropertyDynamicType.DATABASE, (DynamicPropertyRetriever)new DatabaseDynamicPropertyRetriever());
    }
}

