/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.admin.plugin;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.faces.application.FacesMessage;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.domain.plugin.ServerPlugin;
import org.rhq.core.gui.util.FacesContextUtility;
import org.rhq.enterprise.gui.admin.plugin.AbstractPluginConfigurationUIBean;
import org.rhq.enterprise.gui.util.EnterpriseFacesContextUtility;
import org.rhq.enterprise.server.plugin.ServerPluginManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

public class EditPluginConfigurationUIBean
extends AbstractPluginConfigurationUIBean
implements Serializable {
    private Configuration currentConfiguration;
    private ConfigurationDefinition currentConfigurationDefinition;

    public Configuration getCurrentConfiguration() {
        return this.currentConfiguration;
    }

    public ConfigurationDefinition getCurrentConfigurationDefinition() {
        return this.currentConfigurationDefinition;
    }

    public void init() {
        this.checkPermission();
        this.lookupConfigDefinitions();
    }

    public void setCurrentPlugin(ServerPlugin currentPlugin) {
        if (currentPlugin != null) {
            this.setPlugin(currentPlugin);
        }
    }

    public void setListName(String listName) {
        ServerPlugin plugin = this.getPlugin();
        if (listName != null && plugin != null) {
            if (this.hasListName(plugin.getPluginConfiguration(), listName)) {
                this.currentConfiguration = plugin.getPluginConfiguration();
                this.currentConfigurationDefinition = this.getPluginConfigurationDefinition();
            } else if (this.hasListName(plugin.getScheduledJobsConfiguration(), listName)) {
                this.currentConfiguration = plugin.getScheduledJobsConfiguration();
                this.currentConfigurationDefinition = this.getScheduledJobsDefinition();
            }
        }
    }

    private boolean hasListName(Configuration config, String listName) {
        if (config != null) {
            return config.getList(listName) != null;
        }
        return false;
    }

    public String finishMap() {
        FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_INFO, (String)"Map updated.");
        return "success";
    }

    public String updatePlugin() {
        try {
            ServerPluginManagerLocal serverPlugins = LookupUtil.getServerPluginManager();
            Subject subject = EnterpriseFacesContextUtility.getSubject();
            ServerPlugin plugin = serverPlugins.updateServerPluginExceptContent(subject, this.getPlugin());
            this.setPlugin(plugin);
            if (plugin.isEnabled()) {
                serverPlugins.enableServerPlugins(subject, this.getPluginIdList());
            }
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_INFO, (String)"Configuration settings saved.");
        }
        catch (Exception e) {
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)"There was an error changing the configuration settings.", (Throwable)e);
            return null;
        }
        return "success";
    }

    private List<Integer> getPluginIdList() {
        ArrayList<Integer> idList = new ArrayList<Integer>(1);
        ServerPlugin plugin = this.getPlugin();
        if (plugin != null) {
            idList.add(plugin.getId());
        }
        return idList;
    }
}

